/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store.fs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import org.h2.store.fs.FileObject;
import org.h2.store.fs.FileSystemDisk;
import org.h2.store.fs.FileSystemDiskNio;
import org.h2.store.fs.FileSystemDiskNioMapped;
import org.h2.store.fs.FileSystemMemory;
import org.h2.store.fs.FileSystemSplit;
import org.h2.store.fs.FileSystemZip;
import org.h2.util.New;

public abstract class FileSystem {
    public static final String PREFIX_MEMORY = "memFS:";
    public static final String PREFIX_MEMORY_LZF = "memLZF:";
    public static final String PREFIX_ZIP = "zip:";
    public static final String PREFIX_SPLIT = "split:";
    public static final String PREFIX_NIO = "nio:";
    public static final String PREFIX_NIO_MAPPED = "nioMapped:";
    private static final ArrayList<FileSystem> SERVICES = New.arrayList();

    public static FileSystem getInstance(String string) {
        if (FileSystem.isInMemory(string)) {
            return FileSystemMemory.getInstance();
        }
        if (string.startsWith(PREFIX_ZIP)) {
            return FileSystemZip.getInstance();
        }
        if (string.startsWith(PREFIX_SPLIT)) {
            return FileSystemSplit.getInstance();
        }
        if (string.startsWith(PREFIX_NIO)) {
            return FileSystemDiskNio.getInstance();
        }
        if (string.startsWith(PREFIX_NIO_MAPPED)) {
            return FileSystemDiskNioMapped.getInstance();
        }
        for (FileSystem fileSystem : SERVICES) {
            if (!fileSystem.accepts(string)) continue;
            return fileSystem;
        }
        return FileSystemDisk.getInstance();
    }

    public static synchronized void register(FileSystem fileSystem) {
        SERVICES.add(fileSystem);
    }

    public static synchronized void unregister(FileSystem fileSystem) {
        SERVICES.remove(fileSystem);
    }

    protected boolean accepts(String string) {
        return false;
    }

    private static boolean isInMemory(String string) {
        return string != null && (string.startsWith(PREFIX_MEMORY) || string.startsWith(PREFIX_MEMORY_LZF));
    }

    public abstract long length(String var1);

    public abstract void rename(String var1, String var2) throws SQLException;

    public abstract boolean createNewFile(String var1) throws SQLException;

    public abstract boolean exists(String var1);

    public abstract void delete(String var1) throws SQLException;

    public abstract boolean tryDelete(String var1);

    public abstract String createTempFile(String var1, String var2, boolean var3, boolean var4) throws IOException;

    public abstract String[] listFiles(String var1) throws SQLException;

    public abstract void deleteRecursive(String var1, boolean var2) throws SQLException;

    public abstract boolean isReadOnly(String var1);

    public abstract String normalize(String var1) throws SQLException;

    public abstract String getParent(String var1);

    public abstract boolean isDirectory(String var1);

    public abstract boolean isAbsolute(String var1);

    public abstract String getAbsolutePath(String var1);

    public abstract long getLastModified(String var1);

    public abstract boolean canWrite(String var1);

    public abstract void copy(String var1, String var2) throws SQLException;

    public void mkdirs(String string) throws SQLException {
        this.createDirs(string + "/x");
    }

    public abstract void createDirs(String var1) throws SQLException;

    public abstract String getFileName(String var1);

    public abstract boolean fileStartsWith(String var1, String var2);

    public abstract OutputStream openFileOutputStream(String var1, boolean var2) throws SQLException;

    public abstract FileObject openFileObject(String var1, String var2) throws IOException;

    public abstract InputStream openFileInputStream(String var1) throws IOException;
}

