/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs;

import com.terracottatech.frs.action.Action;
import com.terracottatech.frs.action.ActionCodec;
import com.terracottatech.frs.action.ActionFactory;
import com.terracottatech.frs.compaction.Compactor;
import com.terracottatech.frs.object.ObjectManager;
import com.terracottatech.frs.util.ByteBufferUtils;
import java.nio.ByteBuffer;

class DeleteAction
implements Action {
    public static final ActionFactory<ByteBuffer, ByteBuffer, ByteBuffer> FACTORY = new ActionFactory<ByteBuffer, ByteBuffer, ByteBuffer>(){

        @Override
        public Action create(ObjectManager<ByteBuffer, ByteBuffer, ByteBuffer> objectManager, ActionCodec codec, ByteBuffer[] buffers) {
            return new DeleteAction(objectManager, null, ByteBufferUtils.getFirstNonEmpty(buffers), false);
        }
    };
    private final ObjectManager<ByteBuffer, ?, ?> objectManager;
    private final Compactor compactor;
    private final ByteBuffer id;

    DeleteAction(ObjectManager<ByteBuffer, ?, ?> objectManager, Compactor compactor, ByteBuffer id, boolean recovery) {
        this.objectManager = objectManager;
        this.compactor = compactor;
        this.id = id;
        if (recovery) {
            throw new IllegalStateException("Delete is unsupported during recovery.");
        }
    }

    ByteBuffer getId() {
        return this.id;
    }

    @Override
    public void record(long lsn) {
        this.objectManager.delete(this.id);
        this.compactor.compactNow();
    }

    @Override
    public void replay(long lsn) {
    }

    @Override
    public ByteBuffer[] getPayload(ActionCodec codec) {
        return new ByteBuffer[]{this.id.slice()};
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeleteAction that = (DeleteAction)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }
}

