/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs;

import com.terracottatech.frs.MapActions;
import com.terracottatech.frs.RestartStore;
import com.terracottatech.frs.RestartStoreException;
import com.terracottatech.frs.RestartStoreImpl;
import com.terracottatech.frs.action.ActionCodec;
import com.terracottatech.frs.action.ActionCodecImpl;
import com.terracottatech.frs.action.ActionManager;
import com.terracottatech.frs.action.ActionManagerImpl;
import com.terracottatech.frs.compaction.CompactionActions;
import com.terracottatech.frs.config.Configuration;
import com.terracottatech.frs.io.nio.NIOManager;
import com.terracottatech.frs.log.LogManager;
import com.terracottatech.frs.log.MasterLogRecordFactory;
import com.terracottatech.frs.log.StagingLogManager;
import com.terracottatech.frs.object.ObjectManager;
import com.terracottatech.frs.transaction.TransactionActions;
import com.terracottatech.frs.transaction.TransactionManager;
import com.terracottatech.frs.transaction.TransactionManagerImpl;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Properties;

public abstract class RestartStoreFactory {
    private RestartStoreFactory() {
    }

    private static ActionCodec<ByteBuffer, ByteBuffer, ByteBuffer> createCodec(ObjectManager<ByteBuffer, ByteBuffer, ByteBuffer> objectManager) {
        ActionCodecImpl<ByteBuffer, ByteBuffer, ByteBuffer> codec = new ActionCodecImpl<ByteBuffer, ByteBuffer, ByteBuffer>(objectManager);
        MapActions.registerActions(0, codec);
        TransactionActions.registerActions(1, codec);
        CompactionActions.registerActions(2, codec);
        return codec;
    }

    public static RestartStore<ByteBuffer, ByteBuffer, ByteBuffer> createStore(ObjectManager<ByteBuffer, ByteBuffer, ByteBuffer> objectManager, File dbHome, Properties properties) throws IOException, RestartStoreException {
        Configuration configuration = Configuration.getConfiguration(dbHome, properties);
        NIOManager ioManager = new NIOManager(configuration);
        StagingLogManager logManager = new StagingLogManager(ioManager, configuration);
        ActionManagerImpl actionManager = new ActionManagerImpl(logManager, objectManager, RestartStoreFactory.createCodec(objectManager), new MasterLogRecordFactory());
        TransactionManagerImpl transactionManager = new TransactionManagerImpl(actionManager);
        return new RestartStoreImpl(objectManager, (TransactionManager)transactionManager, (LogManager)logManager, (ActionManager)actionManager, ioManager, configuration);
    }

    public static RestartStore<ByteBuffer, ByteBuffer, ByteBuffer> createStore(ObjectManager<ByteBuffer, ByteBuffer, ByteBuffer> objectManager, File dbHome, long fileSize) throws IOException, RestartStoreException {
        Properties properties = new Properties();
        properties.setProperty("io.nio.segmentSize", Long.toString(fileSize));
        return RestartStoreFactory.createStore(objectManager, dbHome, properties);
    }
}

