/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.config;

import com.terracottatech.frs.config.FrsProperty;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class Configuration {
    public static final String USER_PROPERTIES_FILE = "frs.properties";
    private final EnumMap<FrsProperty, Object> configuration;
    private final File dbHome;

    private Configuration(File home, Map<FrsProperty, Object> properties) {
        this.configuration = new EnumMap<FrsProperty, Object>(properties);
        this.dbHome = home;
    }

    public static Configuration getConfiguration(File directory, Properties overrides) {
        EnumMap<FrsProperty, Object> configuration = new EnumMap<FrsProperty, Object>(FrsProperty.class);
        configuration.putAll(Configuration.extractConfiguration(Configuration.getUserProperties(directory), true, false));
        configuration.putAll(Configuration.extractConfiguration(overrides, true, false));
        configuration.putAll(Configuration.extractConfiguration(System.getProperties(), false, true));
        return new Configuration(directory, configuration);
    }

    public static Configuration getConfiguration(File directory) {
        return Configuration.getConfiguration(directory, new Properties());
    }

    public Object getConfigurationValue(FrsProperty property) {
        Object value = this.configuration.get((Object)property);
        return value == null ? property.defaultValue() : value;
    }

    public String getString(FrsProperty property) {
        return (String)this.getConfigurationValue(property);
    }

    public Integer getInt(FrsProperty property) {
        return (Integer)this.getConfigurationValue(property);
    }

    public Long getLong(FrsProperty property) {
        return (Long)this.getConfigurationValue(property);
    }

    public Double getDouble(FrsProperty property) {
        return (Double)this.getConfigurationValue(property);
    }

    public Float getFloat(FrsProperty property) {
        return (Float)this.getConfigurationValue(property);
    }

    public Boolean getBoolean(FrsProperty property) {
        return (Boolean)this.getConfigurationValue(property);
    }

    public File getDBHome() {
        return this.dbHome;
    }

    public String toString() {
        return this.configuration.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties getUserProperties(File directory) {
        Properties properties = new Properties();
        File useFile = new File(directory, USER_PROPERTIES_FILE);
        if (useFile.exists()) {
            try {
                FileInputStream fis = new FileInputStream(useFile);
                try {
                    properties.load(fis);
                }
                finally {
                    fis.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to read user frs configuration.", e);
            }
        }
        return properties;
    }

    private static Map<FrsProperty, Object> extractConfiguration(Properties properties, boolean shortNames, boolean tolerateMismatches) {
        EnumMap<FrsProperty, Object> configuration = new EnumMap<FrsProperty, Object>(FrsProperty.class);
        if (tolerateMismatches) {
            for (FrsProperty property : FrsProperty.values()) {
                String propertyName = shortNames ? property.shortName() : property.property();
                String value = (String)properties.get(propertyName);
                if (value == null) continue;
                configuration.put(property, property.convert(value));
            }
        } else {
            HashMap<Object, Object> map = new HashMap<Object, Object>(properties);
            for (FrsProperty property : FrsProperty.values()) {
                String propertyName = shortNames ? property.shortName() : property.property();
                String value = (String)map.remove(propertyName);
                if (value == null) continue;
                configuration.put(property, property.convert(value));
            }
            if (!map.isEmpty()) {
                throw new IllegalArgumentException("Unrecognized properties: " + map);
            }
        }
        return configuration;
    }
}

