/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.io.nio;

import com.terracottatech.frs.io.Chunk;
import com.terracottatech.frs.io.Direction;
import com.terracottatech.frs.io.FileBuffer;
import com.terracottatech.frs.io.IOManager;
import com.terracottatech.frs.io.nio.AbstractReadbackStrategy;
import com.terracottatech.frs.io.nio.SegmentHeaders;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntegrityReadbackStrategy
extends AbstractReadbackStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(IOManager.class);
    private final FileBuffer buffer;
    private final ArrayList<Long> jumpList = new ArrayList();
    private long lastGood = 0L;
    private long lastMarker = 0L;
    private boolean primed = false;
    private boolean done = false;
    private int exitStatus;

    public IntegrityReadbackStrategy(FileBuffer src) {
        this.buffer = src;
    }

    @Override
    public boolean hasMore(Direction dir) throws IOException {
        if (this.done) {
            return false;
        }
        if (this.buffer.size() - this.buffer.position() < 12L) {
            return false;
        }
        this.prime();
        int check = this.buffer.peekInt();
        if (SegmentHeaders.CLOSE_FILE.validate(check)) {
            this.exitStatus = check;
            return false;
        }
        return true;
    }

    private void prime() throws IOException {
        if (this.primed) {
            return;
        }
        this.buffer.clear();
        this.buffer.partition(12);
        this.buffer.read(1);
        this.primed = true;
    }

    @Override
    public Chunk iterate(Direction dir) throws IOException {
        try {
            if (dir != Direction.FORWARD) {
                throw new IOException("only forward movement allowed");
            }
            this.prime();
            byte[] check = new byte[4];
            this.buffer.get(check);
            if (SegmentHeaders.CHUNK_START.validate(check)) {
                long size = this.buffer.getLong();
                long moveTo = this.buffer.position() + size;
                if (moveTo >= this.buffer.size() + 20L) {
                    throw new EOFException();
                }
                this.buffer.clear();
                this.buffer.position(moveTo);
                this.buffer.partition(20);
                this.buffer.read(1);
                long clen = this.buffer.getLong();
                if (clen != size) {
                    throw new IOException("inconsistent");
                }
                this.lastMarker = this.buffer.getLong();
                if (SegmentHeaders.FILE_CHUNK.validate(this.buffer.getInt())) {
                    this.lastGood = this.buffer.position();
                }
            } else {
                throw new IOException(new String(check));
            }
            this.jumpList.add(this.buffer.position());
        }
        catch (Exception ioe) {
            this.logPosition(ioe);
            this.done = true;
            if (ioe instanceof IOException) {
                throw (IOException)ioe;
            }
            throw new IOException(ioe);
        }
        this.primed = false;
        return null;
    }

    private void logPosition(Exception e) {
        if (LOGGER.isDebugEnabled()) {
            try {
                LOGGER.debug(new Formatter(new StringBuilder()).format("io error checking integrity file: %s last valid pos: %d current pos: %d last valid marker: %d", this.buffer.toString(), this.getLastValidPosition(), this.buffer.position(), this.getLastValidMarker()).out().toString(), (Throwable)e);
            }
            catch (Throwable t) {
                LOGGER.debug("unexpected", t);
            }
        }
    }

    long getLastValidPosition() {
        return this.lastGood;
    }

    long getLastValidMarker() {
        return this.lastMarker;
    }

    List<Long> getJumpList() {
        return this.jumpList;
    }

    boolean wasClosed() {
        return SegmentHeaders.CLOSE_FILE.validate(this.exitStatus);
    }
}

