/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.io.nio;

import com.terracottatech.frs.io.Chunk;
import com.terracottatech.frs.io.Direction;
import com.terracottatech.frs.io.GCBufferSource;
import com.terracottatech.frs.io.nio.NIOSegmentImpl;
import com.terracottatech.frs.io.nio.NIOSegmentList;
import com.terracottatech.frs.log.LogRecord;
import com.terracottatech.frs.log.LogRegionPacker;
import com.terracottatech.frs.log.Signature;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;

public class IntegrityTool {
    private long lowestLsn = 0L;
    private long max = 0L;
    private int currentSegment = -1;
    private final File dir;

    public IntegrityTool(File f) {
        this.dir = f;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println("usage: java com.terracottatech.frs.io.nio.IntegrityTool  <<path to stream directory>>");
            return;
        }
        try {
            File dir = new File(args[0]);
            if (!dir.exists()) {
                System.err.println("stream directory does not exist");
                System.exit(99);
            }
            if (!dir.isDirectory()) {
                System.err.println("stream directory is not valid");
                System.exit(99);
            }
            System.err.println("examining " + dir.getAbsolutePath());
            new IntegrityTool(dir).examine();
        }
        catch (Exception ioe) {
            System.err.println("error processing directory -- " + ioe.getMessage());
        }
    }

    public void examine() throws Exception {
        if (!this.dir.exists() || !this.dir.isDirectory()) {
            throw new IOException("target directory does not exist");
        }
        NIOSegmentList list = new NIOSegmentList(this.dir);
        if (list.getCount() == 0) {
            throw new IOException("no segment files for in the specified directory");
        }
        File segfile = list.nextReadFile(Direction.FORWARD);
        while (segfile != null) {
            try {
                this.lowestLsn = this.examineSegmentFile(segfile);
            }
            catch (Exception e) {
                System.out.println(segfile.getName() + " " + e.getClass().getCanonicalName() + " - " + e.getMessage());
            }
            segfile = list.nextReadFile(Direction.FORWARD);
        }
        System.out.format("lowest lsn: %d\n", this.lowestLsn);
    }

    public long examineSegmentFile(File f) throws Exception {
        if (this.dir != null && !f.getParentFile().equals(this.dir)) {
            throw new IOException("segment is not part of the current stream");
        }
        GCBufferSource src = new GCBufferSource();
        NIOSegmentImpl segment = new NIOSegmentImpl(null, f);
        segment.openForReading(src);
        int count = 0;
        int size = 0;
        int records = 0;
        int rsize = 0;
        while (segment.hasMore(Direction.REVERSE)) {
            Chunk c = segment.next(Direction.REVERSE);
            ++count;
            size = (int)((long)size + c.remaining());
            try {
                List<LogRecord> list = LogRegionPacker.unpack(Signature.ADLER32, c);
                records += list.size();
                for (LogRecord r : list) {
                    ByteBuffer[] bb;
                    for (ByteBuffer b : bb = r.getPayload()) {
                        rsize += b.remaining();
                    }
                }
            }
            catch (Exception exp) {
                System.out.println("!!!!! " + f.getName() + " " + exp.getMessage() + " for chunk " + count + " from the end of size " + size + " !!!!!");
            }
        }
        segment.openForHeader(src);
        boolean closed = segment.last();
        int thisSegment = segment.getSegmentId();
        if (this.currentSegment >= 0 && thisSegment != this.currentSegment + 1) {
            System.out.format("!!!!! Invalid Segment Sequence %d->%d !!!!!\n", this.currentSegment, thisSegment);
        }
        this.currentSegment = thisSegment;
        long thisMin = segment.getBaseMarker();
        long thisMax = segment.getMaximumMarker();
        if (this.max > 0L && thisMin != this.max + 1L) {
            System.out.format("!!!!! Invalid LSN Sequence %d->%d  !!!!!\n", this.max, thisMin);
        }
        this.max = thisMax;
        System.out.format("%s - min: %d, max: %d, chunks: %d, avg. chunk size: %d, records: %d, avg. record size: %d closed: %b\n", f.getName(), thisMin, thisMax, count, count > 0 ? size / count : 0, records, records > 0 ? rsize / records : 0, closed);
        return segment.getMinimumMarker();
    }
}

