/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.log;

import java.io.IOException;

enum LogMachineState {
    BOOTSTRAP{

        @Override
        LogMachineState progress() {
            return NORMAL;
        }

        @Override
        boolean isBootstrapping() {
            return true;
        }

        @Override
        boolean starting() {
            return true;
        }

        @Override
        boolean acceptRecords() {
            return true;
        }
    }
    ,
    NORMAL{

        @Override
        LogMachineState shutdown() {
            return SHUTDOWN;
        }

        @Override
        LogMachineState checkException(Exception e) throws RuntimeException {
            if (e instanceof InterruptedException) {
                throw new RuntimeException(e);
            }
            return super.checkException(e);
        }

        @Override
        boolean acceptRecords() {
            return true;
        }
    }
    ,
    SHUTDOWN{

        @Override
        LogMachineState idle() {
            return FINISHED;
        }
    }
    ,
    FINISHED{

        @Override
        LogMachineState reset() {
            return IDLE;
        }
    }
    ,
    ERROR{

        @Override
        LogMachineState shutdown() {
            return ERROR;
        }

        @Override
        boolean isErrorState() {
            return true;
        }

        @Override
        LogMachineState idle() {
            return FINISHED;
        }
    }
    ,
    IDLE{

        @Override
        LogMachineState bootstrap() {
            return BOOTSTRAP;
        }

        @Override
        LogMachineState shutdown() {
            return IDLE;
        }

        @Override
        boolean starting() {
            return true;
        }

        @Override
        boolean acceptRecords() {
            return true;
        }
    };


    LogMachineState progress() {
        throw new RuntimeException((Object)((Object)this) + "  -- bad state");
    }

    LogMachineState shutdown() {
        throw new RuntimeException((Object)((Object)this) + "  -- bad state");
    }

    LogMachineState idle() {
        throw new RuntimeException((Object)((Object)this) + "  -- bad state");
    }

    LogMachineState bootstrap() {
        throw new RuntimeException((Object)((Object)this) + "  -- bad state");
    }

    LogMachineState reset() {
        throw new RuntimeException((Object)((Object)this) + "  -- bad state");
    }

    boolean isErrorState() {
        return false;
    }

    boolean isBootstrapping() {
        return false;
    }

    boolean acceptRecords() {
        return false;
    }

    boolean starting() {
        return false;
    }

    LogMachineState checkException(Exception e) throws RuntimeException {
        if (e instanceof InterruptedException) {
            return this;
        }
        if (e instanceof IOException) {
            return ERROR;
        }
        throw new RuntimeException(e);
    }
}

