/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.transaction;

import com.terracottatech.frs.action.Action;
import com.terracottatech.frs.recovery.AbstractAdaptingFilter;
import com.terracottatech.frs.recovery.Filter;
import com.terracottatech.frs.transaction.TransactionAction;
import com.terracottatech.frs.transaction.TransactionHandle;
import com.terracottatech.frs.transaction.TransactionalAction;
import java.util.HashSet;
import java.util.Set;

public class TransactionFilter
extends AbstractAdaptingFilter<Action, Action> {
    private final Set<TransactionHandle> openTransactions = new HashSet<TransactionHandle>();

    public TransactionFilter(Filter<Action> nextFilter) {
        super(nextFilter);
    }

    @Override
    protected Action convert(Action element) {
        if (element instanceof TransactionalAction) {
            return ((TransactionalAction)element).getAction();
        }
        return element;
    }

    @Override
    public boolean filter(Action element, long lsn, boolean filtered) {
        if (element instanceof TransactionAction) {
            TransactionAction transactionAction = (TransactionAction)element;
            boolean replayed = true;
            if (transactionAction.isCommit() && !filtered) {
                this.openTransactions.add(transactionAction.getHandle());
            }
            if (transactionAction instanceof TransactionalAction) {
                replayed = this.openTransactions.contains(transactionAction.getHandle()) ? this.delegate(((TransactionalAction)transactionAction).getAction(), lsn, filtered) : this.delegate(((TransactionalAction)transactionAction).getAction(), lsn, true);
            }
            if (transactionAction.isBegin()) {
                this.openTransactions.remove(transactionAction.getHandle());
            }
            return replayed;
        }
        return this.delegate(element, lsn, filtered);
    }
}

