/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.search.aggregator;

import com.terracottatech.search.AggregatorOperations;
import com.terracottatech.search.ValueType;
import com.terracottatech.search.aggregator.AbstractAggregator;
import com.terracottatech.search.aggregator.Aggregator;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class Count
extends AbstractAggregator {
    private int count;

    public Count(String attributeName, ValueType type) {
        super(AggregatorOperations.COUNT, attributeName, type);
    }

    @Override
    public void accept(Object input) {
        ++this.count;
    }

    public void increment(int delta) throws IllegalArgumentException {
        if (delta < 0) {
            throw new IllegalArgumentException("argument must not be negative");
        }
        this.count += delta;
    }

    @Override
    public void accept(Aggregator incoming) throws IllegalArgumentException {
        if (incoming instanceof Count) {
            this.count += ((Count)incoming).count;
        } else {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public Integer getResult() {
        return this.count;
    }

    @Override
    Aggregator deserializeData(DataInput input) throws IOException {
        this.count = input.readInt();
        return this;
    }

    @Override
    void serializeData(DataOutput input) throws IOException {
        input.writeInt(this.count);
    }
}

