/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.search.aggregator;

import com.terracottatech.search.ValueType;
import com.terracottatech.search.aggregator.Aggregator;
import com.terracottatech.search.aggregator.Average;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class LongAverage
extends Average {
    private long sum = 0L;
    private int count = 0;

    public LongAverage(String attributeName, ValueType type) {
        super(attributeName, type);
    }

    @Override
    public void accept(Object input) throws IllegalArgumentException {
        if (input == null) {
            return;
        }
        if (!(input instanceof Number)) {
            throw new IllegalArgumentException(input.getClass().getName() + " is not a number for attribute [" + this.getAttributeName() + "]");
        }
        ++this.count;
        this.sum += ((Number)input).longValue();
    }

    @Override
    public void accept(Aggregator incoming) throws IllegalArgumentException {
        if (incoming instanceof LongAverage) {
            this.count += ((LongAverage)incoming).count;
            this.sum += ((LongAverage)incoming).sum;
        } else {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public Double getResult() {
        if (this.count == 0) {
            return null;
        }
        return (double)this.sum / (double)this.count;
    }

    @Override
    Aggregator deserializeData(DataInput input) throws IOException {
        this.sum = input.readLong();
        this.count = input.readInt();
        return this;
    }

    @Override
    void serializeData(DataOutput output) throws IOException {
        output.writeLong(this.sum);
        output.writeInt(this.count);
    }
}

