/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.offheap;

import com.terracottatech.offheapstore.exceptions.OversizeMappingException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.sf.ehcache.CacheEntry;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.Status;
import net.sf.ehcache.concurrent.CacheLockProvider;
import net.sf.ehcache.concurrent.ReadWriteLockSync;
import net.sf.ehcache.concurrent.StripedReadWriteLock;
import net.sf.ehcache.concurrent.Sync;
import net.sf.ehcache.event.RegisteredEventListeners;
import net.sf.ehcache.search.impl.SearchManager;
import net.sf.ehcache.statistics.StatisticBuilder;
import net.sf.ehcache.store.AbstractStore;
import net.sf.ehcache.store.AuthoritativeTier;
import net.sf.ehcache.store.ElementValueComparator;
import net.sf.ehcache.store.Policy;
import net.sf.ehcache.store.PressuredStore;
import net.sf.ehcache.store.Store;
import net.sf.ehcache.store.StoreOperationOutcomes;
import net.sf.ehcache.store.offheap.BackingMapFactory;
import net.sf.ehcache.store.offheap.EhcacheConcurrentOffHeapClockCache;
import net.sf.ehcache.store.offheap.pool.OffHeapPool;
import net.sf.ehcache.store.offheap.pool.OffHeapPoolParticipant;
import net.sf.ehcache.store.offheap.pool.impl.CrossPoolEvictionException;
import net.sf.ehcache.util.SetAsList;
import net.sf.ehcache.writer.CacheWriterManager;
import org.terracotta.statistics.OperationStatistic;
import org.terracotta.statistics.Statistic;
import org.terracotta.statistics.StatisticsManager;
import org.terracotta.statistics.derived.EventRateSimpleMovingAverage;
import org.terracotta.statistics.derived.OperationResultFilter;
import org.terracotta.statistics.observer.OperationObserver;

public class OffHeapStore
extends AbstractStore
implements net.sf.ehcache.store.StripedReadWriteLockProvider,
AuthoritativeTier,
Store,
PressuredStore {
    private final String cacheName;
    private final OffHeapPool pool;
    private final OffHeapPoolParticipant participant;
    private final EhcacheConcurrentOffHeapClockCache map;
    private final AtomicReference<Status> status = new AtomicReference<Status>(Status.STATUS_UNINITIALISED);
    private CacheLockProvider lockProvider;
    private final RegisteredEventListeners cacheEventNotificationService;
    private OperationObserver<StoreOperationOutcomes.GetOutcome> getOperationObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.GetOutcome.class).of(this)).named("get")).tag("local-offheap")).build();
    private OperationObserver<StoreOperationOutcomes.PutOutcome> putOperationObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.PutOutcome.class).of(this)).named("put")).tag("local-offheap")).build();
    private OperationObserver<StoreOperationOutcomes.RemoveOutcome> removeOperationObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.RemoveOutcome.class).of(this)).named("remove")).tag("local-offheap")).build();
    private volatile Callable<Void> valve;

    public OffHeapStore(BackingMapFactory<EhcacheConcurrentOffHeapClockCache, OffHeapStore> factory, Ehcache cache, OffHeapPool pool, SearchManager searchManger) {
        super(searchManger, cache.getName());
        this.cacheName = cache.getName();
        this.cacheEventNotificationService = cache.getCacheEventNotificationService();
        this.pool = pool;
        this.participant = new Participant();
        this.map = factory.create(this, this.participant);
        if (this.pool != null) {
            this.pool.registerParticipant(this.participant);
        }
        if (!this.status.compareAndSet(Status.STATUS_UNINITIALISED, Status.STATUS_ALIVE)) {
            throw new AssertionError();
        }
    }

    @Override
    public boolean put(Element element) throws CacheException {
        if (element == null) {
            return false;
        }
        if (!element.isSerializable()) {
            throw this.handleNotSerializableException(element);
        }
        this.putOperationObserver.begin();
        while (true) {
            try {
                if (this.map.put(element.getKey(), element) == null) {
                    this.putOperationObserver.end(StoreOperationOutcomes.PutOutcome.ADDED);
                    return true;
                }
                this.putOperationObserver.end(StoreOperationOutcomes.PutOutcome.UPDATED);
                return false;
            }
            catch (OversizeMappingException ex) {
                this.handleOversizeMappingException(element, ex);
                continue;
            }
            catch (CrossPoolEvictionException ex) {
                this.handleCrossPoolEvictionException(element, ex);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean putWithWriter(Element element, CacheWriterManager writerManager) {
        ReentrantReadWriteLock.WriteLock lock = this.map.getLock(element.getObjectKey()).writeLock();
        lock.lock();
        try {
            boolean result = this.put(element);
            if (writerManager != null) {
                writerManager.put(element);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public Element get(Object key) {
        this.getOperationObserver.begin();
        if (key == null) {
            this.getOperationObserver.end(StoreOperationOutcomes.GetOutcome.MISS);
            return null;
        }
        Element result = (Element)this.map.get(key);
        if (result == null) {
            this.getOperationObserver.end(StoreOperationOutcomes.GetOutcome.MISS);
        } else {
            this.getOperationObserver.end(StoreOperationOutcomes.GetOutcome.HIT);
        }
        return result;
    }

    @Override
    public Element getQuiet(Object key) {
        return this.get(key);
    }

    @Override
    public List<?> getKeys() {
        return new SetAsList(this.map.keySet());
    }

    @Override
    public Element remove(Object key) {
        if (key == null) {
            return null;
        }
        this.removeOperationObserver.begin();
        try {
            Element element = (Element)this.map.remove(key);
            return element;
        }
        finally {
            this.removeOperationObserver.end(StoreOperationOutcomes.RemoveOutcome.SUCCESS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element removeWithWriter(Object key, CacheWriterManager writerManager) throws CacheException {
        ReentrantReadWriteLock.WriteLock lock = this.map.getLock(key).writeLock();
        lock.lock();
        try {
            Element removed = this.remove(key);
            if (writerManager != null) {
                writerManager.remove(new CacheEntry(key, removed));
            }
            Element element = removed;
            return element;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void removeAll() throws CacheException {
        this.map.clear();
    }

    @Override
    public Element putIfAbsent(Element element) throws NullPointerException {
        if (!element.isSerializable()) {
            throw this.handleNotSerializableException(element);
        }
        while (true) {
            try {
                return this.map.putIfAbsent(element.getKey(), element);
            }
            catch (OversizeMappingException ex) {
                this.handleOversizeMappingException(element, ex);
                continue;
            }
            catch (CrossPoolEvictionException ex) {
                this.handleCrossPoolEvictionException(element, ex);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element removeElement(Element element, ElementValueComparator comparator) throws NullPointerException {
        if (!element.isSerializable()) {
            throw this.handleNotSerializableException(element);
        }
        Object key = element.getObjectKey();
        ReentrantReadWriteLock.WriteLock l = this.map.getLock(key).writeLock();
        l.lock();
        try {
            Element value = (Element)this.map.get(key);
            if (this.map.remove(key, element, comparator)) {
                Element element2 = value;
                return element2;
            }
            Element element3 = null;
            return element3;
        }
        finally {
            l.unlock();
        }
    }

    @Override
    public boolean replace(Element old, Element element, ElementValueComparator comparator) throws NullPointerException, IllegalArgumentException {
        if (!element.isSerializable()) {
            throw this.handleNotSerializableException(element);
        }
        while (true) {
            try {
                return this.map.replace(element.getKey(), old, element, comparator);
            }
            catch (OversizeMappingException ex) {
                this.handleOversizeMappingException(element, ex);
                continue;
            }
            catch (CrossPoolEvictionException ex) {
                this.handleCrossPoolEvictionException(element, ex);
                continue;
            }
            break;
        }
    }

    @Override
    public Element replace(Element element) throws NullPointerException {
        if (!element.isSerializable()) {
            throw this.handleNotSerializableException(element);
        }
        while (true) {
            try {
                return this.map.replace(element.getKey(), element);
            }
            catch (OversizeMappingException ex) {
                this.handleOversizeMappingException(element, ex);
                continue;
            }
            catch (CrossPoolEvictionException ex) {
                this.handleCrossPoolEvictionException(element, ex);
                continue;
            }
            break;
        }
    }

    @Override
    public void dispose() {
        if (this.status.compareAndSet(Status.STATUS_ALIVE, Status.STATUS_SHUTDOWN)) {
            this.map.destroy();
        }
    }

    @Override
    @Statistic(name="size", tags={"local-offheap"})
    public int getSize() {
        return this.map.size();
    }

    @Override
    public int getInMemorySize() {
        return 0;
    }

    @Override
    public int getOffHeapSize() {
        return this.getSize();
    }

    @Override
    public int getOnDiskSize() {
        return 0;
    }

    @Override
    public int getTerracottaClusteredSize() {
        return 0;
    }

    @Override
    public long getInMemorySizeInBytes() {
        return 0L;
    }

    @Override
    @Statistic(name="size-in-bytes", tags={"local-offheap"})
    public long getOffHeapSizeInBytes() {
        return this.map.getOccupiedMemory();
    }

    @Override
    public long getOnDiskSizeInBytes() {
        return 0L;
    }

    @Override
    public Status getStatus() {
        return this.status.get();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsKeyOnDisk(Object key) {
        return false;
    }

    @Override
    public boolean containsKeyOffHeap(Object key) {
        return this.containsKey(key);
    }

    @Override
    public boolean containsKeyInMemory(Object key) {
        return false;
    }

    @Override
    public void expireElements() {
        for (Serializable o : this.keySet()) {
            Element element = this.expireElement(o);
            if (element == null) continue;
            this.cacheEventNotificationService.notifyElementExpiry(element, false);
        }
    }

    protected Set<Serializable> keySet() {
        return this.map.keySet();
    }

    protected Element expireElement(Object key) {
        Element value = this.get(key);
        return value != null && value.isExpired() && this.map.remove(key, value) ? value : null;
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public boolean bufferFull() {
        return false;
    }

    @Override
    public Policy getInMemoryEvictionPolicy() {
        return null;
    }

    @Override
    public void setInMemoryEvictionPolicy(Policy policy) {
    }

    @Override
    public Object getInternalContext() {
        CacheLockProvider lp = this.lockProvider;
        return lp == null ? (this.lockProvider = new LockProvider(this.map)) : lp;
    }

    @Override
    public Object getMBean() {
        return null;
    }

    public void handleOversizeMappingException(Element e, OversizeMappingException cause) {
        this.handleOversizeMappingException(e, cause, null);
    }

    public void handleOversizeMappingException(Element e, OversizeMappingException cause, AtomicBoolean invokeValve) {
        if (!this.map.shrinkOthers(e.getKey().hashCode()) && !this.invokeValve(invokeValve)) {
            throw new CacheException("The element '" + e + "' is too large to be stored in this offheap store.", cause);
        }
    }

    public void handleCrossPoolEvictionException(Element e, CrossPoolEvictionException cause) {
        this.handleCrossPoolEvictionException(e, cause, null);
    }

    public void handleCrossPoolEvictionException(Element e, CrossPoolEvictionException cause, AtomicBoolean invokeValve) {
        if (this.pool == null) {
            throw new AssertionError();
        }
        if (!this.pool.getEvictor().freeSpace(this.pool.getPoolAccessors(), 0L, this.participant, e.getObjectKey().hashCode()) && !this.invokeValve(invokeValve)) {
            throw new CacheException("The element '" + e + "' is too large to be stored in this offheap store.", cause);
        }
    }

    private boolean invokeValve(AtomicBoolean invokeValve) {
        if (invokeValve == null || !invokeValve.get()) {
            return false;
        }
        invokeValve.set(false);
        Callable<Void> valve = this.valve;
        if (valve != null) {
            try {
                valve.call();
            }
            catch (Exception exception) {
                throw new CacheException("Failed invoking valve", exception);
            }
        }
        return true;
    }

    public void handleCrossPoolEvictionException(int keyHash, CrossPoolEvictionException cause) {
        if (this.pool == null) {
            throw new AssertionError();
        }
        if (!this.pool.getEvictor().freeSpace(this.pool.getPoolAccessors(), 0L, this.participant, keyHash)) {
            throw new CacheException("A binary element is too large to be stored in this offheap store.", cause);
        }
    }

    private RuntimeException handleNotSerializableException(Element e) {
        return new CacheException("The element '" + e + "' is not serializable and cannot be put into the offheap cache " + this.cacheName);
    }

    @Override
    public StripedReadWriteLock createStripedReadWriteLock() {
        return new StripedReadWriteLockProvider(this.map);
    }

    public void registerMasterLocks(List<ReadWriteLockSync> masterLocks) {
        this.map.registerMasterLocks(masterLocks);
    }

    @Override
    public Element fault(Object key, boolean updateStats) {
        this.getOperationObserver.begin();
        if (key != null && key instanceof Serializable) {
            Element e = (Element)this.map.getAndPin((Serializable)key);
            if (e == null) {
                this.getOperationObserver.end(StoreOperationOutcomes.GetOutcome.MISS);
            } else {
                this.getOperationObserver.end(StoreOperationOutcomes.GetOutcome.HIT);
            }
            return e;
        }
        this.getOperationObserver.end(StoreOperationOutcomes.GetOutcome.MISS);
        return null;
    }

    @Override
    public boolean putFaulted(Element element) {
        if (element == null) {
            return false;
        }
        if (!element.isSerializable()) {
            throw this.handleNotSerializableException(element);
        }
        AtomicBoolean invokeValve = new AtomicBoolean(true);
        this.putOperationObserver.begin();
        while (true) {
            try {
                if (this.map.putPinned(element.getKey(), element) == null) {
                    this.putOperationObserver.end(StoreOperationOutcomes.PutOutcome.ADDED);
                    return true;
                }
                this.putOperationObserver.end(StoreOperationOutcomes.PutOutcome.UPDATED);
                return false;
            }
            catch (OversizeMappingException ex) {
                this.handleOversizeMappingException(element, ex, invokeValve);
                continue;
            }
            catch (CrossPoolEvictionException ex) {
                this.handleCrossPoolEvictionException(element, ex);
                continue;
            }
            break;
        }
    }

    @Override
    public boolean flush(Element element) {
        if (element == null) {
            return false;
        }
        if (!element.isSerializable()) {
            throw this.handleNotSerializableException(element);
        }
        return this.map.unpin(element.getKey());
    }

    @Override
    public void registerEmergencyValve(Callable<Void> valve) {
        this.valve = valve;
    }

    public boolean isFaulted(Object key) {
        return this.map.isPinned(key);
    }

    class Participant
    implements OffHeapPoolParticipant {
        private final EventRateSimpleMovingAverage hitRate = new EventRateSimpleMovingAverage(1L, TimeUnit.SECONDS);
        private final EventRateSimpleMovingAverage missRate = new EventRateSimpleMovingAverage(1L, TimeUnit.SECONDS);

        Participant() {
            OperationStatistic<OperationResultFilter<StoreOperationOutcomes.GetOutcome>> getStatistic = StatisticsManager.getOperationStatisticFor(OffHeapStore.this.getOperationObserver);
            getStatistic.addDerivedStatistic(new OperationResultFilter<StoreOperationOutcomes.GetOutcome>(EnumSet.of(StoreOperationOutcomes.GetOutcome.HIT), this.hitRate));
            getStatistic.addDerivedStatistic(new OperationResultFilter<StoreOperationOutcomes.GetOutcome>(EnumSet.of(StoreOperationOutcomes.GetOutcome.MISS), this.missRate));
        }

        @Override
        public boolean evict(int count, long size, int excludedHash) {
            return OffHeapStore.this.map.tryShrinkOthers(excludedHash);
        }

        @Override
        public boolean evict(int i, long l) {
            return OffHeapStore.this.map.tryShrink();
        }

        @Override
        public long getSizeInBytes() {
            return OffHeapStore.this.map.getAllocatedMemory();
        }

        @Override
        public float getApproximateHitRate() {
            return this.hitRate.rate(TimeUnit.SECONDS).floatValue();
        }

        @Override
        public float getApproximateMissRate() {
            return this.missRate.rate(TimeUnit.SECONDS).floatValue();
        }

        @Override
        public long getApproximateCountSize() {
            return OffHeapStore.this.map.getSize();
        }
    }

    private static class StripedReadWriteLockProvider
    implements StripedReadWriteLock {
        private final ReadWriteLockSync[] locks;
        private final EhcacheConcurrentOffHeapClockCache offHeapMap;

        public StripedReadWriteLockProvider(EhcacheConcurrentOffHeapClockCache map) {
            this.offHeapMap = map;
            int concurrency = map.getConcurrency();
            this.locks = new ReadWriteLockSync[concurrency];
            for (int i = 0; i < concurrency; ++i) {
                this.locks[i] = new ReadWriteLockSync();
            }
        }

        @Override
        public ReadWriteLock getLockForKey(Object key) {
            return this.getSyncForKey(key).getReadWriteLock();
        }

        @Override
        public List<ReadWriteLockSync> getAllSyncs() {
            return Collections.unmodifiableList(Arrays.asList(this.locks));
        }

        @Override
        public ReadWriteLockSync getSyncForKey(Object key) {
            return this.locks[this.offHeapMap.getIndexFor(key)];
        }
    }

    private static class LockProvider
    implements CacheLockProvider {
        private final EhcacheConcurrentOffHeapClockCache offHeapMap;

        public LockProvider(EhcacheConcurrentOffHeapClockCache map) {
            this.offHeapMap = map;
        }

        @Override
        public Sync getSyncForKey(Object key) {
            return new ReadWriteLockSync(this.offHeapMap.getLock(key));
        }
    }
}

