/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.offheap.configuration;

import com.terracottatech.offheapstore.util.DebuggingUtils;
import net.sf.ehcache.store.offheap.configuration.AdvancedConfigPropertyParser;
import net.sf.ehcache.store.offheap.configuration.OffHeapConfiguration;
import net.sf.ehcache.util.MemorySizeParser;

public class HeuristicPoolConfiguration
implements OffHeapConfiguration {
    private static final String MINIMUM_MAX_MEMORY = "1M";
    private static final long MINIMUM_MAX_MEMORY_IN_BYTES = MemorySizeParser.parse("1M");
    private static final int IDEAL_MAX_SEGMENT_SIZE = 0x2000000;
    private static final int MAXIMUM_CHUNK_SIZE = 0x40000000;
    private static final int MINIMUM_SEGMENT_COUNT = 16;
    private static final int MAXIMUM_SEGMENT_COUNT = 16384;
    private static final int MAXIMAL_SEGMENT_SIZE_RATIO = 4;
    private static final int INITIAL_SEGMENT_SIZE_RATIO = 16;
    private static final int ASSUMED_KEY_VALUE_SIZE = 1024;
    private static final int AGGRESSIVE_INITIAL_SEGMENT_SIZE_RATIO = 1;
    private final String managerName;
    private final long maximumSize;
    private final int idealMaxSegmentSize;
    private final int maximumChunkSize;
    private final int minimumSegmentCount;
    private final int maximumSegmentCount;
    private final int maximalSegmentSizeRatio;
    private final int initialSegmentSizeRatio;
    private final int assumedKeyValueSize;
    private final int concurrencyAttenuation;

    public HeuristicPoolConfiguration(String managerName, long maximumSize, int cacheCount) {
        if (maximumSize < MINIMUM_MAX_MEMORY_IN_BYTES) {
            throw new IllegalArgumentException("The value of maxBytesLocalOffHeap is less than the minimum allowed value of 1M for the following cache-manager: " + managerName + ". Reconfigure maxBytesLocalOffHeap in ehcache.xml or programmatically.");
        }
        this.managerName = managerName;
        this.maximumSize = maximumSize;
        int defaultConcurrencyAttenuation = Math.max(1, cacheCount / 2);
        this.idealMaxSegmentSize = (int)AdvancedConfigPropertyParser.getAdvancedMemorySizeConfigProperty("idealMaxSegmentSize", managerName, 0x2000000L);
        this.maximumChunkSize = (int)AdvancedConfigPropertyParser.getAdvancedMemorySizeConfigProperty("maximumChunkSize", managerName, 0x40000000L);
        this.minimumSegmentCount = (int)AdvancedConfigPropertyParser.getAdvancedMemorySizeConfigProperty("minimumSegmentCount", managerName, 16L);
        this.maximumSegmentCount = (int)AdvancedConfigPropertyParser.getAdvancedMemorySizeConfigProperty("maximumSegmentCount", managerName, 16384L);
        this.maximalSegmentSizeRatio = (int)AdvancedConfigPropertyParser.getAdvancedMemorySizeConfigProperty("maximalSegmentSizeRatio", managerName, 4L);
        this.initialSegmentSizeRatio = (int)AdvancedConfigPropertyParser.getAdvancedMemorySizeConfigProperty("initialSegmentSizeRatio", managerName, HeuristicPoolConfiguration.initialSegmentSizeRatio(managerName));
        this.assumedKeyValueSize = (int)AdvancedConfigPropertyParser.getAdvancedMemorySizeConfigProperty("assumedKeyValueSize", managerName, 1024L);
        this.concurrencyAttenuation = (int)AdvancedConfigPropertyParser.getAdvancedMemorySizeConfigProperty("concurrencyAttenuation", managerName, defaultConcurrencyAttenuation);
    }

    private static long initialSegmentSizeRatio(String managerName) {
        if (AdvancedConfigPropertyParser.getAdvancedBooleanConfigProperty("aggressive", managerName, false)) {
            return 1L;
        }
        return 16L;
    }

    @Override
    public long getMaximumSize() {
        return this.maximumSize;
    }

    @Override
    public int getMinimumChunkSize() {
        return (int)Math.min((long)this.maximumChunkSize, (long)this.maximalSegmentSizeRatio * (this.getMaximumSize() / (long)this.getConcurrency() / (long)this.getConcurrencyAttenuation()));
    }

    @Override
    public int getMaximumChunkSize() {
        return (int)Math.min(this.getMaximumSize(), (long)this.maximumChunkSize);
    }

    @Override
    public int getConcurrency() {
        return Integer.highestOneBit((int)Math.min((long)this.maximumSegmentCount, Math.max((long)this.minimumSegmentCount, this.getMaximumSize() / (long)this.idealMaxSegmentSize / (long)this.getConcurrencyAttenuation())));
    }

    @Override
    public int getInitialSegmentTableSize() {
        return Math.max(1, this.getSegmentDataPageSize() / this.assumedKeyValueSize);
    }

    @Override
    public int getSegmentDataPageSize() {
        return Integer.highestOneBit((int)Math.min((long)this.getMinimumChunkSize(), this.getInitialSegmentCapacity() * (long)this.assumedKeyValueSize));
    }

    private long getInitialSegmentCapacity() {
        return this.getMaximumSize() / (long)(this.getConcurrency() * this.getConcurrencyAttenuation() * this.initialSegmentSizeRatio * (this.assumedKeyValueSize + 16));
    }

    private int getConcurrencyAttenuation() {
        return this.concurrencyAttenuation;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Heuristic CacheManager Pool Configuration: " + this.managerName + "\n");
        sb.append("Maximum Size (specified)   : ").append(DebuggingUtils.toBase2SuffixedString(this.getMaximumSize())).append("B\n");
        sb.append("Minimum Chunk Size         : ").append(DebuggingUtils.toBase2SuffixedString(this.getMinimumChunkSize())).append("B\n");
        sb.append("Maximum Chunk Size         : ").append(DebuggingUtils.toBase2SuffixedString(this.getMaximumChunkSize())).append("B\n");
        sb.append("Concurrency                : ").append(this.getConcurrency()).append("\n");
        sb.append("Initial Segment Table Size : ").append(DebuggingUtils.toBase2SuffixedString(this.getInitialSegmentTableSize())).append(" slots\n");
        sb.append("Segment Data Page Size     : ").append(DebuggingUtils.toBase2SuffixedString(this.getSegmentDataPageSize())).append("B\n");
        return sb.toString();
    }
}

