/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.offheap.factories;

import com.terracottatech.offheapstore.ReadWriteLockedOffHeapClockCache;
import com.terracottatech.offheapstore.paging.PageSource;
import com.terracottatech.offheapstore.pinning.PinnableSegment;
import com.terracottatech.offheapstore.storage.StorageEngine;
import com.terracottatech.offheapstore.util.Factory;
import java.io.Serializable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.sf.ehcache.CacheOperationOutcomes;
import net.sf.ehcache.Element;
import net.sf.ehcache.event.RegisteredEventListeners;
import net.sf.ehcache.store.ElementValueComparator;
import org.terracotta.statistics.observer.OperationObserver;

public class EhcacheSegmentFactory
implements Factory<PinnableSegment<Serializable, Element>> {
    private final RegisteredEventListeners evictionListener;
    private final OperationObserver<CacheOperationOutcomes.EvictionOutcome> evictionObserver;
    private final Factory<? extends StorageEngine<? super Serializable, ? super Element>> storageEngineFactory;
    private final PageSource tableSource;
    private final int tableSize;
    private volatile boolean cachePinned;

    public EhcacheSegmentFactory(RegisteredEventListeners evictionListener, OperationObserver<CacheOperationOutcomes.EvictionOutcome> evictionObserver, PageSource source, Factory<? extends StorageEngine<? super Serializable, ? super Element>> storageEngineFactory, int initialTableSize, boolean cachePinned) {
        this.evictionListener = evictionListener;
        this.evictionObserver = evictionObserver;
        this.storageEngineFactory = storageEngineFactory;
        this.tableSource = source;
        this.tableSize = initialTableSize;
        this.cachePinned = cachePinned;
    }

    @Override
    public PinnableSegment<Serializable, Element> newInstance() {
        StorageEngine<? super Serializable, ? super Element> storageEngine = this.storageEngineFactory.newInstance();
        try {
            return new NotifyingEhcacheSegment(this.evictionListener, this.evictionObserver, this.tableSource, storageEngine, this.tableSize, this.cachePinned);
        }
        catch (RuntimeException e) {
            storageEngine.destroy();
            throw e;
        }
    }

    public static class NotifyingEhcacheSegment
    extends EhcacheSegment {
        private final RegisteredEventListeners evictionListener;
        private final OperationObserver<CacheOperationOutcomes.EvictionOutcome> evictionObserver;

        public NotifyingEhcacheSegment(RegisteredEventListeners evictionListener, OperationObserver<CacheOperationOutcomes.EvictionOutcome> evictionObserver, PageSource source, StorageEngine<? super Serializable, ? super Element> storageEngine, int tableSize, boolean cachePinned) {
            super(source, storageEngine, tableSize, cachePinned);
            this.evictionListener = evictionListener;
            this.evictionObserver = evictionObserver;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Element put(Serializable key, Element value, int metadata) {
            Lock lock = this.writeLock();
            lock.lock();
            try {
                Element oldElement = super.put(key, value, metadata);
                if (oldElement != null) {
                    this.evictionListener.notifyElementRemovedOrdered(oldElement);
                }
                this.evictionListener.notifyElementPutOrdered(value);
                Element element = oldElement;
                return element;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Element remove(Object key) {
            Lock lock = this.writeLock();
            lock.lock();
            try {
                Element oldElement = (Element)super.remove(key);
                if (oldElement != null) {
                    this.evictionListener.notifyElementRemovedOrdered(oldElement);
                }
                Element element = oldElement;
                return element;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean evict(int index, boolean shrink) {
            boolean evicted;
            if (this.cachePinned) {
                throw new OutOfMemoryError("cannot evict pinned cache");
            }
            Element e = (Element)this.getAtTableOffset(index);
            Lock lock = this.writeLock();
            lock.lock();
            try {
                evicted = super.evict(index, shrink);
                if (evicted) {
                    this.evictionListener.notifyElementRemovedOrdered(e);
                }
            }
            finally {
                lock.unlock();
            }
            if (evicted) {
                if (this.evictionListener.hasCacheEventListeners()) {
                    if (e.isExpired()) {
                        this.evictionListener.notifyElementExpiry(e, false);
                    } else {
                        this.evictionListener.notifyElementEvicted(e, false);
                        if (this.evictionObserver != null) {
                            this.evictionObserver.begin();
                            this.evictionObserver.end(CacheOperationOutcomes.EvictionOutcome.SUCCESS);
                        }
                    }
                } else if (this.evictionObserver != null) {
                    this.evictionObserver.begin();
                    this.evictionObserver.end(CacheOperationOutcomes.EvictionOutcome.SUCCESS);
                }
            }
            return evicted;
        }
    }

    public static abstract class EhcacheSegment
    extends ReadWriteLockedOffHeapClockCache<Serializable, Element> {
        protected volatile boolean cachePinned;
        private volatile Lock masterLock;

        EhcacheSegment(PageSource source, StorageEngine<? super Serializable, ? super Element> storageEngine, int tableSize, boolean cachePinned) {
            super(source, true, storageEngine, tableSize);
            this.cachePinned = cachePinned;
        }

        public Lock getMasterLock() {
            return this.masterLock;
        }

        public boolean tryShrink() {
            ReentrantReadWriteLock.WriteLock writeLock = this.getLock().writeLock();
            if (writeLock.tryLock()) {
                try {
                    boolean bl = super.shrink();
                    return bl;
                }
                finally {
                    writeLock.unlock();
                }
            }
            return false;
        }

        @Override
        protected void storageEngineFailure(Object failure) {
            if (this.cachePinned) {
                StringBuilder sb = new StringBuilder("Storage Engine and Eviction Failed.\n");
                sb.append("Cache pinned : ").append(this.cachePinned).append("\n");
                sb.append("Storage Engine : ").append(this.storageEngine);
                throw new OutOfMemoryError(sb.toString());
            }
            super.storageEngineFailure(failure);
        }

        @Override
        public Element fill(Serializable key, Element value) {
            if (this.cachePinned) {
                return this.put(key, value);
            }
            return super.fill(key, value);
        }

        @Override
        public boolean evict(int index, boolean shrink) {
            if (this.cachePinned) {
                throw new OutOfMemoryError("cannot evict pinned cache");
            }
            return super.evict(index, shrink);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean remove(Object key, Element value, ElementValueComparator comparator) {
            Lock l = this.writeLock();
            l.lock();
            try {
                if (key == null) {
                    throw new NullPointerException();
                }
                if (value == null) {
                    boolean bl = false;
                    return bl;
                }
                Element existing = (Element)super.get(key);
                if (comparator.equals(value, existing)) {
                    this.remove(key);
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                l.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean replace(Serializable key, Element oldValue, Element newValue, ElementValueComparator comparator) {
            Lock l = this.writeLock();
            l.lock();
            try {
                Element existing = (Element)this.get(key);
                if (comparator.equals(oldValue, existing)) {
                    this.put(key, newValue);
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                l.unlock();
            }
        }

        public void registerMasterLock(Lock master) {
            this.masterLock = master;
        }
    }
}

