/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.restartability;

import com.terracottatech.frs.RestartStore;
import com.terracottatech.frs.RestartStoreException;
import com.terracottatech.frs.Snapshot;
import com.terracottatech.frs.Transaction;
import com.terracottatech.frs.TransactionException;
import com.terracottatech.frs.recovery.RecoveryException;
import java.util.concurrent.Future;

public class ControlledTransactionRestartStore<I, K, V>
implements RestartStore<I, K, V> {
    private final ThreadLocal<WrappedTransaction> activeTransaction = new ThreadLocal();
    private final RestartStore<I, K, V> delegate;

    public ControlledTransactionRestartStore(RestartStore<I, K, V> delegate) {
        this.delegate = delegate;
    }

    @Override
    public Future<Void> startup() throws InterruptedException, RecoveryException {
        return this.delegate.startup();
    }

    @Override
    public void shutdown() throws InterruptedException {
        this.delegate.shutdown();
    }

    @Override
    public Transaction<I, K, V> beginTransaction(boolean synchronous) {
        WrappedTransaction activeTxn = this.activeTransaction.get();
        if (activeTxn != null) {
            if (activeTxn.synchronous != synchronous) {
                throw new IllegalArgumentException("Mismatched synchronous attributes is unsupported.");
            }
            return activeTxn;
        }
        return this.beginAutoCommitTransaction(synchronous);
    }

    @Override
    public Transaction<I, K, V> beginAutoCommitTransaction(boolean synchronous) {
        return this.delegate.beginAutoCommitTransaction(synchronous);
    }

    public void beginControlledTransaction(boolean synchronous) {
        if (this.activeTransaction.get() != null) {
            throw new UnsupportedOperationException("Nested transaction are not supported.");
        }
        this.activeTransaction.set(new WrappedTransaction(synchronous));
    }

    @Override
    public Snapshot snapshot() throws RestartStoreException {
        return this.delegate.snapshot();
    }

    public void commitControlledTransaction() throws TransactionException {
        if (this.activeTransaction.get() == null) {
            throw new IllegalStateException("Transaction is not started.");
        }
        try {
            this.activeTransaction.get().reallyCommit();
        }
        finally {
            this.activeTransaction.remove();
        }
    }

    private class WrappedTransaction
    implements Transaction<I, K, V> {
        private final Transaction<I, K, V> txn;
        private final boolean synchronous;

        private WrappedTransaction(boolean synchronous) {
            this.synchronous = synchronous;
            this.txn = ControlledTransactionRestartStore.this.delegate.beginTransaction(synchronous);
        }

        public WrappedTransaction put(I id, K key, V value) throws TransactionException {
            this.txn.put(id, key, value);
            return this;
        }

        public WrappedTransaction delete(I id) throws TransactionException {
            this.txn.delete(id);
            return this;
        }

        public WrappedTransaction remove(I id, K key) throws TransactionException {
            this.txn.remove(id, key);
            return this;
        }

        @Override
        public void commit() {
        }

        private void reallyCommit() throws TransactionException {
            this.txn.commit();
        }
    }
}

