/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.ehcachedx.util;

import java.lang.reflect.Method;
import org.terracotta.ehcachedx.util.VmVersion;

public class Vm {
    public static final VmVersion VERSION = new VmVersion(System.getProperties());

    private Vm() {
    }

    public static boolean isAzul() {
        return VERSION.isAzul();
    }

    public static int dataModel() {
        try {
            if (Vm.isAzul()) {
                return 64;
            }
            String dataModelString = System.getProperty("sun.arch.data.model", "0");
            return Integer.parseInt(dataModelString);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static long maxDirectMemory() {
        try {
            Class<?> vmClass = Class.forName("sun.misc.VM");
            Method maxDirectMemory = vmClass.getDeclaredMethod("maxDirectMemory", new Class[0]);
            return (Long)maxDirectMemory.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            return Long.MIN_VALUE;
        }
    }
}

