/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.search;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import net.sf.ehcache.search.Result;

abstract class AbstractClusteredResultList
implements List<Result> {
    AbstractClusteredResultList() {
    }

    private boolean isTypeCompatible(Object o) {
        return o instanceof Result;
    }

    @Override
    public int indexOf(Object o) {
        if (!this.isTypeCompatible(o)) {
            return -1;
        }
        ListIterator it = this.listIterator();
        while (it.hasNext()) {
            if (!o.equals(it.next())) continue;
            return it.previousIndex();
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        if (!this.isTypeCompatible(o)) {
            return -1;
        }
        ListIterator it = this.listIterator(this.size());
        while (it.hasPrevious()) {
            if (!o.equals(it.previous())) continue;
            return it.nextIndex();
        }
        return -1;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object e : c) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean contains(Object o) {
        if (!this.isTypeCompatible(o)) {
            return false;
        }
        for (Result res : this) {
            if (!o.equals(res)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object[] toArray() {
        Object[] r = new Object[this.size()];
        Iterator it = this.iterator();
        for (int i = 0; i < r.length; ++i) {
            if (!it.hasNext()) {
                return Arrays.copyOf(r, i);
            }
            r[i] = it.next();
        }
        return r;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int size = this.size();
        T[] r = a.length >= size ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        Iterator it = this.iterator();
        for (int i = 0; i < r.length; ++i) {
            if (!it.hasNext()) {
                if (a != r) {
                    return Arrays.copyOf(r, i);
                }
                r[i] = null;
                break;
            }
            r[i] = it.next();
        }
        return r;
    }
}

