/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.shaded.lucene.codecs;

import java.io.Closeable;
import java.io.IOException;
import org.terracotta.shaded.lucene.index.BinaryDocValues;
import org.terracotta.shaded.lucene.index.FieldInfo;
import org.terracotta.shaded.lucene.index.NumericDocValues;
import org.terracotta.shaded.lucene.index.SortedDocValues;
import org.terracotta.shaded.lucene.index.SortedSetDocValues;
import org.terracotta.shaded.lucene.util.Bits;

public abstract class DocValuesProducer
implements Closeable {
    protected DocValuesProducer() {
    }

    public abstract NumericDocValues getNumeric(FieldInfo var1) throws IOException;

    public abstract BinaryDocValues getBinary(FieldInfo var1) throws IOException;

    public abstract SortedDocValues getSorted(FieldInfo var1) throws IOException;

    public abstract SortedSetDocValues getSortedSet(FieldInfo var1) throws IOException;

    public abstract Bits getDocsWithField(FieldInfo var1) throws IOException;

    public abstract long ramBytesUsed();

    public static class SortedSetDocsWithField
    implements Bits {
        final SortedSetDocValues in;
        final int maxDoc;

        public SortedSetDocsWithField(SortedSetDocValues in, int maxDoc) {
            this.in = in;
            this.maxDoc = maxDoc;
        }

        @Override
        public boolean get(int index) {
            this.in.setDocument(index);
            return this.in.nextOrd() != -1L;
        }

        @Override
        public int length() {
            return this.maxDoc;
        }
    }

    public static class SortedDocsWithField
    implements Bits {
        final SortedDocValues in;
        final int maxDoc;

        public SortedDocsWithField(SortedDocValues in, int maxDoc) {
            this.in = in;
            this.maxDoc = maxDoc;
        }

        @Override
        public boolean get(int index) {
            return this.in.getOrd(index) >= 0;
        }

        @Override
        public int length() {
            return this.maxDoc;
        }
    }
}

