/*
 * Decompiled with CFR 0.152.
 */
package net.java.sen;

import java.io.IOException;
import java.io.Reader;
import java.util.Locale;
import net.java.sen.StringTagger;
import net.java.sen.Token;
import net.java.sen.processor.PostProcessor;
import net.java.sen.processor.PreProcessor;

public class StreamTagger {
    private StringTagger stringTagger = null;
    private static final int BUFFER_SIZE = 256;
    private final char[] buffer = new char[256];
    private int cnt = 0;
    private Token[] token;
    private boolean complete = false;
    private Reader reader;
    private int lastReadOffset;

    public StreamTagger(Reader reader, Locale locale) throws IOException, IllegalArgumentException {
        this.stringTagger = StringTagger.getInstance(locale);
        this.reader = reader;
        this.lastReadOffset = 0;
    }

    public StreamTagger(Reader reader) throws IOException, IllegalArgumentException {
        this.stringTagger = StringTagger.getInstance();
        this.reader = reader;
        this.lastReadOffset = 0;
    }

    public StreamTagger(Reader reader, String senConfig) throws IOException, IllegalArgumentException {
        this.stringTagger = StringTagger.getInstance(senConfig);
        this.reader = reader;
        this.lastReadOffset = 0;
    }

    public boolean hasNext() throws IOException {
        if (this.token == null || this.token.length == this.cnt) {
            int i;
            do {
                if ((i = this.readToBuffer()) == -1) {
                    return false;
                }
                this.token = this.stringTagger.analyze(new String(this.buffer, 0, i));
            } while (this.token == null);
            this.cnt = 0;
            if (this.token != null) {
                for (int n = 0; n < this.token.length; ++n) {
                    this.token[n].setStart(this.token[n].start() + this.lastReadOffset);
                }
            }
            this.lastReadOffset += i;
        }
        return this.token.length != 0;
    }

    private int readToBuffer() throws IOException {
        int pos;
        int res = 0;
        for (pos = 0; pos < 256 && !this.complete && (res = this.reader.read(this.buffer, pos, 1)) != -1; ++pos) {
            if (Character.getType(this.buffer[pos]) != 24 || pos <= 0) continue;
            return pos + 1;
        }
        if (res == -1) {
            this.complete = true;
        }
        if (this.complete && pos == 0) {
            return -1;
        }
        return pos;
    }

    public Token next() throws IOException {
        if (this.token == null || this.token.length == this.cnt) {
            int i;
            do {
                if ((i = this.readToBuffer()) == -1) {
                    return null;
                }
                this.token = this.stringTagger.analyze(new String(this.buffer, 0, i));
            } while (this.token == null);
            this.cnt = 0;
            if (this.token != null) {
                for (int n = 0; n < this.token.length; ++n) {
                    this.token[n].setStart(this.token[n].start() + this.lastReadOffset);
                }
            }
            this.lastReadOffset += i;
        }
        return this.token[this.cnt++];
    }

    public void addPostProcessor(PostProcessor processor) {
        this.stringTagger.addPostProcessor(processor);
    }

    public void addPreProcessor(PreProcessor processor) {
        this.stringTagger.addPreProcessor(processor);
    }
}

