/*
 * Decompiled with CFR 0.152.
 */
package net.java.sen;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.java.sen.Node;
import net.java.sen.SenUtils;
import net.java.sen.Token;
import net.java.sen.Tokenizer;
import net.java.sen.Viterbi;
import net.java.sen.processor.PostProcessor;
import net.java.sen.processor.PreProcessor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class StringTagger {
    private static Log log = LogFactory.getLog((Class)(class$net$java$sen$StringTagger == null ? (class$net$java$sen$StringTagger = StringTagger.class$("net.java.sen.StringTagger")) : class$net$java$sen$StringTagger));
    private static HashMap hash = new HashMap();
    private Viterbi viterbi = null;
    Token[] token = null;
    int cnt = 0;
    private static StringTagger tagger = null;
    private static String DEFAULT_CONFIG = "conf/sen.xml";
    protected String unknownPos = null;
    private List preProcessorList = new ArrayList();
    private List postProcessorList = new ArrayList();
    String tokenFile = null;
    String doubleArrayFile = null;
    String posInfoFile = null;
    String connectFile = null;
    String charset = null;
    String tokenizerClass = "net.java.sen.ja.JapaneseTokenizer";
    static /* synthetic */ Class class$net$java$sen$StringTagger;
    static /* synthetic */ Class class$java$lang$String;

    private StringTagger(String senConfig) throws IOException, IllegalArgumentException {
        this.init(senConfig);
    }

    public static StringTagger getInstance() throws IllegalArgumentException, IOException {
        return StringTagger.getInstance(System.getProperty("sen.home") + System.getProperty("file.separator") + DEFAULT_CONFIG);
    }

    public static StringTagger getInstance(Locale locale) throws IOException, IllegalArgumentException {
        if (locale.equals(Locale.JAPANESE)) {
            return StringTagger.getInstance();
        }
        throw new IllegalArgumentException("Locale '" + locale.getDisplayName() + "' isn't supported.");
    }

    public static synchronized StringTagger getInstance(String senConfig) throws IOException, IllegalArgumentException {
        Object tagger = hash.get(senConfig);
        if (tagger == null) {
            tagger = new StringTagger(senConfig);
            hash.put(senConfig, tagger);
            return (StringTagger)tagger;
        }
        return (StringTagger)tagger;
    }

    private void init(String confFile) throws IOException {
        this.readConfig(confFile);
        Tokenizer tokenizer = null;
        try {
            Class<?> c = Class.forName(this.tokenizerClass);
            Constructor<?> cons = c.getConstructor(class$java$lang$String == null ? (class$java$lang$String = StringTagger.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = StringTagger.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = StringTagger.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = StringTagger.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = StringTagger.class$("java.lang.String")) : class$java$lang$String);
            tokenizer = (Tokenizer)cons.newInstance(this.tokenFile, this.doubleArrayFile, this.posInfoFile, this.connectFile, this.charset);
        }
        catch (Exception ce) {
            throw new IllegalArgumentException("Tokenizer Class: " + this.tokenizerClass + " is invalid.");
        }
        this.viterbi = new Viterbi(tokenizer);
    }

    public synchronized Token[] analyze(String input) throws IOException {
        Node node;
        if (log.isDebugEnabled()) {
            log.debug((Object)("analyzer:" + input));
        }
        HashMap postProcessInfo = new HashMap();
        input = this.doPreProcess(input, postProcessInfo);
        int len = 0;
        Node iter = node = this.viterbi.analyze((char[])input.toCharArray()).next;
        if (node == null) {
            return null;
        }
        while (iter.next != null) {
            ++len;
            iter = iter.next;
        }
        this.token = new Token[len];
        int i = 0;
        while (node.next != null) {
            this.token[i] = new Token(node);
            if (this.token[i].getPos() == null) {
                this.token[i].setPos(this.unknownPos);
            }
            ++i;
            node = node.next;
        }
        this.cnt = 0;
        this.token = this.doPostProcess(this.token, postProcessInfo);
        return this.token;
    }

    public Token next() {
        if (this.token == null && this.cnt == this.token.length) {
            return null;
        }
        return this.token[this.cnt++];
    }

    public boolean hasNext() {
        return this.token != null || this.cnt != this.token.length;
    }

    private void readConfig(String confFile) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            File cf = new File(confFile);
            String parent = cf.getParentFile().getParent();
            if (parent == null) {
                parent = ".";
            }
            Document doc = builder.parse(new InputSource(confFile));
            NodeList nl = doc.getFirstChild().getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                org.w3c.dom.Node n = nl.item(i);
                if (n.getNodeType() != 1) continue;
                String nn = n.getNodeName();
                String value = n.getFirstChild().getNodeValue();
                if (nn.equals("charset")) {
                    this.charset = value;
                } else if (nn.equals("unknown-pos")) {
                    this.unknownPos = value;
                } else if (nn.equals("tokenizer")) {
                    this.tokenizerClass = value;
                }
                if (!nn.equals("dictionary")) continue;
                NodeList dnl = n.getChildNodes();
                for (int j = 0; j < dnl.getLength(); ++j) {
                    org.w3c.dom.Node dn = dnl.item(j);
                    if (dn.getNodeType() != 1) continue;
                    String dnn = dn.getNodeName();
                    if (dn.getFirstChild() == null) {
                        throw new IllegalArgumentException("element '" + dnn + "' is empty");
                    }
                    String dvalue = dn.getFirstChild().getNodeValue();
                    if (dnn.equals("connection-cost")) {
                        this.connectFile = SenUtils.getPath(dvalue, parent);
                        continue;
                    }
                    if (dnn.equals("double-array-trie")) {
                        this.doubleArrayFile = SenUtils.getPath(dvalue, parent);
                        continue;
                    }
                    if (dnn.equals("token")) {
                        this.tokenFile = SenUtils.getPath(dvalue, parent);
                        continue;
                    }
                    if (dnn.equals("pos-info")) {
                        this.posInfoFile = SenUtils.getPath(dvalue, parent);
                        continue;
                    }
                    if (dnn.equals("compound")) continue;
                    throw new IllegalArgumentException("element '" + dnn + "' is invalid");
                }
            }
        }
        catch (ParserConfigurationException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (SAXException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public void addPostProcessor(PostProcessor processor) {
        this.postProcessorList.add(processor);
    }

    public void addPreProcessor(PreProcessor processor) {
        this.preProcessorList.add(processor);
    }

    protected String doPreProcess(String input, Map postProcessInfo) {
        Iterator itr = this.preProcessorList.iterator();
        String i = input;
        while (itr.hasNext()) {
            PreProcessor p = (PreProcessor)itr.next();
            i = p.process(i, postProcessInfo);
        }
        return i;
    }

    protected Token[] doPostProcess(Token[] tokens, Map postProcessInfo) {
        Iterator itr = this.postProcessorList.iterator();
        Token[] newTokens = tokens;
        while (itr.hasNext()) {
            PostProcessor p = (PostProcessor)itr.next();
            newTokens = p.process(newTokens, postProcessInfo);
        }
        return newTokens;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

