/*
 * Decompiled with CFR 0.152.
 */
package net.java.sen.processor;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import net.java.sen.Token;
import net.java.sen.processor.PreProcessor;

public class RemarkPreProcessor
implements PreProcessor {
    protected List ruleList = new ArrayList();

    public String process(String input, Map postProcessInfo) {
        ArrayList tokenList = new ArrayList();
        postProcessInfo.put("remark", tokenList);
        Iterator itr = this.ruleList.iterator();
        while (itr.hasNext()) {
            int count = 0;
            Rule rule = (Rule)itr.next();
            while (count < input.length()) {
                int start = -1;
                int end = -1;
                start = input.indexOf(rule.start, count);
                if (start >= 0) {
                    count = start + rule.start.length();
                    end = rule.end.equals("") ? start : input.indexOf(rule.end, count);
                    if (end >= 0) {
                        end = rule.end.equals("") ? (end += rule.start.length()) : (end += rule.end.length());
                        count = end;
                        String tokenStr = input.substring(start, end);
                        input = this.replaceToSpace(input, start, end);
                        Token token = new Token();
                        token.setPos(rule.pos);
                        token.setStart(start);
                        token.setLength(end - start);
                        token.setSurface(tokenStr);
                        token.setBasicString(tokenStr);
                        token.setPronunciation(tokenStr);
                        token.setReading(tokenStr);
                        token.setCost(0);
                        token.setAddInfo("");
                        token.setCform("*");
                        token.setTermInfo("");
                        this.addToTokenList(tokenList, token);
                        continue;
                    }
                    count = input.length();
                    continue;
                }
                count = input.length();
            }
        }
        return input;
    }

    public void readRules(BufferedReader reader) throws IOException {
        String line = null;
        while ((line = reader.readLine()) != null) {
            StringTokenizer st = new StringTokenizer(line);
            if (!st.hasMoreTokens()) continue;
            Rule rule = new Rule();
            if (st.countTokens() == 2) {
                rule.start = st.nextToken();
                rule.end = "";
                rule.pos = st.nextToken();
            } else {
                rule.start = st.nextToken();
                rule.end = st.nextToken();
                rule.pos = st.nextToken();
            }
            this.ruleList.add(rule);
        }
    }

    protected String replaceToSpace(String input, int start, int end) {
        char[] c = input.toCharArray();
        for (int i = start; i < end; ++i) {
            c[i] = 32;
        }
        return new String(c);
    }

    protected void addToTokenList(List tokenList, Token token) {
        for (int i = 0; i < tokenList.size(); ++i) {
            Token currentToken = (Token)tokenList.get(i);
            if (token.start() >= currentToken.start()) continue;
            tokenList.add(i, token);
            return;
        }
        tokenList.add(token);
    }

    class Rule {
        public String start;
        public String end;
        public String pos;

        Rule() {
        }
    }
}

