/*
 * Decompiled with CFR 0.152.
 */
package net.java.sen.tools;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.ResourceBundle;
import net.java.sen.util.CSVParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MkCompoundTable {
    private static Log log = LogFactory.getLog((Class)(class$net$java$sen$tools$MkCompoundTable == null ? (class$net$java$sen$tools$MkCompoundTable = MkCompoundTable.class$("net.java.sen.tools.MkCompoundTable")) : class$net$java$sen$tools$MkCompoundTable));
    static /* synthetic */ Class class$net$java$sen$tools$MkCompoundTable;

    public static void main(String[] args) {
        ResourceBundle rb = ResourceBundle.getBundle("dictionary");
        int pos_start = Integer.parseInt(rb.getString("pos_start"));
        int pos_size = Integer.parseInt(rb.getString("pos_size"));
        try {
            String t;
            log.info((Object)"reading compound word information ... ");
            HashMap<String, String> compoundTable = new HashMap<String, String>();
            log.info((Object)("load dic: " + rb.getString("compound_word_file")));
            BufferedReader dicStream = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(rb.getString("compound_word_file")), rb.getString("dic.charset")));
            int line = 0;
            StringBuffer pos_b = new StringBuffer();
            while ((t = dicStream.readLine()) != null) {
                int i;
                CSVParser parser = new CSVParser(t);
                String[] csv = parser.nextTokens();
                if (csv.length < pos_size + pos_start) {
                    throw new RuntimeException("format error:" + line);
                }
                pos_b.setLength(0);
                for (i = pos_start; i < pos_start + pos_size - 1; ++i) {
                    pos_b.append(csv[i]);
                    pos_b.append(',');
                }
                pos_b.append(csv[pos_start + pos_size - 1]);
                pos_b.append(',');
                for (i = pos_start + pos_size; i < csv.length - 2; ++i) {
                    pos_b.append(csv[i]);
                    pos_b.append(',');
                }
                pos_b.append(csv[csv.length - 2]);
                compoundTable.put(pos_b.toString(), csv[csv.length - 1]);
            }
            dicStream.close();
            log.info((Object)"done.");
            log.info((Object)"writing compound word table ... ");
            ObjectOutputStream os = new ObjectOutputStream(new FileOutputStream(rb.getString("compound_word_table")));
            os.writeObject(compoundTable);
            os.close();
            log.info((Object)"done.");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

