/*
 * Decompiled with CFR 0.152.
 */
package net.java.sen.tools;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Vector;
import net.java.sen.CToken;
import net.java.sen.tools.DictionaryMaker;
import net.java.sen.tools.PairObject;
import net.java.sen.util.CSVData;
import net.java.sen.util.CSVParser;
import net.java.sen.util.DoubleArrayTrie;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MkSenDic {
    private static Log log = LogFactory.getLog((Class)(class$net$java$sen$tools$MkSenDic == null ? (class$net$java$sen$tools$MkSenDic = MkSenDic.class$("net.java.sen.tools.MkSenDic")) : class$net$java$sen$tools$MkSenDic));
    static /* synthetic */ Class class$net$java$sen$tools$MkSenDic;

    public static void main(String[] args) {
        CToken token;
        int i;
        ResourceBundle rb = ResourceBundle.getBundle("dictionary");
        DictionaryMaker dm1 = new DictionaryMaker();
        DictionaryMaker dm2 = new DictionaryMaker();
        DictionaryMaker dm3 = new DictionaryMaker();
        Vector<String> rule1 = new Vector<String>();
        Vector<String> rule2 = new Vector<String>();
        Vector<String> rule3 = new Vector<String>();
        short[] score = new short[20131];
        long start = System.currentTimeMillis();
        log.info((Object)"(1/7): reading connection matrix ... ");
        try {
            String[] t;
            log.info((Object)("connection file = " + rb.getString("text_connection_file")));
            log.info((Object)("charset = " + rb.getString("dic.charset")));
            CSVParser csvparser = new CSVParser(new FileInputStream(rb.getString("text_connection_file")), rb.getString("dic.charset"));
            int line = 0;
            while ((t = csvparser.nextTokens()) != null) {
                if (t.length < 4) {
                    log.warn((Object)("invalid line in " + rb.getString("text_connection_file") + ":" + line));
                    log.warn((Object)(rb.getString("text_connection_file") + "may be broken."));
                    break;
                }
                dm1.add(t[0]);
                rule1.add(t[0]);
                dm2.add(t[1]);
                rule2.add(t[1]);
                dm3.add(t[2]);
                rule3.add(t[2]);
                if (line == score.length) {
                    score = MkSenDic.resize(score);
                }
                score[line++] = (short)Integer.parseInt(t[3]);
            }
            log.info((Object)"(2/7): building type dictionary ... ");
            dm1.build();
            dm2.build();
            dm3.build();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(0);
        }
        int size1 = dm1.size();
        int size2 = dm2.size();
        int size3 = dm3.size();
        int ruleSize = rule1.size();
        short[] matrix = new short[size1 * size2 * size3];
        short default_cost = (short)Integer.parseInt(rb.getString("default_connection_cost"));
        log.info((Object)("(3/7): writing conection matrix (" + size1 + " x " + size2 + " x " + size3 + " = " + size1 * size2 * size3 + ") ..."));
        for (i = 0; i < size1 * size2 * size3; ++i) {
            matrix[i] = default_cost;
        }
        for (i = 0; i < ruleSize; ++i) {
            Vector r1 = dm1.getRuleIdList((String)rule1.get(i));
            Vector r2 = dm2.getRuleIdList((String)rule2.get(i));
            Vector r3 = dm3.getRuleIdList((String)rule3.get(i));
            Iterator i1 = r1.iterator();
            while (i1.hasNext()) {
                int ii1 = (Integer)i1.next();
                Iterator i2 = r2.iterator();
                while (i2.hasNext()) {
                    int ii2 = (Integer)i2.next();
                    Iterator i3 = r3.iterator();
                    while (i3.hasNext()) {
                        int ii3 = (Integer)i3.next();
                        int pos = size3 * (size2 * ii1 + ii2) + ii3;
                        matrix[pos] = score[i];
                    }
                }
            }
        }
        try {
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(rb.getString("matrix_file"))));
            out.writeShort(size1);
            out.writeShort(size2);
            out.writeShort(size3);
            for (int i1 = 0; i1 < size1; ++i1) {
                for (int i2 = 0; i2 < size2; ++i2) {
                    for (int i3 = 0; i3 < size3; ++i3) {
                        out.writeShort(matrix[size3 * (size2 * i1 + i2) + i3]);
                    }
                }
            }
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(0);
        }
        matrix = null;
        score = null;
        int pos_start = Integer.parseInt(rb.getString("pos_start"));
        int pos_size = Integer.parseInt(rb.getString("pos_size"));
        int di = 0;
        int offset = 0;
        ArrayList<PairObject> dicList = new ArrayList<PairObject>();
        log.info((Object)"(4/7): reading morpheme information ... ");
        String t = null;
        String[] csv = null;
        try {
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(rb.getString("pos_file")), rb.getString("sen.charset")));
            log.info((Object)("load dic: " + rb.getString("text_dic_file")));
            BufferedReader dicStream = null;
            int custom_dic = -1;
            if (args.length == 0) {
                dicStream = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(rb.getString("text_dic_file")), rb.getString("dic.charset")));
            } else {
                custom_dic = 0;
                dicStream = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(args[custom_dic]), rb.getString("dic.charset")));
            }
            boolean line = false;
            CSVData key_b = new CSVData();
            CSVData pos_b = new CSVData();
            while (true) {
                int i2;
                if ((t = dicStream.readLine()) == null) {
                    dicStream.close();
                    if (args.length == ++custom_dic) break;
                    log.info((Object)"load dic: args[custum_dic]");
                    dicStream = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(args[custom_dic]), rb.getString("dic.charset")));
                    continue;
                }
                CSVParser parser = new CSVParser(t);
                csv = parser.nextTokens();
                if (csv.length < pos_size + pos_start) {
                    throw new RuntimeException("format error:" + t);
                }
                key_b.clear();
                pos_b.clear();
                for (i2 = pos_start; i2 < pos_start + pos_size - 1; ++i2) {
                    key_b.append(csv[i2]);
                    pos_b.append(csv[i2]);
                }
                key_b.append(csv[pos_start + pos_size - 1]);
                pos_b.append(csv[pos_start + pos_size - 1]);
                for (i2 = pos_start + pos_size; i2 < csv.length - 1; ++i2) {
                    pos_b.append(csv[i2]);
                }
                pos_b.append(csv[csv.length - 1]);
                token = new CToken();
                token.rcAttr2 = (short)dm1.getDicId(key_b.toString());
                token.rcAttr1 = (short)dm2.getDicId(key_b.toString());
                token.lcAttr = (short)dm3.getDicId(key_b.toString());
                token.posid = 0;
                token.posID = offset;
                token.length = (short)csv[0].length();
                token.cost = (short)Integer.parseInt(csv[1]);
                dicList.add(new PairObject(csv[0], token));
                byte[] b = pos_b.toString().getBytes(rb.getString("sen.charset"));
                offset += b.length + 1;
                String pos_b_str = pos_b.toString();
                bw.write(pos_b_str, 0, pos_b_str.length());
                bw.write(0);
                if (++di % 50000 != 0) continue;
                log.info((Object)("" + di + "... "));
            }
            bw.close();
        }
        catch (Exception e) {
            log.error((Object)("Error: " + t));
            e.printStackTrace();
            System.exit(1);
        }
        rule1 = null;
        rule2 = null;
        rule3 = null;
        log.info((Object)"(5/7): sorting lex... ");
        int[] value = new int[dicList.size()];
        char[][] key = new char[dicList.size()][];
        int spos = 0;
        int dsize = 0;
        int bsize = 0;
        String prev = "";
        Collections.sort(dicList);
        log.info((Object)"(6/7): writing token... ");
        try {
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(rb.getString("token_file"))));
            token = new CToken();
            token.rcAttr2 = (short)dm1.getDicId(rb.getString("bos_pos"));
            token.rcAttr1 = (short)dm2.getDicId(rb.getString("bos_pos"));
            token.lcAttr = (short)dm3.getDicId(rb.getString("bos_pos"));
            token.write(out);
            token.rcAttr2 = (short)dm1.getDicId(rb.getString("eos_pos"));
            token.rcAttr1 = (short)dm2.getDicId(rb.getString("eos_pos"));
            token.lcAttr = (short)dm3.getDicId(rb.getString("eos_pos"));
            token.write(out);
            token.rcAttr2 = (short)dm1.getDicId(rb.getString("unknown_pos"));
            token.rcAttr1 = (short)dm2.getDicId(rb.getString("unknown_pos"));
            token.lcAttr = (short)dm3.getDicId(rb.getString("unknown_pos"));
            token.posID = -1;
            token.write(out);
            log.info((Object)("key size = " + key.length));
            for (int i3 = 0; i3 < key.length; ++i3) {
                String k = (String)((PairObject)dicList.get((int)i3)).key;
                if (!prev.equals(k) && i3 != 0) {
                    key[dsize] = ((String)((PairObject)dicList.get((int)spos)).key).toCharArray();
                    value[dsize] = bsize + (spos << 8);
                    ++dsize;
                    bsize = 1;
                    spos = i3;
                } else {
                    ++bsize;
                }
                prev = (String)((PairObject)dicList.get((int)i3)).key;
                ((CToken)((PairObject)dicList.get((int)i3)).value).write(out);
            }
            out.flush();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        key[dsize] = ((String)((PairObject)dicList.get((int)spos)).key).toCharArray();
        value[dsize] = bsize + (spos << 8);
        dm1 = null;
        dm2 = null;
        dm3 = null;
        dicList = null;
        log.info((Object)("(7/7): building Double-Array (size = " + ++dsize + ") ..."));
        DoubleArrayTrie da = new DoubleArrayTrie();
        da.build(key, null, value, dsize);
        try {
            da.save(rb.getString("double_array_file"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        log.info((Object)("total time = " + (System.currentTimeMillis() - start) / 1000L + "[ms]"));
    }

    private static short[] resize(short[] s) {
        short[] newbuf = new short[(int)((double)s.length * 1.5)];
        for (int i = 0; i < s.length; ++i) {
            newbuf[i] = s[i];
        }
        return newbuf;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

