/*
 * Decompiled with CFR 0.152.
 */
package com.d_project.qrcode;

import com.d_project.qrcode.BitBuffer;
import com.d_project.qrcode.QRData;

class QRAlphaNum
extends QRData {
    public QRAlphaNum(String data) {
        super(2, data);
    }

    public void write(BitBuffer buffer) {
        char[] c = this.getData().toCharArray();
        int i = 0;
        while (i + 1 < c.length) {
            buffer.put(QRAlphaNum.getCode(c[i]) * 45 + QRAlphaNum.getCode(c[i + 1]), 11);
            i += 2;
        }
        if (i < c.length) {
            buffer.put(QRAlphaNum.getCode(c[i]), 6);
        }
    }

    public int getLength() {
        return this.getData().length();
    }

    private static int getCode(char c) {
        if ('0' <= c && c <= '9') {
            return c - 48;
        }
        if ('A' <= c && c <= 'Z') {
            return c - 65 + 10;
        }
        switch (c) {
            case ' ': {
                return 36;
            }
            case '$': {
                return 37;
            }
            case '%': {
                return 38;
            }
            case '*': {
                return 39;
            }
            case '+': {
                return 40;
            }
            case '-': {
                return 41;
            }
            case '.': {
                return 42;
            }
            case '/': {
                return 43;
            }
            case ':': {
                return 44;
            }
        }
        throw new IllegalArgumentException("illegal char :" + c);
    }
}

