/*
 * Decompiled with CFR 0.152.
 */
package com.d_project.qrcode;

import com.d_project.qrcode.BitBuffer;

abstract class QRData {
    private final int mode;
    private final String data;

    protected QRData(int mode, String data) {
        this.mode = mode;
        this.data = data;
    }

    public int getMode() {
        return this.mode;
    }

    public String getData() {
        return this.data;
    }

    public abstract int getLength();

    public abstract void write(BitBuffer var1);

    public int getLengthInBits(int type) {
        if (1 <= type && type < 10) {
            switch (this.mode) {
                case 1: {
                    return 10;
                }
                case 2: {
                    return 9;
                }
                case 4: {
                    return 8;
                }
                case 8: {
                    return 8;
                }
            }
            throw new IllegalArgumentException("mode:" + this.mode);
        }
        if (type < 27) {
            switch (this.mode) {
                case 1: {
                    return 12;
                }
                case 2: {
                    return 11;
                }
                case 4: {
                    return 16;
                }
                case 8: {
                    return 10;
                }
            }
            throw new IllegalArgumentException("mode:" + this.mode);
        }
        if (type < 41) {
            switch (this.mode) {
                case 1: {
                    return 14;
                }
                case 2: {
                    return 13;
                }
                case 4: {
                    return 16;
                }
                case 8: {
                    return 12;
                }
            }
            throw new IllegalArgumentException("mode:" + this.mode);
        }
        throw new IllegalArgumentException("type:" + type);
    }
}

