/*
 * Decompiled with CFR 0.152.
 */
package com.d_project.qrcode;

import com.d_project.qrcode.BitBuffer;
import com.d_project.qrcode.QRData;
import com.d_project.qrcode.QRUtil;
import java.io.UnsupportedEncodingException;

class QRKanji
extends QRData {
    public QRKanji(String data) {
        super(8, data);
    }

    public void write(BitBuffer buffer) {
        try {
            byte[] data = this.getData().getBytes(QRUtil.getJISEncoding());
            int i = 0;
            while (i + 1 < data.length) {
                int c = (0xFF & data[i]) << 8 | 0xFF & data[i + 1];
                if (33088 <= c && c <= 40956) {
                    c -= 33088;
                } else if (57408 <= c && c <= 60351) {
                    c -= 49472;
                } else {
                    throw new IllegalArgumentException("illegal char at " + (i + 1) + "/" + Integer.toHexString(c));
                }
                c = (c >>> 8 & 0xFF) * 192 + (c & 0xFF);
                buffer.put(c, 13);
                i += 2;
            }
            if (i < data.length) {
                throw new IllegalArgumentException("illegal char at " + (i + 1));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e.getMessage());
        }
    }

    public int getLength() {
        try {
            return this.getData().getBytes(QRUtil.getJISEncoding()).length / 2;
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e.getMessage());
        }
    }
}

