/*
 * Decompiled with CFR 0.152.
 */
package com.d_project.qrcode.web;

import com.d_project.qrcode.QRCode;
import com.d_project.qrcode.web.GIFImage;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import javax.imageio.ImageIO;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class QRCodeServlet
extends HttpServlet {
    private String defaultCharacterEncoding;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.defaultCharacterEncoding = this.getServletConfig().getInitParameter("default-character-encoding");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String data = QRCodeServlet.getParameter(request, "d", "qrcode");
        if (this.defaultCharacterEncoding != null) {
            data = new String(data.getBytes("ISO-8859-1"), this.defaultCharacterEncoding);
        }
        String output = QRCodeServlet.getParameter(request, "o", "image/gif");
        int typeNumber = QRCodeServlet.getIntParameter(request, "t", 0);
        if (typeNumber < 0 || 10 < typeNumber) {
            throw new IllegalArgumentException("illegal type number : " + typeNumber);
        }
        int margin = QRCodeServlet.getIntParameter(request, "m", 2);
        if (margin < 0 || 32 < margin) {
            throw new IllegalArgumentException("illegal margin : " + margin);
        }
        int cellSize = QRCodeServlet.getIntParameter(request, "s", 1);
        if (cellSize < 1 || 4 < cellSize) {
            throw new IllegalArgumentException("illegal cell size : " + cellSize);
        }
        int errorCorrectLevel = QRCodeServlet.parseErrorCorrectLevel(QRCodeServlet.getParameter(request, "e", "H"));
        QRCode qrcode = QRCodeServlet.getQRCode(data, typeNumber, errorCorrectLevel);
        if ("text/plain".equals(output)) {
            response.setContentType("text/plain");
            PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)response.getOutputStream(), "ISO-8859-1"));
            try {
                for (int row = 0; row < qrcode.getModuleCount(); ++row) {
                    for (int col = 0; col < qrcode.getModuleCount(); ++col) {
                        out.print(qrcode.isDark(row, col) ? "1" : "0");
                    }
                    out.print("\r\n");
                }
            }
            finally {
                out.close();
            }
        } else if ("image/jpeg".equals(output)) {
            BufferedImage image = qrcode.createImage(cellSize, margin);
            response.setContentType("image/jpeg");
            BufferedOutputStream out = new BufferedOutputStream((OutputStream)response.getOutputStream());
            try {
                ImageIO.write((RenderedImage)image, "jpeg", out);
            }
            finally {
                ((OutputStream)out).close();
            }
        } else if ("image/png".equals(output)) {
            BufferedImage image = qrcode.createImage(cellSize, margin);
            response.setContentType("image/png");
            BufferedOutputStream out = new BufferedOutputStream((OutputStream)response.getOutputStream());
            try {
                ImageIO.write((RenderedImage)image, "png", out);
            }
            finally {
                ((OutputStream)out).close();
            }
        } else if ("image/gif".equals(output)) {
            GIFImage image = QRCodeServlet.createGIFImage(qrcode, cellSize, margin);
            response.setContentType("image/gif");
            BufferedOutputStream out = new BufferedOutputStream((OutputStream)response.getOutputStream());
            try {
                image.write(out);
            }
            finally {
                ((OutputStream)out).close();
            }
        } else {
            throw new IllegalArgumentException("illegal output type : " + output);
        }
    }

    private static String getParameter(HttpServletRequest request, String name, String defaultValue) {
        String value = request.getParameter(name);
        return value != null ? value : defaultValue;
    }

    private static int getIntParameter(HttpServletRequest request, String name, int defaultValue) {
        String value = request.getParameter(name);
        return value != null ? Integer.parseInt(value) : defaultValue;
    }

    private static QRCode getQRCode(String text, int typeNumber, int errorCorrectLevel) {
        if (typeNumber == 0) {
            return QRCode.getMinimumQRCode(text, errorCorrectLevel);
        }
        QRCode qr = new QRCode();
        qr.setTypeNumber(typeNumber);
        qr.setErrorCorrectLevel(errorCorrectLevel);
        qr.addData(text);
        qr.make();
        return qr;
    }

    private static int parseErrorCorrectLevel(String ecl) {
        if ("L".equals(ecl)) {
            return 1;
        }
        if ("Q".equals(ecl)) {
            return 3;
        }
        if ("M".equals(ecl)) {
            return 0;
        }
        if ("H".equals(ecl)) {
            return 2;
        }
        throw new IllegalArgumentException("invalid error correct level : " + ecl);
    }

    private static GIFImage createGIFImage(QRCode qrcode, int cellSize, int margin) throws IOException {
        int imageSize = qrcode.getModuleCount() * cellSize + margin * 2;
        GIFImage image = new GIFImage(imageSize, imageSize);
        for (int y = 0; y < imageSize; ++y) {
            for (int x = 0; x < imageSize; ++x) {
                if (margin <= x && x < imageSize - margin && margin <= y && y < imageSize - margin) {
                    int row = (y - margin) / cellSize;
                    int col = (x - margin) / cellSize;
                    if (qrcode.isDark(row, col)) {
                        image.setPixel(x, y, 0);
                        continue;
                    }
                    image.setPixel(x, y, 1);
                    continue;
                }
                image.setPixel(x, y, 1);
            }
        }
        return image;
    }
}

