/*
 * Decompiled with CFR 0.152.
 */
package jp.groupsession.v3.mbh;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.stream.Collectors;
import jp.co.sjts.util.date.UDate;
import jp.co.sjts.util.jdbc.JDBCUtil;
import jp.groupsession.v2.batch.DayJob;
import jp.groupsession.v2.batch.IBatchListener;
import jp.groupsession.v2.batch.IBatchModel;
import jp.groupsession.v2.rap.mbh.push.biz.IPushOperationBiz;
import jp.groupsession.v2.rap.mbh.push.biz.PushOperationBiz;
import jp.groupsession.v3.mbh.dao.base.MblPushTokenDao;
import jp.groupsession.v3.mbh.dao.base.MblPushUidDao;
import jp.groupsession.v3.mbh.model.base.MblPushTokenModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MbhBatchListnerImpl
implements IBatchListener {
    private static Log log__ = LogFactory.getLog(MbhBatchListnerImpl.class);

    public void doDayBatch(Connection con, IBatchModel param) throws Exception {
        String pluginName = "GS\u30e2\u30d0\u30a4\u30eb";
        DayJob.outPutStartLog((Connection)con, (String)param.getDomain(), (String)pluginName, (String)"");
        long startTime = System.currentTimeMillis();
        Exception logException = null;
        boolean success = false;
        try {
            con.setAutoCommit(false);
            MblPushUidDao mblPushUidDao = new MblPushUidDao(con);
            MblPushTokenDao mblPushTokenDao = new MblPushTokenDao(con);
            UDate lastLoginDate = new UDate();
            lastLoginDate.addDay(-90);
            List<MblPushTokenModel> delTokenList = mblPushTokenDao.getUnlinkedToken(lastLoginDate);
            IPushOperationBiz pushOpeBiz = PushOperationBiz.getInstance((Connection)con, (String)param.getDomain());
            pushOpeBiz.deleteToken(con, delTokenList.stream().map(mdl -> mdl.getMptPushToken()).collect(Collectors.toList()));
            mblPushUidDao.delete();
            con.commit();
            success = true;
        }
        catch (SQLException e) {
            log__.error((Object)"SQLException", (Throwable)e);
            JDBCUtil.rollback((Connection)con);
            logException = e;
            throw e;
        }
        catch (Exception e) {
            logException = e;
            throw e;
        }
        finally {
            if (success) {
                DayJob.outPutFinishLog((Connection)con, (String)param.getDomain(), (String)pluginName, (long)startTime);
            } else {
                DayJob.outPutFailedLog((Connection)con, (String)param.getDomain(), (String)pluginName, (Throwable)logException);
            }
        }
    }

    public void doOneHourBatch(Connection con, IBatchModel param) throws Exception {
    }

    public void do5mBatch(Connection con, IBatchModel param) throws Exception {
    }
}

