/*
 * Decompiled with CFR 0.152.
 */
package jp.groupsession.v3.mbh;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import jp.co.sjts.util.StringUtil;
import jp.co.sjts.util.date.UDate;
import jp.co.sjts.util.http.TempFileUtil;
import jp.co.sjts.util.io.IOTools;
import jp.co.sjts.util.io.IOToolsException;
import jp.co.sjts.util.io.ObjectFile;
import jp.groupsession.v2.cmn.GSTemporaryPathUtil;
import jp.groupsession.v2.cmn.GSValidateUtil;
import jp.groupsession.v2.cmn.biz.LoggingBiz;
import jp.groupsession.v2.cmn.cmn110.Cmn110Biz;
import jp.groupsession.v2.cmn.cmn110.Cmn110FileModel;
import jp.groupsession.v2.cmn.cmn110.Cmn110ValidateResultModel;
import jp.groupsession.v2.cmn.dao.BaseUserModel;
import jp.groupsession.v2.cmn.dao.base.CmnFileConfDao;
import jp.groupsession.v2.cmn.model.RequestModel;
import jp.groupsession.v2.cmn.model.base.CmnFileConfModel;
import jp.groupsession.v2.cmn.model.base.CmnLogModel;
import jp.groupsession.v2.struts.msg.GsMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.upload.FormFile;
import org.apache.struts.util.LabelValueBean;
import org.apache.struts.util.MessageResources;

public class MbhCommonBiz {
    private static Log log__ = LogFactory.getLog(MbhCommonBiz.class);
    private static final int FILESIZE_NODATA = 0;
    private static final int FILE_SIZE_1MB = 0x100000;

    public void createTempDir(RequestModel reqMdl, String pluginId, String dirId, String ... subId) throws IOException, IOToolsException {
        String tempDir = this.getTempDir(reqMdl, pluginId, dirId, subId);
        GSTemporaryPathUtil tempPathUtil = GSTemporaryPathUtil.getInstance();
        tempPathUtil.createTempDir(reqMdl, pluginId, dirId, new String[0]);
        if (!tempPathUtil.checkTempPath(tempDir, reqMdl, pluginId, dirId, subId)) {
            throw new IOException("\u4e0d\u6b63\u306a\u30c6\u30f3\u30dd\u30e9\u30ea\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u30d1\u30b9\u304c\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f : tempDir = " + tempDir);
        }
    }

    public String uploadTempFile(FormFile formFile, RequestModel reqMdl, String pluginId, String dirId) throws Exception {
        String tempDir = null;
        try {
            tempDir = IOTools.replaceFileSep((String)this.getTempDir(reqMdl, pluginId, dirId, new String[0]));
        }
        catch (Exception e) {
            log__.error((Object)"\u6dfb\u4ed8\u30d5\u30a1\u30a4\u30eb\u306e\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9\u306b\u5931\u6557", (Throwable)e);
            throw new IOException();
        }
        return this.uploadTempFile(formFile, tempDir);
    }

    public String uploadTempFile(FormFile formFile, RequestModel reqMdl, String pluginId, String dirId, String subId) throws Exception {
        String tempDir = null;
        try {
            tempDir = this.getTempDir(reqMdl, pluginId, dirId, subId);
            tempDir = IOTools.replaceFileSep((String)tempDir);
        }
        catch (Exception e) {
            log__.error((Object)"\u6dfb\u4ed8\u30d5\u30a1\u30a4\u30eb\u306e\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9\u306b\u5931\u6557", (Throwable)e);
            throw new IOException();
        }
        return this.uploadTempFile(formFile, tempDir);
    }

    public String uploadTempFile(FormFile formFile, String tempDir) throws Exception {
        String saveFileName = null;
        try {
            String dateStr = new UDate().getDateString();
            int fileNum = Cmn110Biz.getFileNumber((String)tempDir, (String)dateStr);
            String fileName = new File(formFile.getFileName()).getName();
            long fileSize = formFile.getFileSize();
            File saveFilePath = Cmn110Biz.getSaveFilePath((String)tempDir, (String)dateStr, (int)(++fileNum));
            TempFileUtil.upload((FormFile)formFile, (String)tempDir, (String)saveFilePath.getName());
            File objFilePath = Cmn110Biz.getObjFilePath((String)tempDir, (String)dateStr, (int)fileNum);
            Cmn110FileModel fileMdl = new Cmn110FileModel();
            fileMdl.setFileName(fileName);
            fileMdl.setSaveFileName(saveFilePath.getName());
            fileMdl.setAtattiSize(fileSize);
            ObjectFile objFile = new ObjectFile(objFilePath.getParent(), objFilePath.getName());
            objFile.save((Object)fileMdl);
            saveFileName = saveFilePath.getName();
        }
        catch (Exception e) {
            log__.error((Object)"\u6dfb\u4ed8\u30d5\u30a1\u30a4\u30eb\u306e\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9\u306b\u5931\u6557", (Throwable)e);
            throw new IOException();
        }
        return saveFileName;
    }

    public void deleteTempFile(RequestModel reqMdl, String pluginId, String dirId, String saveFileName) throws Exception {
        String tempDir = this.getTempDir(reqMdl, pluginId, dirId, new String[0]);
        ObjectFile objFile = new ObjectFile(tempDir, saveFileName);
        Object fObj = objFile.load();
        Cmn110FileModel fMdl = (Cmn110FileModel)fObj;
        String oldObjName = fMdl.getSplitObjName();
        Object delPathObj = tempDir + oldObjName + "obj";
        delPathObj = IOTools.replaceFileSep((String)delPathObj);
        log__.debug((Object)("\u524a\u9664\u3059\u308b\u30d5\u30a1\u30a4\u30eb\u306e\u30d5\u30eb\u30d1\u30b9(\u30aa\u30d6\u30b8\u30a7\u30af\u30c8) = " + (String)delPathObj));
        Object delPathFile = tempDir + oldObjName + "file";
        delPathFile = IOTools.replaceFileSep((String)delPathFile);
        log__.debug((Object)("\u524a\u9664\u3059\u308b\u30d5\u30a1\u30a4\u30eb\u306e\u30d5\u30eb\u30d1\u30b9(\u672c\u4f53) = " + (String)delPathFile));
        IOTools.deleteFile((String)delPathObj);
        IOTools.deleteFile((String)delPathFile);
    }

    public String getTempDir(RequestModel reqMdl, String pluginId, String dirId, String ... tempDirId) {
        String tempDir = "";
        GSTemporaryPathUtil tempPathUtil = GSTemporaryPathUtil.getInstance();
        tempDir = tempDirId != null || tempDirId.length > 0 ? tempPathUtil.getTempPath(reqMdl, pluginId, dirId, tempDirId) : tempPathUtil.getTempPath(reqMdl, pluginId, dirId, new String[0]);
        return tempDir;
    }

    public void deleteTempDir(RequestModel reqMdl, String pluginId, String dirId, String ... subId) throws IOException, IOToolsException {
        GSTemporaryPathUtil tempPathUtil = GSTemporaryPathUtil.getInstance();
        String tempDir = this.getTempDir(reqMdl, pluginId, dirId, subId);
        if (IOTools.isDirCheck((String)tempDir, (boolean)false) && !tempPathUtil.checkTempPath(tempDir, reqMdl, pluginId, dirId, subId)) {
            throw new IOException("\u4e0d\u6b63\u306a\u30c6\u30f3\u30dd\u30e9\u30ea\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u30d1\u30b9\u304c\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f : tempDir = " + tempDir);
        }
        tempPathUtil.deleteTempPath(reqMdl, pluginId, dirId, subId);
    }

    public File getTempPath(RequestModel reqMdl, String pluginId, String dirId, UDate date, int fileNum) throws IOException {
        return Cmn110Biz.getSaveFilePath((String)this.getTempDir(reqMdl, pluginId, dirId, new String[0]), (String)date.getDateString(), (int)fileNum);
    }

    public Cmn110ValidateResultModel validateFile(List<FormFile> files, Connection con, HttpServletRequest req, int mode, MessageResources msgRes) throws SQLException, IOToolsException {
        Cmn110ValidateResultModel resultMdl = new Cmn110ValidateResultModel();
        GsMessage gsMsg = new GsMessage();
        if (files == null || files.size() <= 0) {
            resultMdl.addErrors(req, "error.input.notfound.file", "cmn.cmn110.error.input.notfound.file", 1, null);
            resultMdl.addErrMessage(msgRes.getMessage("error.input.notfound.file", (Object)"cmn.cmn110.error.input.notfound.file"));
            resultMdl.setErrorType(1);
            return resultMdl;
        }
        if (files.size() > 1 && mode == 1) {
            resultMdl.addErrors(req, "error.input.multiple.files", "cmn.cmn110.error.input.multiple.files", 1, null);
            resultMdl.addErrMessage(msgRes.getMessage("error.input.multiple.files", (Object)"cmn.cmn110.error.input.multiple.files"));
            resultMdl.setErrorType(1);
            return resultMdl;
        }
        int fileNo = 0;
        for (FormFile fileData : files) {
            String textFileName;
            ++fileNo;
            if (fileData == null || fileData.getFileSize() == 0) {
                resultMdl.addErrors(req, "error.input.notfound.file", "cmn.cmn110.error.input.notfound.file", fileNo, fileData.getFileName());
                resultMdl.addErrMessage(msgRes.getMessage("error.input.notfound.file", (Object)"cmn.cmn110.error.input.notfound.file", (Object)fileNo));
                continue;
            }
            if (fileData.getFileName().length() > 255) {
                textFileName = gsMsg.getMessage(req, "cmn.file.name");
                resultMdl.addErrors(req, "error.input.length.text", "cmn.cmn110.error.input.length.text", fileNo, fileData.getFileName(), new String[]{textFileName, Integer.toString(255)});
                resultMdl.addErrMessage(msgRes.getMessage("error.input.length.text", (Object)"cmn.cmn110.error.input.length.text", (Object)fileNo, (Object)new String[]{textFileName, Integer.toString(255)}));
                continue;
            }
            if (!GSValidateUtil.isGsJapaneaseString((String)fileData.getFileName())) {
                textFileName = gsMsg.getMessage(req, "cmn.file.name");
                String nstr = GSValidateUtil.getNotGsJapaneaseString((String)fileData.getFileName());
                resultMdl.addErrors(req, "error.input.njapan.text", "cmn.cmn110.error.input.njapan.text", fileNo, fileData.getFileName(), new String[]{textFileName, nstr});
                resultMdl.addErrMessage(msgRes.getMessage("error.input.njapan.text", (Object)"cmn.cmn110.error.input.njapan.text", (Object)fileNo, (Object)new String[]{textFileName, nstr}));
            }
            int maxSize = 0;
            CmnFileConfDao cfcDao = new CmnFileConfDao(con);
            CmnFileConfModel cfcMdl = cfcDao.select();
            maxSize = cfcMdl.getFicMaxSize() * 0x100000;
            if (fileData.getFileSize() <= maxSize) continue;
            resultMdl.addErrors(req, "error.input.capacity.over", "cmn.cmn110.error.input.capacity.over", fileNo, fileData.getFileName(), new String[]{cfcMdl.getFicMaxSize() + "MB"});
            resultMdl.addErrMessage(msgRes.getMessage("error.input.capacity.over", (Object)"cmn.cmn110.error.input.capacity.over", (Object)fileNo, (Object)new String[]{cfcMdl.getFicMaxSize() + "MB"}));
        }
        return resultMdl;
    }

    public List<LabelValueBean> getTempFileLabelList(String tempDir) throws IOToolsException {
        List fileList = IOTools.getFileNames((String)tempDir);
        ArrayList<LabelValueBean> fileLblList = new ArrayList<LabelValueBean>();
        if (fileList != null) {
            for (int i = 0; i < fileList.size(); ++i) {
                String fileName = (String)fileList.get(i);
                if (!fileName.endsWith("obj")) continue;
                String name = fileName.replaceFirst("obj", "file");
                long atattiSize = new File(tempDir, name).length();
                ObjectFile objFile = new ObjectFile(tempDir, fileName);
                Object fObj = objFile.load();
                if (fObj == null) continue;
                String[] value = fileName.split("obj");
                Cmn110FileModel fMdl = (Cmn110FileModel)fObj;
                fileLblList.add(new LabelValueBean(MbhCommonBiz.addAtattiSizeForName(fMdl.getFileName(), atattiSize), value[0]));
                log__.debug((Object)("\u30d5\u30a1\u30a4\u30eb\u540d = " + fMdl.getFileName()));
                log__.debug((Object)("\u4fdd\u5b58\u30d5\u30a1\u30a4\u30eb\u540d = " + fMdl.getSaveFileName()));
                log__.debug((Object)("\u30d5\u30a1\u30a4\u30eb\u30b5\u30a4\u30ba(byte) =" + fMdl.getAtattiSize()));
            }
        }
        return fileLblList;
    }

    public static String addAtattiSizeForName(String fileName, long byteSize) {
        String value = fileName + "(" + MbhCommonBiz.formatByteSizeString(byteSize) + ")";
        log__.debug((Object)("\u30d5\u30a1\u30a4\u30eb\u30b5\u30a4\u30ba :" + fileName));
        return value;
    }

    public static String formatByteSizeString(long byteSize) {
        String ret = "";
        String formatta = "0.0";
        DecimalFormat decimalFormat = new DecimalFormat(formatta);
        long divider = 1024L;
        String unit = "KB";
        log__.debug((Object)("\u30d5\u30a1\u30a4\u30eb\u30b5\u30a4\u30ba(byte) :" + byteSize));
        if (byteSize >= 0x100000L) {
            divider *= 1024L;
            unit = "MB";
        }
        BigDecimal bunbo = new BigDecimal(divider);
        BigDecimal bd = new BigDecimal(byteSize);
        ret = decimalFormat.format(bd.divide(bunbo, 1, 4));
        return ret.concat(unit);
    }

    public void outPutLog(String opCode, String level, String value, String type, RequestModel reqMdl, Connection con) {
        BaseUserModel usModel = reqMdl.getSmodel();
        int usrSid = usModel.getUsrsid();
        GsMessage gsMsg = new GsMessage(reqMdl);
        String msg = gsMsg.getMessage("mobile.4");
        UDate now = new UDate();
        CmnLogModel logMdl = new CmnLogModel();
        logMdl.setLogDate(now);
        logMdl.setUsrSid(usrSid);
        logMdl.setLogLevel(level);
        logMdl.setLogPlugin("mobile");
        logMdl.setLogPluginName(msg);
        logMdl.setLogPgId(StringUtil.trimRengeString((String)type, (int)100));
        logMdl.setLogPgName(this.getPgName(type, reqMdl));
        logMdl.setLogOpCode(opCode);
        logMdl.setLogOpValue(value);
        logMdl.setLogIp(reqMdl.getRemoteAddr());
        logMdl.setVerVersion("5.7.2");
        LoggingBiz logBiz = new LoggingBiz(con);
        String domain = reqMdl.getDomain();
        logBiz.outPutLog(logMdl, domain);
    }

    public String getPgName(String id, RequestModel reqMdl) {
        String ret = new String();
        if (id == null) {
            return ret;
        }
        log__.info((Object)("\u30d7\u30ed\u30b0\u30e9\u30e0ID==>" + id));
        GsMessage gsMsg = new GsMessage(reqMdl);
        if (id.equals("jp.groupsession.v3.mbh.usr060.MbhUsr060Action")) {
            String text = gsMsg.getMessage("cmn.change.password", null);
            return text;
        }
        if (id.equals("jp.groupsession.v3.mbh.push.PushServiceOperator")) {
            String text = gsMsg.getMessage("cmn.push.service", null);
            return text;
        }
        return ret;
    }

    public ArrayList<String> checkUserData(BaseUserModel smodel, Connection con) throws Exception {
        ArrayList<String> writeList = new ArrayList<String>();
        if (smodel == null) {
            log__.info((Object)"\u5165\u529bID\u30fb\u30d1\u30b9\u30ef\u30fc\u30c9\u306b\u8a72\u5f53\u3059\u308b\u30e6\u30fc\u30b6\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
            writeList.add("LGI_7");
            return writeList;
        }
        if (this.__checkSystemUser(smodel) || smodel.getMblUse() == 1) {
            log__.info((Object)"\u5165\u529bID\u30fb\u30d1\u30b9\u30ef\u30fc\u30c9\u306b\u8a72\u5f53\u3059\u308b\u30e6\u30fc\u30b6\u306f\u30e2\u30d0\u30a4\u30eb\u306e\u4f7f\u7528\u3092\u8a8d\u3081\u3089\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
            writeList.add("CMN_4");
            return writeList;
        }
        if (smodel.getUsrsid() > 100 && smodel.getUsrUkoFlg() == 1) {
            log__.info((Object)"\u5165\u529bID\u30fb\u30d1\u30b9\u30ef\u30fc\u30c9\u306b\u8a72\u5f53\u3059\u308b\u30e6\u30fc\u30b6\u306f\u30ed\u30b0\u30a4\u30f3\u3092\u8a8d\u3081\u3089\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
            writeList.add("CMN_7");
            return writeList;
        }
        return writeList;
    }

    private boolean __checkSystemUser(BaseUserModel smodel) {
        if (smodel != null) {
            int userSid = smodel.getUsrsid();
            return userSid == 0 || userSid == 1;
        }
        return false;
    }
}

