/*
 * Decompiled with CFR 0.152.
 */
package jp.groupsession.v3.mbh.api.login;

import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.SQLException;
import javax.servlet.http.HttpServletRequest;
import jp.co.sjts.util.DataSizeUtil;
import jp.co.sjts.util.NullDefault;
import jp.co.sjts.util.StringUtil;
import jp.co.sjts.util.date.UDate;
import jp.co.sjts.util.http.BrowserUtil;
import jp.co.sjts.util.jdbc.JDBCUtil;
import jp.groupsession.v2.cmn.GroupSession;
import jp.groupsession.v2.cmn.biz.CommonBiz;
import jp.groupsession.v2.cmn.biz.LoggingBiz;
import jp.groupsession.v2.cmn.dao.AuthDao;
import jp.groupsession.v2.cmn.dao.BaseUserModel;
import jp.groupsession.v2.cmn.dao.base.CmnLoginHistoryDao;
import jp.groupsession.v2.cmn.login.biz.GSLoginBiz;
import jp.groupsession.v2.cmn.model.RequestModel;
import jp.groupsession.v2.cmn.model.base.CmnLogModel;
import jp.groupsession.v2.cmn.model.base.CmnLoginHistoryModel;
import jp.groupsession.v2.cmn.model.base.CmnUsrmInfModel;
import jp.groupsession.v2.man.biz.MainUsedDataBiz;
import jp.groupsession.v2.mbh.interfaces.api.login.IMbhLoginHistoryBiz;
import jp.groupsession.v2.struts.msg.GsMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MbhApiAppLoginBiz
implements IMbhLoginHistoryBiz {
    private static Log log__ = LogFactory.getLog(MbhApiAppLoginBiz.class);

    public void writeLoginHistry(HttpServletRequest req, BaseUserModel smodel, Connection con, RequestModel reqMdl) throws Exception {
        GsMessage gsMsg = new GsMessage(reqMdl);
        con.setAutoCommit(false);
        boolean commitFlg = false;
        try {
            UserAgent agent = this.__makeUserAgent(req);
            this.__saveLoginHistry(smodel, agent, req, con);
            GSLoginBiz loginBiz = new GSLoginBiz();
            loginBiz.saveUuidIfAutoSave(smodel.getUsrsid(), agent.getUuid(), con, GroupSession.getResourceManager().getDomain(req));
            this.outPutCommonLog("jp.groupsession.v3.mbh.api.login.MbhApiAppLoginAction", reqMdl, con, gsMsg.getMessage(req, "cmn.login"), "info", NullDefault.getString((String)smodel.getLgid(), (String)""));
            commitFlg = true;
        }
        catch (SQLException e) {
            log__.error((Object)"SQL\u5b9f\u884c\u30a8\u30e9\u30fc:\u30ed\u30b0\u30a4\u30f3\u51e6\u7406\u306e\u5b9f\u884c\u306b\u5931\u6557", (Throwable)e);
            throw e;
        }
        finally {
            if (commitFlg) {
                con.commit();
            } else {
                JDBCUtil.rollback((Connection)con);
            }
        }
    }

    private UserAgent __makeUserAgent(HttpServletRequest req) {
        String uid = "";
        String agent = NullDefault.getString((String)req.getHeader("user-agent"), (String)"");
        if (BrowserUtil.isVodafone((HttpServletRequest)req) || BrowserUtil.isSoftBank((HttpServletRequest)req)) {
            String[] splitAgent = agent.split("/");
            if (splitAgent != null && splitAgent.length >= 0) {
                for (int i = 0; i < splitAgent.length; ++i) {
                    if (!splitAgent[i].startsWith("SN") || (uid = splitAgent[i]).indexOf(" ") <= 0) continue;
                    uid = uid.substring(0, uid.indexOf(" "));
                }
            }
        } else if (BrowserUtil.isAu((HttpServletRequest)req)) {
            uid = req.getHeader("X-Up-Subno");
        } else if (BrowserUtil.isDocomo((HttpServletRequest)req)) {
            uid = req.getHeader("user-agent");
            int begin = uid.indexOf("ser");
            if (begin > 0) {
                String str = uid.substring(begin);
                int end = -1;
                if (str.length() > 17) {
                    end = begin + 18;
                }
                uid = uid.substring(begin, end);
            } else {
                uid = "";
            }
        } else if (BrowserUtil.isMobileApps((HttpServletRequest)req)) {
            uid = req.getHeader("user-agent");
            int begin = uid.indexOf("SN(", uid.indexOf("GsMobileApps"));
            if (begin > 0) {
                int end = uid.indexOf(")", begin += 3);
                uid = uid.substring(begin, end);
            } else {
                uid = "";
            }
        } else {
            uid = "";
        }
        int clhKbn = 0;
        if (BrowserUtil.isDocomo((HttpServletRequest)req)) {
            clhKbn = 2;
        } else if (BrowserUtil.isAuWap20((HttpServletRequest)req) || agent.indexOf("BREW-Applet") >= 0) {
            clhKbn = 3;
        } else if (BrowserUtil.isVodafone((HttpServletRequest)req) || BrowserUtil.isSoftBank((HttpServletRequest)req)) {
            clhKbn = 4;
        }
        UserAgent ret = new UserAgent();
        ret.setClhKbn(clhKbn);
        ret.setUuid(uid);
        return ret;
    }

    public void saveLoginHistory(BaseUserModel smodel, HttpServletRequest req, Connection con) throws SQLException, UnsupportedEncodingException {
        this.__saveLoginHistry(smodel, this.__makeUserAgent(req), req, con);
    }

    private void __saveLoginHistry(BaseUserModel smodel, UserAgent agent, HttpServletRequest req, Connection con) throws SQLException, UnsupportedEncodingException {
        CmnLoginHistoryModel hismodel = new CmnLoginHistoryModel();
        hismodel.setUsrSid(smodel.getUsrsid());
        hismodel.setClhTerminal(2);
        hismodel.setClhIp(NullDefault.getString((String)CommonBiz.getRemoteAddr((HttpServletRequest)req), (String)""));
        hismodel.setClhCar(agent.getClhKbn());
        UDate now = new UDate();
        hismodel.setClhUid(agent.getUuid());
        hismodel.setClhAuid(smodel.getUsrsid());
        hismodel.setClhAdate(now);
        hismodel.setClhEuid(smodel.getUsrsid());
        hismodel.setClhEdate(now);
        CmnLoginHistoryDao hisDao = new CmnLoginHistoryDao(con);
        hisDao.insert(hismodel);
        MainUsedDataBiz usedDataBiz = new MainUsedDataBiz(con);
        long dataSize = DataSizeUtil.getUseDBsize((String[])new String[]{hismodel.getClhIp(), hismodel.getClhUid()});
        usedDataBiz.insertManDataSize(0L, dataSize);
        CmnUsrmInfModel ltmodel = new CmnUsrmInfModel();
        ltmodel.setUsrSid(smodel.getUsrsid());
        ltmodel.setUsiLtlgin(now);
        ltmodel.setUsiEdate(now);
        ltmodel.setUsiEuid(smodel.getUsrsid());
        AuthDao adao = new AuthDao(con);
        adao.updateLastLoginTime(ltmodel);
    }

    public void outPutCommonLog(String type, RequestModel reqMdl, Connection con, String opCode, String level, String value) {
        BaseUserModel usModel = reqMdl.getSmodel();
        int usrSid = -1;
        if (usModel != null) {
            usrSid = usModel.getUsrsid();
        }
        GsMessage gsMsg = new GsMessage(reqMdl);
        String textGSMobile = gsMsg.getMessage("mobile.4");
        UDate now = new UDate();
        CmnLogModel logMdl = new CmnLogModel();
        logMdl.setLogDate(now);
        logMdl.setUsrSid(usrSid);
        logMdl.setLogLevel(level);
        logMdl.setLogPlugin("mobile");
        logMdl.setLogPluginName(textGSMobile);
        logMdl.setLogPgId(StringUtil.trimRengeString((String)type, (int)100));
        logMdl.setLogPgName(this.getPgName(type, reqMdl));
        logMdl.setLogOpCode(opCode);
        logMdl.setLogOpValue(StringUtil.trimRengeString((String)value, (int)3000));
        logMdl.setLogIp(reqMdl.getRemoteAddr());
        logMdl.setVerVersion("5.7.2");
        LoggingBiz logBiz = new LoggingBiz(con);
        String domain = reqMdl.getDomain();
        logBiz.outPutLog(logMdl, domain);
    }

    public String getPgName(String id, RequestModel reqMdl) {
        String ret = new String();
        if (id == null) {
            return ret;
        }
        log__.info((Object)("\u30d7\u30ed\u30b0\u30e9\u30e0ID==>" + id));
        GsMessage gsMsg = new GsMessage(reqMdl);
        if (id.equals("jp.groupsession.v3.mbh.api.login.MbhApiAppLoginAction")) {
            return gsMsg.getMessage("cmn.login");
        }
        return ret;
    }

    private static class UserAgent {
        private int clhKbn__;
        private String uuid__;

        private UserAgent() {
        }

        int getClhKbn() {
            return this.clhKbn__;
        }

        void setClhKbn(int clhKbn) {
            this.clhKbn__ = clhKbn;
        }

        String getUuid() {
            return this.uuid__;
        }

        void setUuid(String uuid) {
            this.uuid__ = uuid;
        }
    }
}

