/*
 * Decompiled with CFR 0.152.
 */
package jp.groupsession.v3.mbh.biz;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import jp.co.sjts.util.NullDefault;
import jp.co.sjts.util.StringUtil;
import jp.groupsession.v2.cmn.ConfigBundle;
import jp.groupsession.v2.cmn.biz.CommonBiz;
import jp.groupsession.v2.cmn.config.PluginConfig;
import jp.groupsession.v2.cmn.dao.BaseUserModel;
import jp.groupsession.v2.restapi.exception.IReasonCode;
import jp.groupsession.v2.restapi.exception.RestApiException;
import jp.groupsession.v2.restapi.exception.RestApiPermissionException;
import jp.groupsession.v2.struts.msg.GsMessage;
import jp.groupsession.v3.mbh.model.UserAgent;
import jp.groupsession.v3.mbh.restapi.EnumReasonCode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MbhAccessCheckBiz {
    private static Log log__ = LogFactory.getLog(MbhAccessCheckBiz.class);
    private final Connection con__;
    private final UserAgent agent__;
    private final BaseUserModel loginUser__;
    private final PluginConfig pluginConfig__;
    private final GsMessage gsMsg__;

    public MbhAccessCheckBiz(Connection con, UserAgent agent, BaseUserModel loginUser, PluginConfig pluginConfig, GsMessage gsMsg) {
        this.con__ = con;
        this.agent__ = agent;
        this.loginUser__ = loginUser;
        this.pluginConfig__ = pluginConfig;
        this.gsMsg__ = gsMsg;
    }

    public boolean isUseMblUser() {
        return this.loginUser__.getMblUse() == 0;
    }

    public boolean isUseableMblPlugin() throws SQLException {
        CommonBiz cmnBiz = new CommonBiz();
        return cmnBiz.isCanUsePlugin("mobile", this.pluginConfig__) && cmnBiz.getCanUsePluginUser(this.con__, "mobile", List.of(Integer.valueOf(this.loginUser__.getUsrsid()))).size() != 0;
    }

    public void check() throws RestApiException, SQLException {
        if (!this.isUseMblUser()) {
            throw new RestApiPermissionException((IReasonCode)EnumReasonCode.RESOURCE_STOP_MOBILE, "error.cant.use.mobile", new Object[0]);
        }
        if (!this.isUseableMblPlugin()) {
            throw new RestApiPermissionException((IReasonCode)EnumReasonCode.RESOURCE_USER_CANTUSE_MOBILE, "error.cant.use.plugin", new Object[]{this.gsMsg__.getMessage("mobile.4")});
        }
        this.__checkVersion();
    }

    private void __checkVersion() {
        String appName = this.agent__.getAppId();
        String clVersion = this.agent__.getAppVersion();
        String configName = appName + "_version";
        String svVersion = NullDefault.getString((String)ConfigBundle.getValue((String)configName), (String)"").trim();
        if (StringUtil.isNullZeroStringSpace((String)svVersion)) {
            log__.warn((Object)"\u30b5\u30fc\u30d0\u3068\u30e2\u30d0\u30a4\u30eb\u306e\u30d0\u30fc\u30b8\u30e7\u30f3\u304c\u672a\u5bfe\u5fdc");
            throw new RestApiException(null).setReasonCode((IReasonCode)EnumReasonCode.RESOURCE_APPVERSION_OLD).setMessageResource("errors.free.msg", new Object[]{this.gsMsg__.getMessage("mobile.cmn001.error.not.suport.srvversion")});
        }
        if (clVersion.length() == 0) {
            throw new RestApiException(null).setReasonCode((IReasonCode)EnumReasonCode.RESOURCE_APPVERSION_OLD).setMessageResource("errors.free.msg", new Object[]{this.gsMsg__.getMessage("mobile.cmn001.error.not.suport.appversion")});
        }
        Iterator svvItr = Arrays.stream(svVersion.split("\\.")).map(str -> Integer.valueOf(str)).iterator();
        Iterator clvItr = Arrays.stream(clVersion.split("\\.")).map(str -> Integer.valueOf(str)).iterator();
        while (svvItr.hasNext()) {
            if (!clvItr.hasNext()) {
                throw new RestApiException(null).setReasonCode((IReasonCode)EnumReasonCode.RESOURCE_APPVERSION_OLD).setMessageResource("errors.free.msg", new Object[]{this.gsMsg__.getMessage("mobile.cmn001.error.not.suport.appversion")});
            }
            int svv = (Integer)svvItr.next();
            int clv = (Integer)clvItr.next();
            if (clv < svv) {
                throw new RestApiException(null).setReasonCode((IReasonCode)EnumReasonCode.RESOURCE_APPVERSION_OLD).setMessageResource("errors.free.msg", new Object[]{this.gsMsg__.getMessage("mobile.cmn001.error.not.suport.appversion")});
            }
            if (svv >= clv) continue;
            break;
        }
        log__.debug((Object)"\u30e2\u30d0\u30a4\u30eb\u5bfe\u5fdc\u6e08\u307f");
    }
}

