/*
 * Decompiled with CFR 0.152.
 */
package jp.groupsession.v3.mbh.dao.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import jp.co.sjts.util.dao.AbstractDao;
import jp.co.sjts.util.date.UDate;
import jp.co.sjts.util.jdbc.JDBCUtil;
import jp.co.sjts.util.jdbc.SqlBuffer;
import jp.groupsession.v3.mbh.model.base.MblPushErrorInfoModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MblPushErrorInfoDao
extends AbstractDao {
    private static Log log__ = LogFactory.getLog(MblPushErrorInfoDao.class);

    public MblPushErrorInfoDao() {
    }

    public MblPushErrorInfoDao(Connection con) {
        super(con);
    }

    public void dropTable() throws SQLException {
        PreparedStatement pstmt = null;
        Connection con = null;
        con = this.getCon();
        try {
            SqlBuffer sql = new SqlBuffer();
            sql.addSql("drop table MBL_PUSH_ERROR_INFO");
            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info((Object)sql.toLogString());
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                JDBCUtil.closeStatement(pstmt);
                throw throwable;
            }
        }
        JDBCUtil.closeStatement((Statement)pstmt);
    }

    public void createTable() throws SQLException {
        PreparedStatement pstmt = null;
        Connection con = null;
        con = this.getCon();
        try {
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" create table MBL_PUSH_ERROR_INFO (");
            sql.addSql("   PEI_ECODE varchar(75) not null,");
            sql.addSql("   PEI_MESSAGE varchar(150) not null,");
            sql.addSql("   PEI_AUID integer not null,");
            sql.addSql("   PEI_ADATE timestamp not null");
            sql.addSql(" )");
            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info((Object)sql.toLogString());
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                JDBCUtil.closeStatement(pstmt);
                throw throwable;
            }
        }
        JDBCUtil.closeStatement((Statement)pstmt);
    }

    public void insert(MblPushErrorInfoModel bean) throws SQLException {
        PreparedStatement pstmt = null;
        Connection con = null;
        con = this.getCon();
        try {
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" insert ");
            sql.addSql(" into ");
            sql.addSql(" MBL_PUSH_ERROR_INFO(");
            sql.addSql("   PEI_ECODE,");
            sql.addSql("   PEI_MESSAGE,");
            sql.addSql("   PEI_AUID,");
            sql.addSql("   PEI_ADATE");
            sql.addSql(" )");
            sql.addSql(" values");
            sql.addSql(" (");
            sql.addSql("   ?,");
            sql.addSql("   ?,");
            sql.addSql("   ?,");
            sql.addSql("   ?");
            sql.addSql(" )");
            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addStrValue(bean.getPeiEcode());
            sql.addStrValue(bean.getPeiMessage());
            sql.addIntValue(bean.getPeiAuid());
            sql.addDateValue(bean.getPeiAdate());
            log__.info((Object)sql.toLogString());
            sql.setParameter(pstmt);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                JDBCUtil.closeStatement(pstmt);
                throw throwable;
            }
        }
        JDBCUtil.closeStatement((Statement)pstmt);
    }

    public int update(MblPushErrorInfoModel bean) throws SQLException {
        PreparedStatement pstmt = null;
        int count = 0;
        Connection con = null;
        con = this.getCon();
        try {
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" update");
            sql.addSql("   MBL_PUSH_ERROR_INFO");
            sql.addSql(" set ");
            sql.addSql("   PEI_ECODE=?,");
            sql.addSql("   PEI_MESSAGE=?,");
            sql.addSql("   PEI_AUID=?,");
            sql.addSql("   PEI_ADATE=?");
            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addStrValue(bean.getPeiEcode());
            sql.addStrValue(bean.getPeiMessage());
            sql.addIntValue(bean.getPeiAuid());
            sql.addDateValue(bean.getPeiAdate());
            log__.info((Object)sql.toLogString());
            sql.setParameter(pstmt);
            count = pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                JDBCUtil.closeStatement(pstmt);
                throw throwable;
            }
        }
        JDBCUtil.closeStatement((Statement)pstmt);
        return count;
    }

    public ArrayList<MblPushErrorInfoModel> select() throws SQLException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        ArrayList<MblPushErrorInfoModel> ret = new ArrayList<MblPushErrorInfoModel>();
        con = this.getCon();
        try {
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select ");
            sql.addSql("   PEI_ECODE,");
            sql.addSql("   PEI_MESSAGE,");
            sql.addSql("   PEI_AUID,");
            sql.addSql("   PEI_ADATE");
            sql.addSql(" from ");
            sql.addSql("   MBL_PUSH_ERROR_INFO");
            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info((Object)sql.toLogString());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                ret.add(this.__getPushErrorInfoFromRs(rs));
            }
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                JDBCUtil.closeResultSet(rs);
                JDBCUtil.closeStatement(pstmt);
                throw throwable;
            }
        }
        JDBCUtil.closeResultSet((ResultSet)rs);
        JDBCUtil.closeStatement((Statement)pstmt);
        return ret;
    }

    private MblPushErrorInfoModel __getPushErrorInfoFromRs(ResultSet rs) throws SQLException {
        MblPushErrorInfoModel bean = new MblPushErrorInfoModel();
        bean.setPeiEcode(rs.getString("PEI_ECODE"));
        bean.setPeiMessage(rs.getString("PEI_MESSAGE"));
        bean.setPeiAuid(rs.getInt("PEI_AUID"));
        bean.setPeiAdate(UDate.getInstanceTimestamp((Timestamp)rs.getTimestamp("PEI_ADATE")));
        return bean;
    }

    public int deleteAll() throws SQLException {
        PreparedStatement pstmt = null;
        int count = 0;
        Connection con = null;
        con = this.getCon();
        try {
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" delete");
            sql.addSql(" from");
            sql.addSql("   MBL_PUSH_ERROR_INFO");
            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info((Object)sql.toLogString());
            sql.setParameter(pstmt);
            count = pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                JDBCUtil.closeStatement(pstmt);
                throw throwable;
            }
        }
        JDBCUtil.closeStatement((Statement)pstmt);
        return count;
    }

    public MblPushErrorInfoModel getErrorInfo() throws SQLException {
        return this.select().stream().findFirst().orElse(null);
    }

    public void saveErrorInfo(MblPushErrorInfoModel bean) throws SQLException {
        this.deleteAll();
        this.insert(bean);
    }
}

