/*
 * Decompiled with CFR 0.152.
 */
package jp.groupsession.v3.mbh.dao.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import jp.co.sjts.util.dao.AbstractDao;
import jp.co.sjts.util.date.UDate;
import jp.co.sjts.util.jdbc.JDBCUtil;
import jp.co.sjts.util.jdbc.SqlBuffer;
import jp.groupsession.v3.mbh.model.base.MblPushServerTokenModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MblPushServerTokenDao
extends AbstractDao {
    private static Log log__ = LogFactory.getLog(MblPushServerTokenDao.class);

    public MblPushServerTokenDao() {
    }

    public MblPushServerTokenDao(Connection con) {
        super(con);
    }

    public void dropTable() throws SQLException {
        PreparedStatement pstmt = null;
        Connection con = null;
        con = this.getCon();
        try {
            SqlBuffer sql = new SqlBuffer();
            sql.addSql("drop table MBL_PUSH_SERVER_TOKEN");
            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info((Object)sql.toLogString());
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                JDBCUtil.closeStatement(pstmt);
                throw throwable;
            }
        }
        JDBCUtil.closeStatement((Statement)pstmt);
    }

    public void createTable() throws SQLException {
        PreparedStatement pstmt = null;
        Connection con = null;
        con = this.getCon();
        try {
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" create table MBL_PUSH_SERVER_TOKEN (");
            sql.addSql("   PST_TOKEN varchar(75) not null,");
            sql.addSql("   PST_LIMIT timestamp not null,");
            sql.addSql("   primary key (PST_TOKEN)");
            sql.addSql(" )");
            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info((Object)sql.toLogString());
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                JDBCUtil.closeStatement(pstmt);
                throw throwable;
            }
        }
        JDBCUtil.closeStatement((Statement)pstmt);
    }

    public void insert(MblPushServerTokenModel bean) throws SQLException {
        PreparedStatement pstmt = null;
        Connection con = null;
        con = this.getCon();
        try {
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" insert ");
            sql.addSql(" into ");
            sql.addSql(" MBL_PUSH_SERVER_TOKEN(");
            sql.addSql("   PST_TOKEN,");
            sql.addSql("   PST_LIMIT");
            sql.addSql(" )");
            sql.addSql(" values");
            sql.addSql(" (");
            sql.addSql("   ?,");
            sql.addSql("   ?");
            sql.addSql(" )");
            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addStrValue(bean.getPstToken());
            sql.addDateValue(bean.getPstLimit());
            log__.info((Object)sql.toLogString());
            sql.setParameter(pstmt);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                JDBCUtil.closeStatement(pstmt);
                throw throwable;
            }
        }
        JDBCUtil.closeStatement((Statement)pstmt);
    }

    public int update(MblPushServerTokenModel bean) throws SQLException {
        PreparedStatement pstmt = null;
        int count = 0;
        Connection con = null;
        con = this.getCon();
        try {
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" update");
            sql.addSql("   MBL_PUSH_SERVER_TOKEN");
            sql.addSql(" set ");
            sql.addSql("   PST_LIMIT=?");
            sql.addSql(" where ");
            sql.addSql("   PST_TOKEN=?");
            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addDateValue(bean.getPstLimit());
            sql.addStrValue(bean.getPstToken());
            log__.info((Object)sql.toLogString());
            sql.setParameter(pstmt);
            count = pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                JDBCUtil.closeStatement(pstmt);
                throw throwable;
            }
        }
        JDBCUtil.closeStatement((Statement)pstmt);
        return count;
    }

    public ArrayList<MblPushServerTokenModel> select() throws SQLException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        ArrayList<MblPushServerTokenModel> ret = new ArrayList<MblPushServerTokenModel>();
        con = this.getCon();
        try {
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select ");
            sql.addSql("   PST_TOKEN,");
            sql.addSql("   PST_LIMIT");
            sql.addSql(" from ");
            sql.addSql("   MBL_PUSH_SERVER_TOKEN");
            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info((Object)sql.toLogString());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                ret.add(this.__getPushServerTokenFromRs(rs));
            }
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                JDBCUtil.closeResultSet(rs);
                JDBCUtil.closeStatement(pstmt);
                throw throwable;
            }
        }
        JDBCUtil.closeResultSet((ResultSet)rs);
        JDBCUtil.closeStatement((Statement)pstmt);
        return ret;
    }

    public MblPushServerTokenModel select(String pstToken) throws SQLException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        MblPushServerTokenModel ret = null;
        con = this.getCon();
        try {
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select");
            sql.addSql("   PST_TOKEN,");
            sql.addSql("   PST_LIMIT");
            sql.addSql(" from");
            sql.addSql("   MBL_PUSH_SERVER_TOKEN");
            sql.addSql(" where ");
            sql.addSql("   PST_TOKEN=?");
            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addStrValue(pstToken);
            log__.info((Object)sql.toLogString());
            sql.setParameter(pstmt);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                ret = this.__getPushServerTokenFromRs(rs);
            }
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                JDBCUtil.closeResultSet(rs);
                JDBCUtil.closeStatement(pstmt);
                throw throwable;
            }
        }
        JDBCUtil.closeResultSet((ResultSet)rs);
        JDBCUtil.closeStatement((Statement)pstmt);
        return ret;
    }

    public int delete(String pstToken) throws SQLException {
        PreparedStatement pstmt = null;
        int count = 0;
        Connection con = null;
        con = this.getCon();
        try {
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" delete");
            sql.addSql(" from");
            sql.addSql("   MBL_PUSH_SERVER_TOKEN");
            sql.addSql(" where ");
            sql.addSql("   PST_TOKEN=?");
            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addStrValue(pstToken);
            log__.info((Object)sql.toLogString());
            sql.setParameter(pstmt);
            count = pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                JDBCUtil.closeStatement(pstmt);
                throw throwable;
            }
        }
        JDBCUtil.closeStatement((Statement)pstmt);
        return count;
    }

    public int deleteAll() throws SQLException {
        PreparedStatement pstmt = null;
        int count = 0;
        Connection con = null;
        con = this.getCon();
        try {
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" delete");
            sql.addSql(" from");
            sql.addSql("   MBL_PUSH_SERVER_TOKEN");
            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info((Object)sql.toLogString());
            sql.setParameter(pstmt);
            count = pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                JDBCUtil.closeStatement(pstmt);
                throw throwable;
            }
        }
        JDBCUtil.closeStatement((Statement)pstmt);
        return count;
    }

    private MblPushServerTokenModel __getPushServerTokenFromRs(ResultSet rs) throws SQLException {
        MblPushServerTokenModel bean = new MblPushServerTokenModel();
        bean.setPstToken(rs.getString("PST_TOKEN"));
        bean.setPstLimit(UDate.getInstanceTimestamp((Timestamp)rs.getTimestamp("PST_LIMIT")));
        return bean;
    }

    public MblPushServerTokenModel getToken() throws SQLException {
        return this.select().stream().findFirst().orElse(null);
    }

    public void saveToken(MblPushServerTokenModel bean) throws SQLException {
        this.deleteAll();
        this.insert(bean);
    }
}

