/*
 * Decompiled with CFR 0.152.
 */
package jp.groupsession.v3.mbh.dao.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.co.sjts.util.dao.AbstractDao;
import jp.co.sjts.util.jdbc.JDBCUtil;
import jp.co.sjts.util.jdbc.SqlBuffer;
import jp.groupsession.v3.mbh.model.base.MblPushTargetIgnoreModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MblPushTargetIgnoreDao
extends AbstractDao {
    private static Log log__ = LogFactory.getLog(MblPushTargetIgnoreDao.class);

    public MblPushTargetIgnoreDao() {
    }

    public MblPushTargetIgnoreDao(Connection con) {
        super(con);
    }

    public void dropTable() throws SQLException {
        PreparedStatement pstmt = null;
        Connection con = null;
        con = this.getCon();
        try {
            SqlBuffer sql = new SqlBuffer();
            sql.addSql("drop table MBL_PUSH_TARGET_IGNORE");
            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info((Object)sql.toLogString());
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                JDBCUtil.closeStatement(pstmt);
                throw throwable;
            }
        }
        JDBCUtil.closeStatement((Statement)pstmt);
    }

    public void createTable() throws SQLException {
        PreparedStatement pstmt = null;
        Connection con = null;
        con = this.getCon();
        try {
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" create table MBL_PUSH_TARGET_IGNORE (");
            sql.addSql("   USR_SID integer not null,");
            sql.addSql("   APP_ID varchar(100) not null,");
            sql.addSql("   PLUGIN_ID varchar(20) not null,");
            sql.addSql("   PUC_SUBKBN varchar(20) not null,");
            sql.addSql("   PUC_SUBTARGET_SID integer not null,");
            sql.addSql("   primary key (USR_SID,APP_ID,PLUGIN_ID,PUC_SUBKBN,PUC_SUBTARGET_SID)");
            sql.addSql(" )");
            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info((Object)sql.toLogString());
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                JDBCUtil.closeStatement(pstmt);
                throw throwable;
            }
        }
        JDBCUtil.closeStatement((Statement)pstmt);
    }

    public void insert(MblPushTargetIgnoreModel bean) throws SQLException {
        PreparedStatement pstmt = null;
        Connection con = null;
        con = this.getCon();
        try {
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" insert ");
            sql.addSql(" into ");
            sql.addSql(" MBL_PUSH_TARGET_IGNORE(");
            sql.addSql("   USR_SID,");
            sql.addSql("   APP_ID,");
            sql.addSql("   PLUGIN_ID,");
            sql.addSql("   PUC_SUBKBN,");
            sql.addSql("   PUC_SUBTARGET_SID");
            sql.addSql(" )");
            sql.addSql(" values");
            sql.addSql(" (");
            sql.addSql("   ?,");
            sql.addSql("   ?,");
            sql.addSql("   ?,");
            sql.addSql("   ?,");
            sql.addSql("   ?");
            sql.addSql(" )");
            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addIntValue(bean.getUsrSid());
            sql.addStrValue(bean.getAppId());
            sql.addStrValue(bean.getPluginId());
            sql.addStrValue(bean.getPucSubkbn());
            sql.addIntValue(bean.getPucSubtargetSid());
            log__.info((Object)sql.toLogString());
            sql.setParameter(pstmt);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                JDBCUtil.closeStatement(pstmt);
                throw throwable;
            }
        }
        JDBCUtil.closeStatement((Statement)pstmt);
    }

    public int update(MblPushTargetIgnoreModel bean) throws SQLException {
        PreparedStatement pstmt = null;
        int count = 0;
        Connection con = null;
        con = this.getCon();
        try {
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" update");
            sql.addSql("   MBL_PUSH_TARGET_IGNORE");
            sql.addSql(" set ");
            sql.addSql(" where ");
            sql.addSql("   USR_SID=?");
            sql.addSql(" and");
            sql.addSql("   APP_ID=?");
            sql.addSql(" and");
            sql.addSql("   PLUGIN_ID=?");
            sql.addSql(" and");
            sql.addSql("   PUC_SUBKBN=?");
            sql.addSql(" and");
            sql.addSql("   PUC_SUBTARGET_SID=?");
            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addIntValue(bean.getUsrSid());
            sql.addStrValue(bean.getAppId());
            sql.addStrValue(bean.getPluginId());
            sql.addStrValue(bean.getPucSubkbn());
            sql.addIntValue(bean.getPucSubtargetSid());
            log__.info((Object)sql.toLogString());
            sql.setParameter(pstmt);
            count = pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                JDBCUtil.closeStatement(pstmt);
                throw throwable;
            }
        }
        JDBCUtil.closeStatement((Statement)pstmt);
        return count;
    }

    public List<MblPushTargetIgnoreModel> select() throws SQLException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        ArrayList<MblPushTargetIgnoreModel> ret = new ArrayList<MblPushTargetIgnoreModel>();
        con = this.getCon();
        try {
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select ");
            sql.addSql("   USR_SID,");
            sql.addSql("   APP_ID,");
            sql.addSql("   PLUGIN_ID,");
            sql.addSql("   PUC_SUBKBN,");
            sql.addSql("   PUC_SUBTARGET_SID");
            sql.addSql(" from ");
            sql.addSql("   MBL_PUSH_TARGET_IGNORE");
            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info((Object)sql.toLogString());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                ret.add(this.__getMblPushTargetIgnoreFromRs(rs));
            }
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                JDBCUtil.closeResultSet(rs);
                JDBCUtil.closeStatement(pstmt);
                throw throwable;
            }
        }
        JDBCUtil.closeResultSet((ResultSet)rs);
        JDBCUtil.closeStatement((Statement)pstmt);
        return ret;
    }

    public MblPushTargetIgnoreModel select(int usrSid, String appId, String pluginId, String pucSubkbn, int pucSubtargetSid) throws SQLException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        MblPushTargetIgnoreModel ret = null;
        con = this.getCon();
        try {
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select");
            sql.addSql("   USR_SID,");
            sql.addSql("   APP_ID,");
            sql.addSql("   PLUGIN_ID,");
            sql.addSql("   PUC_SUBKBN,");
            sql.addSql("   PUC_SUBTARGET_SID");
            sql.addSql(" from");
            sql.addSql("   MBL_PUSH_TARGET_IGNORE");
            sql.addSql(" where ");
            sql.addSql("   USR_SID=?");
            sql.addSql(" and");
            sql.addSql("   APP_ID=?");
            sql.addSql(" and");
            sql.addSql("   PLUGIN_ID=?");
            sql.addSql(" and");
            sql.addSql("   PUC_SUBKBN=?");
            sql.addSql(" and");
            sql.addSql("   PUC_SUBTARGET_SID=?");
            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addIntValue(usrSid);
            sql.addStrValue(appId);
            sql.addStrValue(pluginId);
            sql.addStrValue(pucSubkbn);
            sql.addIntValue(pucSubtargetSid);
            log__.info((Object)sql.toLogString());
            sql.setParameter(pstmt);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                ret = this.__getMblPushTargetIgnoreFromRs(rs);
            }
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                JDBCUtil.closeResultSet(rs);
                JDBCUtil.closeStatement(pstmt);
                throw throwable;
            }
        }
        JDBCUtil.closeResultSet((ResultSet)rs);
        JDBCUtil.closeStatement((Statement)pstmt);
        return ret;
    }

    public Map<String, List<MblPushTargetIgnoreModel>> getIgnoreMap(int usrSid, String appId) throws SQLException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        HashMap<String, List<MblPushTargetIgnoreModel>> ignoreMap = new HashMap<String, List<MblPushTargetIgnoreModel>>();
        con = this.getCon();
        try {
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select");
            sql.addSql("   USR_SID,");
            sql.addSql("   APP_ID,");
            sql.addSql("   PLUGIN_ID,");
            sql.addSql("   PUC_SUBKBN,");
            sql.addSql("   PUC_SUBTARGET_SID");
            sql.addSql(" from");
            sql.addSql("   MBL_PUSH_TARGET_IGNORE");
            sql.addSql(" where ");
            sql.addSql("   USR_SID=?");
            sql.addSql(" and");
            sql.addSql("   APP_ID=?");
            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addIntValue(usrSid);
            sql.addStrValue(appId);
            log__.info((Object)sql.toLogString());
            sql.setParameter(pstmt);
            rs = pstmt.executeQuery();
            MblPushTargetIgnoreModel ignoreMdl = null;
            while (rs.next()) {
                ignoreMdl = this.__getMblPushTargetIgnoreFromRs(rs);
                if (!ignoreMap.containsKey(ignoreMdl.getPluginId())) {
                    ignoreMap.put(ignoreMdl.getPluginId(), new ArrayList());
                }
                ((List)ignoreMap.get(ignoreMdl.getPluginId())).add(ignoreMdl);
            }
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                JDBCUtil.closeResultSet(rs);
                JDBCUtil.closeStatement(pstmt);
                throw throwable;
            }
        }
        JDBCUtil.closeResultSet((ResultSet)rs);
        JDBCUtil.closeStatement((Statement)pstmt);
        return ignoreMap;
    }

    public int delete(int usrSid, String appId, String pluginId, String pucSubkbn, int pucSubtargetSid) throws SQLException {
        PreparedStatement pstmt = null;
        int count = 0;
        Connection con = null;
        con = this.getCon();
        try {
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" delete");
            sql.addSql(" from");
            sql.addSql("   MBL_PUSH_TARGET_IGNORE");
            sql.addSql(" where ");
            sql.addSql("   USR_SID=?");
            sql.addSql(" and");
            sql.addSql("   APP_ID=?");
            sql.addSql(" and");
            sql.addSql("   PLUGIN_ID=?");
            sql.addSql(" and");
            sql.addSql("   PUC_SUBKBN=?");
            sql.addSql(" and");
            sql.addSql("   PUC_SUBTARGET_SID=?");
            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addIntValue(usrSid);
            sql.addStrValue(appId);
            sql.addStrValue(pluginId);
            sql.addStrValue(pucSubkbn);
            sql.addIntValue(pucSubtargetSid);
            log__.info((Object)sql.toLogString());
            sql.setParameter(pstmt);
            count = pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                JDBCUtil.closeStatement(pstmt);
                throw throwable;
            }
        }
        JDBCUtil.closeStatement((Statement)pstmt);
        return count;
    }

    public Map<Integer, List<Integer>> getNotPushAccountUserMap(String pluginId) throws SQLException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        HashMap<Integer, List<Integer>> ret = new HashMap<Integer, List<Integer>>();
        con = this.getCon();
        try {
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select");
            sql.addSql("   PUC_SUBTARGET_SID,");
            sql.addSql("   USR_SID");
            sql.addSql(" from");
            sql.addSql("   MBL_PUSH_TARGET_IGNORE");
            sql.addSql(" where ");
            sql.addSql("   APP_ID = ?");
            sql.addSql(" and ");
            sql.addSql("   PLUGIN_ID = ?");
            sql.addSql(" and ");
            sql.addSql("   PUC_SUBKBN = ?");
            sql.addStrValue("jp.co.sjts.mobile.gsapp");
            sql.addStrValue(pluginId);
            sql.addStrValue("accountSid");
            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info((Object)sql.toLogString());
            sql.setParameter(pstmt);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                int accountSid = rs.getInt("PUC_SUBTARGET_SID");
                if (!ret.containsKey(accountSid)) {
                    ret.put(accountSid, new ArrayList());
                }
                ((List)ret.get(accountSid)).add(rs.getInt("USR_SID"));
            }
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                JDBCUtil.closeResultSet(rs);
                JDBCUtil.closeStatement(pstmt);
                throw throwable;
            }
        }
        JDBCUtil.closeResultSet((ResultSet)rs);
        JDBCUtil.closeStatement((Statement)pstmt);
        return ret;
    }

    public List<Integer> getUserWithoutPushList(String pluginId) throws SQLException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        ArrayList<Integer> ret = new ArrayList<Integer>();
        con = this.getCon();
        try {
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select");
            sql.addSql("   USR_SID");
            sql.addSql(" from");
            sql.addSql("   MBL_PUSH_TARGET_IGNORE");
            sql.addSql(" where ");
            sql.addSql("   APP_ID = ?");
            sql.addSql(" and ");
            sql.addSql("   PLUGIN_ID = ?");
            sql.addSql(" and ");
            sql.addSql("   PUC_SUBKBN = ?");
            sql.addStrValue("jp.co.sjts.mobile.gsapp");
            sql.addStrValue(pluginId);
            sql.addStrValue("all");
            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info((Object)sql.toLogString());
            sql.setParameter(pstmt);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                ret.add(rs.getInt("USR_SID"));
            }
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                JDBCUtil.closeResultSet(rs);
                JDBCUtil.closeStatement(pstmt);
                throw throwable;
            }
        }
        JDBCUtil.closeResultSet((ResultSet)rs);
        JDBCUtil.closeStatement((Statement)pstmt);
        return ret;
    }

    private MblPushTargetIgnoreModel __getMblPushTargetIgnoreFromRs(ResultSet rs) throws SQLException {
        MblPushTargetIgnoreModel bean = new MblPushTargetIgnoreModel();
        bean.setUsrSid(rs.getInt("USR_SID"));
        bean.setAppId(rs.getString("APP_ID"));
        bean.setPluginId(rs.getString("PLUGIN_ID"));
        bean.setPucSubkbn(rs.getString("PUC_SUBKBN"));
        bean.setPucSubtargetSid(rs.getInt("PUC_SUBTARGET_SID"));
        return bean;
    }
}

