/*
 * Decompiled with CFR 0.152.
 */
package jp.groupsession.v3.mbh.dao.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import jp.co.sjts.util.dao.AbstractDao;
import jp.co.sjts.util.date.UDate;
import jp.co.sjts.util.jdbc.JDBCUtil;
import jp.co.sjts.util.jdbc.SqlBuffer;
import jp.groupsession.v3.mbh.model.base.MblPushTokenModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MblPushTokenDao
extends AbstractDao {
    private static Log log__ = LogFactory.getLog(MblPushTokenDao.class);

    public MblPushTokenDao() {
    }

    public MblPushTokenDao(Connection con) {
        super(con);
    }

    public void dropTable() throws SQLException {
        PreparedStatement pstmt = null;
        Connection con = null;
        con = this.getCon();
        try {
            SqlBuffer sql = new SqlBuffer();
            sql.addSql("drop table MBL_PUSH_TOKEN");
            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info((Object)sql.toLogString());
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                JDBCUtil.closeStatement(pstmt);
                throw throwable;
            }
        }
        JDBCUtil.closeStatement((Statement)pstmt);
    }

    public void createTable() throws SQLException {
        PreparedStatement pstmt = null;
        Connection con = null;
        con = this.getCon();
        try {
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" create table MBL_PUSH_TOKEN (");
            sql.addSql("   MPT_PUSH_TOKEN varchar(256) not null,");
            sql.addSql("   USR_SID integer not null,");
            sql.addSql("   CMU_UID varchar(50) not null,");
            sql.addSql("   MPT_APP_ID varchar(256) not null,");
            sql.addSql("   primary key (MPT_PUSH_TOKEN)");
            sql.addSql(" )");
            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info((Object)sql.toLogString());
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                JDBCUtil.closeStatement(pstmt);
                throw throwable;
            }
        }
        JDBCUtil.closeStatement((Statement)pstmt);
    }

    public void insert(MblPushTokenModel bean) throws SQLException {
        PreparedStatement pstmt = null;
        Connection con = null;
        con = this.getCon();
        try {
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" insert ");
            sql.addSql(" into ");
            sql.addSql(" MBL_PUSH_TOKEN(");
            sql.addSql("   MPT_PUSH_TOKEN,");
            sql.addSql("   USR_SID,");
            sql.addSql("   CMU_UID,");
            sql.addSql("   MPT_APP_ID");
            sql.addSql(" )");
            sql.addSql(" values");
            sql.addSql(" (");
            sql.addSql("   ?,");
            sql.addSql("   ?,");
            sql.addSql("   ?,");
            sql.addSql("   ?");
            sql.addSql(" )");
            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addStrValue(bean.getMptPushToken());
            sql.addIntValue(bean.getUsrSid());
            sql.addStrValue(bean.getCmuUid());
            sql.addStrValue(bean.getMptAppId());
            log__.info((Object)sql.toLogString());
            sql.setParameter(pstmt);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                JDBCUtil.closeStatement(pstmt);
                throw throwable;
            }
        }
        JDBCUtil.closeStatement((Statement)pstmt);
    }

    public int update(MblPushTokenModel bean) throws SQLException {
        PreparedStatement pstmt = null;
        int count = 0;
        Connection con = null;
        con = this.getCon();
        try {
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" update");
            sql.addSql("   MBL_PUSH_TOKEN");
            sql.addSql(" set ");
            sql.addSql("   USR_SID=?,");
            sql.addSql("   CMU_UID=?,");
            sql.addSql("   MPT_APP_ID=?");
            sql.addSql(" where ");
            sql.addSql("   MPT_PUSH_TOKEN=?");
            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addIntValue(bean.getUsrSid());
            sql.addStrValue(bean.getCmuUid());
            sql.addStrValue(bean.getMptAppId());
            sql.addStrValue(bean.getMptPushToken());
            log__.info((Object)sql.toLogString());
            sql.setParameter(pstmt);
            count = pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                JDBCUtil.closeStatement(pstmt);
                throw throwable;
            }
        }
        JDBCUtil.closeStatement((Statement)pstmt);
        return count;
    }

    public ArrayList<MblPushTokenModel> select() throws SQLException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        ArrayList<MblPushTokenModel> ret = new ArrayList<MblPushTokenModel>();
        con = this.getCon();
        try {
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select ");
            sql.addSql("   MPT_PUSH_TOKEN,");
            sql.addSql("   USR_SID,");
            sql.addSql("   CMU_UID,");
            sql.addSql("   MPT_APP_ID");
            sql.addSql(" from ");
            sql.addSql("   MBL_PUSH_TOKEN");
            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info((Object)sql.toLogString());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                ret.add(this.__getMblPushTokenFromRs(rs));
            }
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                JDBCUtil.closeResultSet(rs);
                JDBCUtil.closeStatement(pstmt);
                throw throwable;
            }
        }
        JDBCUtil.closeResultSet((ResultSet)rs);
        JDBCUtil.closeStatement((Statement)pstmt);
        return ret;
    }

    public MblPushTokenModel select(String cptPushToken) throws SQLException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        MblPushTokenModel ret = null;
        con = this.getCon();
        try {
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select");
            sql.addSql("   MPT_PUSH_TOKEN,");
            sql.addSql("   USR_SID,");
            sql.addSql("   CMU_UID,");
            sql.addSql("   MPT_APP_ID");
            sql.addSql(" from");
            sql.addSql("   MBL_PUSH_TOKEN");
            sql.addSql(" where ");
            sql.addSql("   MPT_PUSH_TOKEN=?");
            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addStrValue(cptPushToken);
            log__.info((Object)sql.toLogString());
            sql.setParameter(pstmt);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                ret = this.__getMblPushTokenFromRs(rs);
            }
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                JDBCUtil.closeResultSet(rs);
                JDBCUtil.closeStatement(pstmt);
                throw throwable;
            }
        }
        JDBCUtil.closeResultSet((ResultSet)rs);
        JDBCUtil.closeStatement((Statement)pstmt);
        return ret;
    }

    public ArrayList<MblPushTokenModel> getToken(String uid) throws SQLException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        ArrayList<MblPushTokenModel> ret = new ArrayList<MblPushTokenModel>();
        con = this.getCon();
        try {
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select");
            sql.addSql("   MPT_PUSH_TOKEN,");
            sql.addSql("   USR_SID,");
            sql.addSql("   CMU_UID,");
            sql.addSql("   MPT_APP_ID");
            sql.addSql(" from");
            sql.addSql("   MBL_PUSH_TOKEN");
            sql.addSql(" where ");
            sql.addSql("   CMU_UID = ?");
            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addStrValue(uid);
            log__.info((Object)sql.toLogString());
            sql.setParameter(pstmt);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                MblPushTokenModel cptMdl = this.__getMblPushTokenFromRs(rs);
                ret.add(cptMdl);
            }
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                JDBCUtil.closeResultSet(rs);
                JDBCUtil.closeStatement(pstmt);
                throw throwable;
            }
        }
        JDBCUtil.closeResultSet((ResultSet)rs);
        JDBCUtil.closeStatement((Statement)pstmt);
        return ret;
    }

    public ArrayList<MblPushTokenModel> getToken(int usrSid) throws SQLException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        ArrayList<MblPushTokenModel> ret = new ArrayList<MblPushTokenModel>();
        con = this.getCon();
        try {
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select");
            sql.addSql("   MPT_PUSH_TOKEN,");
            sql.addSql("   USR_SID,");
            sql.addSql("   CMU_UID,");
            sql.addSql("   MPT_APP_ID");
            sql.addSql(" from");
            sql.addSql("   MBL_PUSH_TOKEN");
            sql.addSql(" where ");
            sql.addSql("   USR_SID = ?");
            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addIntValue(usrSid);
            log__.info((Object)sql.toLogString());
            sql.setParameter(pstmt);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                MblPushTokenModel cptMdl = this.__getMblPushTokenFromRs(rs);
                ret.add(cptMdl);
            }
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                JDBCUtil.closeResultSet(rs);
                JDBCUtil.closeStatement(pstmt);
                throw throwable;
            }
        }
        JDBCUtil.closeResultSet((ResultSet)rs);
        JDBCUtil.closeStatement((Statement)pstmt);
        return ret;
    }

    public ArrayList<MblPushTokenModel> getToken(int usrSid, String pluginId) throws SQLException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        ArrayList<MblPushTokenModel> ret = new ArrayList<MblPushTokenModel>();
        con = this.getCon();
        try {
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select");
            sql.addSql("   MPT_PUSH_TOKEN,");
            sql.addSql("   USR_SID,");
            sql.addSql("   CMU_UID,");
            sql.addSql("   MPT_APP_ID");
            sql.addSql(" from");
            sql.addSql("   MBL_PUSH_TOKEN");
            sql.addSql(" where ");
            sql.addSql("   USR_SID = ?");
            sql.addSql("   and MPT_APP_ID = ?");
            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addIntValue(usrSid);
            sql.addStrValue(pluginId);
            log__.info((Object)sql.toLogString());
            sql.setParameter(pstmt);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                MblPushTokenModel cptMdl = this.__getMblPushTokenFromRs(rs);
                ret.add(cptMdl);
            }
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                JDBCUtil.closeResultSet(rs);
                JDBCUtil.closeStatement(pstmt);
                throw throwable;
            }
        }
        JDBCUtil.closeResultSet((ResultSet)rs);
        JDBCUtil.closeStatement((Statement)pstmt);
        return ret;
    }

    public int delete(String cptPushToken) throws SQLException {
        PreparedStatement pstmt = null;
        int count = 0;
        Connection con = null;
        con = this.getCon();
        try {
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" delete");
            sql.addSql(" from");
            sql.addSql("   MBL_PUSH_TOKEN");
            sql.addSql(" where ");
            sql.addSql("   MPT_PUSH_TOKEN=?");
            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addStrValue(cptPushToken);
            log__.info((Object)sql.toLogString());
            sql.setParameter(pstmt);
            count = pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                JDBCUtil.closeStatement(pstmt);
                throw throwable;
            }
        }
        JDBCUtil.closeStatement((Statement)pstmt);
        return count;
    }

    public int delete(Collection<String> cptPushTokenList) throws SQLException {
        if (cptPushTokenList == null || cptPushTokenList.size() <= 0) {
            return 0;
        }
        ArrayList<String> exeList = new ArrayList<String>();
        Iterator<String> itr = cptPushTokenList.iterator();
        StringBuilder sb = new StringBuilder();
        int count = 0;
        sb.append(" delete");
        sb.append(" from");
        sb.append("   MBL_PUSH_TOKEN ");
        Connection con = null;
        con = this.getCon();
        while (itr.hasNext()) {
            exeList.add(itr.next());
            if (exeList.size() < 500 && itr.hasNext()) continue;
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(sb.toString());
            sql.addSql(" where ");
            sql.addSql("   MPT_PUSH_TOKEN in");
            sql.addSql(" (");
            Iterator exeItr = exeList.iterator();
            while (exeItr.hasNext()) {
                sql.addSql("   ?");
                sql.addStrValue((String)exeItr.next());
                if (!exeItr.hasNext()) continue;
                sql.addSql(",");
            }
            sql.addSql(" )");
            try (PreparedStatement pstmt = con.prepareStatement(sql.toSqlString());){
                sql.setParameter(pstmt);
                log__.info((Object)sql.toLogString());
                count += pstmt.executeUpdate();
            }
            exeList.clear();
        }
        return count;
    }

    private MblPushTokenModel __getMblPushTokenFromRs(ResultSet rs) throws SQLException {
        MblPushTokenModel bean = new MblPushTokenModel();
        bean.setMptPushToken(rs.getString("MPT_PUSH_TOKEN"));
        bean.setUsrSid(rs.getInt("USR_SID"));
        bean.setCmuUid(rs.getString("CMU_UID"));
        bean.setMptAppId(rs.getString("MPT_APP_ID"));
        return bean;
    }

    public List<MblPushTokenModel> getUnlinkedToken(UDate limitLoginDate) throws SQLException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        ArrayList<MblPushTokenModel> ret = new ArrayList<MblPushTokenModel>();
        con = this.getCon();
        UDate now = new UDate();
        SqlBuffer sql = new SqlBuffer();
        sql.addSql(" select");
        sql.addSql("   MPT_PUSH_TOKEN,");
        sql.addSql("   USR_SID,");
        sql.addSql("   CMU_UID,");
        sql.addSql("   MPT_APP_ID");
        sql.addSql(" from");
        sql.addSql("   MBL_PUSH_TOKEN");
        sql.addSql(" where");
        sql.addSql("   MBL_PUSH_TOKEN.USR_SID not in (");
        sql.addSql("     select");
        sql.addSql("       API_TOKEN.USR_SID");
        sql.addSql("     from");
        sql.addSql("       API_TOKEN");
        sql.addSql("     where");
        sql.addSql("       APT_CLIENT = ?");
        sql.addIntValue(2);
        sql.addSql("     and");
        sql.addSql("       APT_JKBN = ?");
        sql.addIntValue(0);
        sql.addSql("     and");
        sql.addSql("       APT_LIMIT_DATE >= ?");
        sql.addDateValue(now);
        sql.addSql("   )");
        sql.addSql(" or");
        sql.addSql("   MBL_PUSH_TOKEN.USR_SID in (");
        sql.addSql("     select");
        sql.addSql("       USR_SID");
        sql.addSql("     from");
        sql.addSql("       MBL_PUSH_UID");
        sql.addSql("     where ");
        sql.addSql("       MPI_LOGINDATE < ?");
        sql.addDateValue(limitLoginDate);
        sql.addSql("   )");
        log__.info((Object)sql.toLogString());
        pstmt = con.prepareStatement(sql.toSqlString());
        log__.info((Object)sql.toLogString());
        sql.setParameter(pstmt);
        rs = pstmt.executeQuery();
        while (rs.next()) {
            MblPushTokenModel cptMdl = this.__getMblPushTokenFromRs(rs);
            ret.add(cptMdl);
        }
        return ret;
    }

    public List<MblPushTokenModel> select(Collection<String> tokenList) throws SQLException {
        Connection con = null;
        ArrayList<MblPushTokenModel> ret = new ArrayList<MblPushTokenModel>();
        if (tokenList == null || tokenList.isEmpty()) {
            return ret;
        }
        ArrayList<String> exeList = new ArrayList<String>();
        Iterator<String> itr = tokenList.iterator();
        StringBuilder sb = new StringBuilder();
        sb.append(" select");
        sb.append("   MPT_PUSH_TOKEN,");
        sb.append("   USR_SID,");
        sb.append("   CMU_UID,");
        sb.append("   MPT_APP_ID");
        sb.append(" from ");
        sb.append("   MBL_PUSH_TOKEN ");
        con = this.getCon();
        while (itr.hasNext()) {
            exeList.add(itr.next());
            if (exeList.size() < 500 && itr.hasNext()) continue;
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(sb.toString());
            sql.addSql(" where");
            sql.addSql("  MPT_PUSH_TOKEN in (");
            Iterator exeItr = exeList.iterator();
            while (exeItr.hasNext()) {
                sql.addSql("   ?");
                sql.addStrValue((String)exeItr.next());
                if (!exeItr.hasNext()) continue;
                sql.addSql(",");
            }
            sql.addSql(" )");
            try (PreparedStatement pstmt = con.prepareStatement(sql.toSqlString());){
                sql.setParameter(pstmt);
                log__.info((Object)sql.toLogString());
                try (ResultSet rs = pstmt.executeQuery();){
                    while (rs.next()) {
                        ret.add(this.__getMblPushTokenFromRs(rs));
                    }
                }
            }
            exeList.clear();
        }
        return ret;
    }
}

