/*
 * Decompiled with CFR 0.152.
 */
package jp.groupsession.v3.mbh.dao.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import jp.co.sjts.util.dao.AbstractDao;
import jp.co.sjts.util.date.UDate;
import jp.co.sjts.util.jdbc.JDBCUtil;
import jp.co.sjts.util.jdbc.SqlBuffer;
import jp.groupsession.v3.mbh.model.base.MblPushUidModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MblPushUidDao
extends AbstractDao {
    private static Log log__ = LogFactory.getLog(MblPushUidDao.class);

    public MblPushUidDao() {
    }

    public MblPushUidDao(Connection con) {
        super(con);
    }

    public void dropTable() throws SQLException {
        PreparedStatement pstmt = null;
        Connection con = null;
        con = this.getCon();
        try {
            SqlBuffer sql = new SqlBuffer();
            sql.addSql("drop table MBL_PUSH_UID");
            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info((Object)sql.toLogString());
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                JDBCUtil.closeStatement(pstmt);
                throw throwable;
            }
        }
        JDBCUtil.closeStatement((Statement)pstmt);
    }

    public void createTable() throws SQLException {
        PreparedStatement pstmt = null;
        Connection con = null;
        con = this.getCon();
        try {
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" create table MBL_PUSH_UID (");
            sql.addSql("   CMU_UID varchar(50) not null,");
            sql.addSql("   USR_SID integer not null,");
            sql.addSql("   MPI_LOGINDATE timestamp not null,");
            sql.addSql("   primary key (CMU_UID)");
            sql.addSql(" )");
            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info((Object)sql.toLogString());
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                JDBCUtil.closeStatement(pstmt);
                throw throwable;
            }
        }
        JDBCUtil.closeStatement((Statement)pstmt);
    }

    public void insert(MblPushUidModel bean) throws SQLException {
        PreparedStatement pstmt = null;
        Connection con = null;
        con = this.getCon();
        try {
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" insert ");
            sql.addSql(" into ");
            sql.addSql(" MBL_PUSH_UID(");
            sql.addSql("   CMU_UID,");
            sql.addSql("   USR_SID,");
            sql.addSql("   MPI_LOGINDATE");
            sql.addSql(" )");
            sql.addSql(" values");
            sql.addSql(" (");
            sql.addSql("   ?,");
            sql.addSql("   ?,");
            sql.addSql("   ?");
            sql.addSql(" )");
            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addStrValue(bean.getCmuUid());
            sql.addIntValue(bean.getUsrSid());
            sql.addDateValue(bean.getMpiLogindate());
            log__.info((Object)sql.toLogString());
            sql.setParameter(pstmt);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                JDBCUtil.closeStatement(pstmt);
                throw throwable;
            }
        }
        JDBCUtil.closeStatement((Statement)pstmt);
    }

    public int update(MblPushUidModel bean) throws SQLException {
        PreparedStatement pstmt = null;
        int count = 0;
        Connection con = null;
        con = this.getCon();
        try {
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" update");
            sql.addSql("   MBL_PUSH_UID");
            sql.addSql(" set ");
            sql.addSql("   USR_SID=?,");
            sql.addSql("   MPI_LOGINDATE=?");
            sql.addSql(" where ");
            sql.addSql("   CMU_UID=?");
            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addIntValue(bean.getUsrSid());
            sql.addDateValue(bean.getMpiLogindate());
            sql.addStrValue(bean.getCmuUid());
            log__.info((Object)sql.toLogString());
            sql.setParameter(pstmt);
            count = pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                JDBCUtil.closeStatement(pstmt);
                throw throwable;
            }
        }
        JDBCUtil.closeStatement((Statement)pstmt);
        return count;
    }

    public List<MblPushUidModel> select() throws SQLException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        ArrayList<MblPushUidModel> ret = new ArrayList<MblPushUidModel>();
        con = this.getCon();
        try {
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select ");
            sql.addSql("   CMU_UID,");
            sql.addSql("   USR_SID,");
            sql.addSql("   MPI_LOGINDATE");
            sql.addSql(" from ");
            sql.addSql("   MBL_PUSH_UID");
            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info((Object)sql.toLogString());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                ret.add(this.__getMblPushUidFromRs(rs));
            }
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                JDBCUtil.closeResultSet(rs);
                JDBCUtil.closeStatement(pstmt);
                throw throwable;
            }
        }
        JDBCUtil.closeResultSet((ResultSet)rs);
        JDBCUtil.closeStatement((Statement)pstmt);
        return ret;
    }

    private SqlBuffer __getSelectSql() {
        SqlBuffer sql = new SqlBuffer();
        sql.addSql(" select");
        sql.addSql("   CMU_UID,");
        sql.addSql("   USR_SID,");
        sql.addSql("   MPI_LOGINDATE");
        return sql;
    }

    public MblPushUidModel select(String cmuUid) throws SQLException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        MblPushUidModel ret = null;
        con = this.getCon();
        try {
            SqlBuffer sql = this.__getSelectSql();
            sql.addSql(" from");
            sql.addSql("   MBL_PUSH_UID");
            sql.addSql(" where ");
            sql.addSql("   CMU_UID=?");
            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addStrValue(cmuUid);
            log__.info((Object)sql.toLogString());
            sql.setParameter(pstmt);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                ret = this.__getMblPushUidFromRs(rs);
            }
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                JDBCUtil.closeResultSet(rs);
                JDBCUtil.closeStatement(pstmt);
                throw throwable;
            }
        }
        JDBCUtil.closeResultSet((ResultSet)rs);
        JDBCUtil.closeStatement((Statement)pstmt);
        return ret;
    }

    public List<MblPushUidModel> select(List<String> cmuUidList) throws SQLException {
        ArrayList<MblPushUidModel> ret = new ArrayList<MblPushUidModel>();
        if (cmuUidList == null || cmuUidList.isEmpty()) {
            return ret;
        }
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        con = this.getCon();
        try {
            SqlBuffer sql = this.__getSelectSql();
            sql.addSql(" from");
            sql.addSql("   MBL_PUSH_UID");
            sql.addSql(" where ");
            sql.addSql("   CMU_UID in (");
            for (int idx = 0; idx < cmuUidList.size(); ++idx) {
                if (idx != 0) {
                    sql.addSql(", ");
                }
                sql.addSql("?");
                sql.addStrValue(cmuUidList.get(idx));
            }
            sql.addSql("   )");
            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info((Object)sql.toLogString());
            sql.setParameter(pstmt);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                ret.add(this.__getMblPushUidFromRs(rs));
            }
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                JDBCUtil.closeResultSet(rs);
                JDBCUtil.closeStatement(pstmt);
                throw throwable;
            }
        }
        JDBCUtil.closeResultSet((ResultSet)rs);
        JDBCUtil.closeStatement((Statement)pstmt);
        return ret;
    }

    public int delete(String cmuUid) throws SQLException {
        PreparedStatement pstmt = null;
        int count = 0;
        Connection con = null;
        con = this.getCon();
        try {
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" delete");
            sql.addSql(" from");
            sql.addSql("   MBL_PUSH_UID");
            sql.addSql(" where ");
            sql.addSql("   CMU_UID=?");
            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addStrValue(cmuUid);
            log__.info((Object)sql.toLogString());
            sql.setParameter(pstmt);
            count = pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                JDBCUtil.closeStatement(pstmt);
                throw throwable;
            }
        }
        JDBCUtil.closeStatement((Statement)pstmt);
        return count;
    }

    private MblPushUidModel __getMblPushUidFromRs(ResultSet rs) throws SQLException {
        MblPushUidModel bean = new MblPushUidModel();
        bean.setCmuUid(rs.getString("CMU_UID"));
        bean.setUsrSid(rs.getInt("USR_SID"));
        bean.setMpiLogindate(UDate.getInstanceTimestamp((Timestamp)rs.getTimestamp("MPI_LOGINDATE")));
        return bean;
    }

    public void delete() throws SQLException {
        PreparedStatement pstmt = null;
        Connection con = null;
        con = this.getCon();
        try {
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" delete");
            sql.addSql(" from");
            sql.addSql("   MBL_PUSH_UID");
            sql.addSql(" where ");
            sql.addSql("   not exists (");
            sql.addSql("     select ");
            sql.addSql("       MBL_PUSH_TOKEN.CMU_UID");
            sql.addSql("     from ");
            sql.addSql("       MBL_PUSH_TOKEN");
            sql.addSql("     where ");
            sql.addSql("       MBL_PUSH_TOKEN.CMU_UID = MBL_PUSH_UID.CMU_UID");
            sql.addSql("   )");
            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info((Object)sql.toLogString());
            sql.setParameter(pstmt);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                JDBCUtil.closeStatement(pstmt);
                throw throwable;
            }
        }
        JDBCUtil.closeStatement((Statement)pstmt);
    }
}

