/*
 * Decompiled with CFR 0.152.
 */
package jp.groupsession.v3.mbh.push;

import java.io.IOException;
import java.net.URI;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jp.co.sjts.util.NullDefault;
import jp.co.sjts.util.StringUtil;
import jp.co.sjts.util.date.UDate;
import jp.co.sjts.util.encryption.Blowfish;
import jp.co.sjts.util.encryption.EncryptionException;
import jp.groupsession.v2.api.dao.ApiTokenDao;
import jp.groupsession.v2.cht.model.ChtPushRequestModel;
import jp.groupsession.v2.cmn.ConfigBundle;
import jp.groupsession.v2.cmn.GroupSession;
import jp.groupsession.v2.cmn.biz.CloseableThreadName;
import jp.groupsession.v2.cmn.biz.CommonBiz;
import jp.groupsession.v2.cmn.config.PluginConfig;
import jp.groupsession.v2.cmn.dao.BaseUserModel;
import jp.groupsession.v2.cmn.dao.UserSearchDao;
import jp.groupsession.v2.cmn.http.HttpOperation;
import jp.groupsession.v2.cmn.http.HttpRequestModel;
import jp.groupsession.v2.cmn.http.HttpResponseModel;
import jp.groupsession.v2.cmn.model.PushRequestModel;
import jp.groupsession.v2.cmn.model.RequestModel;
import jp.groupsession.v2.lic.LicenseModel;
import jp.groupsession.v2.lic.LicenseOperation;
import jp.groupsession.v2.rap.mbh.push.IPushOperationConsumer;
import jp.groupsession.v2.rap.mbh.push.IPushServiceOperator;
import jp.groupsession.v2.rap.mbh.push.api.DelMblTokenRequest;
import jp.groupsession.v2.rap.mbh.push.api.IPushApiRequest;
import jp.groupsession.v2.rap.mbh.push.api.PostMblTokenRequest;
import jp.groupsession.v2.rap.mbh.push.api.PrePostMblTokenRequest;
import jp.groupsession.v2.rap.mbh.push.api.SendMessageRequest;
import jp.groupsession.v2.rap.mbh.push.api.UpdMblTokenRequest;
import jp.groupsession.v2.rap.mbh.push.biz.IPushOperationBiz;
import jp.groupsession.v2.rap.mbh.push.exception.PushServiceException;
import jp.groupsession.v2.sch.model.SchPushRequestModel;
import jp.groupsession.v2.sml.model.SmlPushRequestModel;
import jp.groupsession.v2.struts.msg.GsMessage;
import jp.groupsession.v2.wml.model.WmlPushRequestModel;
import jp.groupsession.v3.mbh.MbhCommonBiz;
import jp.groupsession.v3.mbh.dao.base.MblPushErrorInfoDao;
import jp.groupsession.v3.mbh.dao.base.MblPushServerTokenDao;
import jp.groupsession.v3.mbh.dao.base.MblPushTargetIgnoreDao;
import jp.groupsession.v3.mbh.dao.base.MblPushTokenDao;
import jp.groupsession.v3.mbh.dao.base.MblPushUidDao;
import jp.groupsession.v3.mbh.model.base.MblPushErrorInfoModel;
import jp.groupsession.v3.mbh.model.base.MblPushServerTokenModel;
import jp.groupsession.v3.mbh.model.base.MblPushTokenModel;
import jp.groupsession.v3.mbh.model.base.MblPushUidModel;
import jp.groupsession.v3.mbh.push.PushServiceApiResponse;
import jp.groupsession.v3.mbh.push.api.EnumPushServiceApiRequest;
import jp.groupsession.v3.mbh.push.api.PostJwtRequest;
import jp.groupsession.v3.mbh.push.biz.PushOperationBiz;
import jp.groupsession.v3.mbh.push.exception.PushServiceOperationException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.logging.log4j.CloseableThreadContext;

public class PushServiceOperator
implements IPushServiceOperator {
    private static Log log__ = LogFactory.getLog(PushServiceOperator.class);
    private static final Object JWT_LOCK = new Object();
    private static final AtomicInteger EXE_STATUS = new AtomicInteger();
    private static final int TOKEN_LIMIT_EDIT_DAYS = 90;
    String domain__;
    Map<String, MblPushServerTokenModel> gsJWTMap__ = Collections.synchronizedMap(new HashMap());
    MblPushServerTokenModel gsJWT__ = null;
    LicenseModel lmdl__ = null;
    private HttpOperation httpOperation__;
    private static final int TIMEOUT__ = 30;
    private static final List<Runnable> CONSUMERPOOL__ = Collections.synchronizedList(new ArrayList());
    private static final String LIC_TOKEN_PHRASE = "X73ZZ3MFMQ945UTH";

    private PushServiceOperator() {
    }

    public static PushServiceOperator getInstance(Connection con, String domain) {
        LicenseOperation licenseOp = new LicenseOperation();
        if (!licenseOp.isPushLicense(con, domain)) {
            log__.info((Object)"\u30e9\u30a4\u30bb\u30f3\u30b9\u30a8\u30e9\u30fc\u306b\u3088\u308b\u30d7\u30c3\u30b7\u30e5\u901a\u77e5\u5bfe\u8c61\u5916\u74b0\u5883");
            return null;
        }
        PushServiceOperator ret = new PushServiceOperator();
        ret.lmdl__ = (LicenseModel)GroupSession.getResourceManager().getLicenseMdl(domain);
        ret.domain__ = domain;
        try {
            ret.httpOperation__ = new HttpOperation(con, 30, 30);
        }
        catch (SQLException | EncryptionException e) {
            throw new RuntimeException(e);
        }
        return ret;
    }

    public boolean isUseable() {
        return true;
    }

    public String api(IPushApiRequest pushRequest) {
        try {
            this.__getJWT();
            PushServiceApiResponse resp = this.__apiReq(pushRequest);
            return resp.toString();
        }
        catch (PushServiceException e) {
            this.__writeErrorLog(e);
            return null;
        }
    }

    private PushServiceApiResponse __apiReq(IPushApiRequest req) throws PushServiceException {
        String baseUrl = ConfigBundle.getValue((String)"GSPUSH_SERVER_URL");
        if (StringUtil.isNullZeroString((String)baseUrl)) {
            throw new PushServiceException("\u4e2d\u7d99\u30b5\u30fc\u30d0\u63a5\u7d9a\u5148\u8a2d\u5b9a\u304c\u3042\u308a\u307e\u305b\u3093");
        }
        EnumPushServiceApiRequest reqConst = null;
        String token = "";
        if (this.gsJWT__ != null) {
            token = this.gsJWT__.getPstToken();
        }
        StringBuilder pathParam = new StringBuilder();
        StringBuilder queryParam = new StringBuilder();
        if (req instanceof PostJwtRequest) {
            reqConst = EnumPushServiceApiRequest.PST_JWT;
            token = this.__getEncryptedToken(this.lmdl__.getPushLicenseToken());
        }
        if (req instanceof SendMessageRequest) {
            reqConst = EnumPushServiceApiRequest.PST_MESSAGE;
        }
        if (req instanceof PrePostMblTokenRequest) {
            reqConst = EnumPushServiceApiRequest.PST_PRE_MBLTOKEN;
        }
        if (req instanceof PostMblTokenRequest) {
            reqConst = EnumPushServiceApiRequest.PST_MBLTOKEN;
        }
        if (req instanceof DelMblTokenRequest) {
            reqConst = EnumPushServiceApiRequest.DEL_FCMTOKEN;
        }
        if (req instanceof UpdMblTokenRequest) {
            reqConst = EnumPushServiceApiRequest.UPD_FCMTOKEN;
        }
        if (reqConst == null) {
            throw new PushServiceOperationException("\u4e0d\u6b63\u306a\u30ea\u30af\u30a8\u30b9\u30c8\u30af\u30e9\u30b9\u3092\u4f7f\u7528", "error.invalid.requestclass");
        }
        try {
            StringBuilder urlb = new StringBuilder();
            urlb.append(baseUrl);
            urlb.append(reqConst.getUrl());
            if (pathParam.length() > 0) {
                urlb.append(pathParam.toString());
            }
            if (queryParam.length() > 0) {
                urlb.append("?");
                urlb.append(queryParam.toString());
            }
            String url = URI.create(urlb.toString()).toString();
            HttpRequestModel httpReqMdl = new HttpRequestModel();
            int httpMethod = 0;
            switch (reqConst.getMethod()) {
                case "GET": {
                    httpMethod = 0;
                    break;
                }
                case "POST": {
                    httpMethod = 1;
                    httpReqMdl.setBodyString(req.getParam());
                    httpReqMdl.addHeader("Content-Type", "application/json");
                    break;
                }
                case "PUT": {
                    httpMethod = 2;
                    httpReqMdl.setBodyString(req.getParam());
                    httpReqMdl.addHeader("Content-Type", "application/json");
                    break;
                }
                case "DELETE": {
                    httpMethod = 4;
                    break;
                }
                default: {
                    throw new PushServiceOperationException("\u4e0d\u6b63\u306a\u30ea\u30af\u30a8\u30b9\u30c8\u30af\u30e9\u30b9\u3092\u4f7f\u7528", "error.invalid.requestclass");
                }
            }
            httpReqMdl.addHeader("Authorization", String.format("Bearer %s", token));
            log__.info((Object)("push api reqURI:" + url));
            log__.info((Object)("push api reqHeader:" + Stream.of(httpReqMdl.getHeader()).map(h -> h.toString()).collect(Collectors.joining(" , "))));
            log__.info((Object)("push api reqBody:" + req.getParam()));
            HttpResponseModel httpResMdl = this.httpOperation__.sendRequest(url, httpReqMdl, httpMethod);
            log__.info((Object)("push api resStatus:" + httpResMdl.getStatusCode()));
            log__.info((Object)("push api response:" + httpResMdl.getBody()));
            return PushServiceApiResponse.getResponce(httpResMdl);
        }
        catch (PushServiceOperationException e) {
            throw e;
        }
        catch (IOException e) {
            throw new PushServiceOperationException("HTTP\u30ea\u30af\u30a8\u30b9\u30c8\u9001\u4fe1\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\u30d7\u30ed\u30ad\u30b7\u30b5\u30fc\u30d0\u8a2d\u5b9a\u304c\u4e0d\u6b63\u306a\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002", "error.faild.http.reqeust.io", e);
        }
        catch (InterruptedException e) {
            throw new PushServiceOperationException("HTTP\u30ea\u30af\u30a8\u30b9\u30c8\u9001\u4fe1\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\u30d7\u30ed\u30ad\u30b7\u30b5\u30fc\u30d0\u8a2d\u5b9a\u304c\u4e0d\u6b63\u306a\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002", "error.faild.http.reqeust.interrupted", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPushServiceOperator doOperation(IPushOperationConsumer function) {
        PushServiceOperator opr = this;
        List<Runnable> list = CONSUMERPOOL__;
        synchronized (list) {
            CONSUMERPOOL__.add(() -> {
                try (CloseableThreadContext.Instance ctc = CloseableThreadContext.put((String)"gsdomain", (String)opr.domain__);
                     CloseableThreadName tnc = CloseableThreadName.setName((String)("PushServiceBatch-" + System.currentTimeMillis() + "-" + opr.domain__ + "-" + Thread.currentThread().getId()));){
                    opr.__getJWT();
                    function.accept((IPushServiceOperator)opr);
                }
                catch (PushServiceException e) {
                    opr.__writeErrorLog(e);
                }
            });
        }
        if (EXE_STATUS.get() != 0) {
            return this;
        }
        new Thread(() -> {
            EXE_STATUS.set(1);
            ArrayList<Runnable> exeList = new ArrayList<Runnable>();
            List<Runnable> list = CONSUMERPOOL__;
            synchronized (list) {
                exeList.addAll(CONSUMERPOOL__);
                CONSUMERPOOL__.clear();
            }
            while (!exeList.isEmpty()) {
                exeList.parallelStream().forEach(func -> func.run());
                exeList.clear();
                list = CONSUMERPOOL__;
                synchronized (list) {
                    exeList.addAll(CONSUMERPOOL__);
                    CONSUMERPOOL__.clear();
                }
            }
            EXE_STATUS.set(0);
        }).start();
        return this;
    }

    private void __writeErrorLog(PushServiceException e) {
        log__.info((Object)"\u4e2d\u7d99\u30b5\u30fc\u30d0\u901a\u4fe1 \u5b9f\u884c\u4f8b\u5916", (Throwable)e);
        if (!(e instanceof PushServiceOperationException)) {
            return;
        }
        PushServiceOperationException oe = (PushServiceOperationException)e;
        if (StringUtil.isNullZeroString((String)oe.getEcode())) {
            return;
        }
        try (Connection con = GroupSession.getConnection((String)this.domain__);){
            con.setAutoCommit(false);
            UDate now = new UDate();
            MblPushErrorInfoDao eDao = new MblPushErrorInfoDao(con);
            if (Optional.ofNullable(eDao.getErrorInfo()).map(eInf -> {
                UDate chk = eInf.getPeiAdate().cloneUDate();
                chk.addDay(1);
                if (chk.compare(chk, now) == -1) {
                    return eInf.getPeiEcode();
                }
                return null;
            }).orElse("").equals(oe.getEcode())) {
                return;
            }
            MblPushErrorInfoModel eInf2 = new MblPushErrorInfoModel();
            eInf2.setPeiAdate(now);
            eInf2.setPeiEcode(oe.getEcode());
            eInf2.setPeiMessage(Optional.ofNullable(oe.getMessage()).map(mes -> {
                if (mes.length() > 150) {
                    return mes.substring(0, 150);
                }
                return mes;
            }).orElse(""));
            eDao.saveErrorInfo(eInf2);
            RequestModel reqMdl = new RequestModel();
            reqMdl.setDomain(this.domain__);
            reqMdl.setLocale(Locale.JAPANESE);
            reqMdl.setSmodel(new BaseUserModel());
            reqMdl.setRemoteAddr("");
            GsMessage gsMsg = new GsMessage(reqMdl);
            MbhCommonBiz cmnBiz = new MbhCommonBiz();
            cmnBiz.outPutLog(gsMsg.getMessage("cmn.push.service"), "info", Optional.ofNullable(e.getMessage()).map(s -> String.format("%s:", s)).orElse("") + NullDefault.getString((String)e.getMessage(), (String)""), this.getClass().getPackageName(), reqMdl, con);
            con.commit();
        }
        catch (Exception e2) {
            log__.error((Object)"\u901a\u77e5\u30a8\u30e9\u30fc \u30aa\u30da\u30ec\u30fc\u30b7\u30e7\u30f3\u30ed\u30b0 \u5b9f\u884c\u4f8b\u5916", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized MblPushServerTokenModel __getJWT() throws PushServiceException {
        MblPushServerTokenModel model = null;
        Object object = JWT_LOCK;
        synchronized (object) {
            model = this.gsJWTMap__.get(this.domain__);
            UDate chk = new UDate();
            chk.addMinute(5);
            if (model != null && chk.compare(chk, model.getPstLimit()) == 1) {
                return model;
            }
            try (Connection updCon = GroupSession.getConnection((String)this.domain__);){
                MblPushServerTokenDao readTokenDao = new MblPushServerTokenDao(updCon);
                try {
                    model = readTokenDao.getToken();
                }
                catch (SQLException e) {
                    throw new PushServiceOperationException("", e);
                }
                if (model != null && chk.compare(chk, model.getPstLimit()) == 1) {
                    this.gsJWTMap__.put(this.domain__, model);
                    this.gsJWT__ = model;
                    MblPushServerTokenModel e = model;
                    return e;
                }
                updCon.setAutoCommit(false);
                MblPushServerTokenDao dao = new MblPushServerTokenDao(updCon);
                model = dao.getToken();
                if (model != null && chk.compare(chk, model.getPstLimit()) == 1) {
                    this.gsJWTMap__.put(this.domain__, model);
                    this.gsJWT__ = model;
                    MblPushServerTokenModel mblPushServerTokenModel = model;
                    return mblPushServerTokenModel;
                }
                PostJwtRequest req = new PostJwtRequest();
                PushServiceApiResponse resp = this.__apiReq(req);
                if (StringUtil.isNullZeroString((String)resp.getValue("jwt"))) {
                    throw new PushServiceOperationException("\u30ec\u30b9\u30dd\u30f3\u30b9\u306bJWT\u304c\u542b\u307e\u308c\u3066\u3044\u307e\u305b\u3093\n\u30ec\u30b9\u30dd\u30f3\u30b9\u306e\u30a8\u30e9\u30fc\u30e1\u30c3\u30bb\u30fc\u30b8\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044", "error.failed.get.jwt");
                }
                model = new MblPushServerTokenModel();
                model.setPstToken(resp.getValue("jwt"));
                UDate limit = new UDate();
                limit.addHour(1);
                model.setPstLimit(limit);
                dao.saveToken(model);
                updCon.commit();
                this.gsJWTMap__.put(this.domain__, model);
                this.gsJWT__ = model;
            }
            catch (PushServiceOperationException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PushServiceException("\u5b9f\u884c\u6642\u4f8b\u5916", (Throwable)e);
            }
            return model;
        }
    }

    private String __getEncryptedToken(String token) {
        String ret = null;
        try {
            byte[] enpt = Blowfish.encrypt((String)LIC_TOKEN_PHRASE, (String)token);
            ret = new String(Base64.encodeBase64((byte[])enpt));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeJwt(Connection con) throws SQLException {
        Object object = JWT_LOCK;
        synchronized (object) {
            this.gsJWTMap__.remove(this.domain__);
            MblPushServerTokenDao dao = new MblPushServerTokenDao(con);
            dao.deleteAll();
            con.commit();
        }
    }

    public void sendMessage(Connection con, RequestModel reqMdl, List<PushRequestModel> pushMdlList, String pluginId) throws SQLException {
        CommonBiz cmnBiz = new CommonBiz();
        PluginConfig pluginConfig = cmnBiz.getPluginConfigForUser(con, reqMdl, 0);
        if (!cmnBiz.isCanUsePlugin("mobile", pluginConfig)) {
            return;
        }
        if (!cmnBiz.isCanUsePlugin("api", pluginConfig)) {
            return;
        }
        pushMdlList = this.getPushTarget(con, pushMdlList, pluginId);
        ArrayList<String> tokenList = new ArrayList<String>();
        IPushOperationBiz pushOpeBiz = PushOperationBiz.getInstance(con, reqMdl.getDomain());
        for (PushRequestModel pushReqMdl : pushMdlList) {
            List userTokenList = pushOpeBiz.getUserTokenList(con, pushReqMdl.getPushUser(), "jp.co.sjts.mobile.gsapp").stream().map(cptMdl -> cptMdl.getToken()).filter(tkn -> !tokenList.contains(tkn)).collect(Collectors.toList());
            pushReqMdl.setPushToken(userTokenList);
            tokenList.addAll(userTokenList);
        }
        if (tokenList.isEmpty()) {
            return;
        }
        MblPushTokenDao tokenDao = new MblPushTokenDao(con);
        List<MblPushTokenModel> mdlList = tokenDao.select(tokenList);
        MblPushUidDao mpuDao = new MblPushUidDao(con);
        List<String> cmuUidList = mdlList.stream().map(mdl -> mdl.getCmuUid()).collect(Collectors.toList());
        List<MblPushUidModel> mpuList = mpuDao.select(cmuUidList);
        Map<String, UDate> lastLoginMap = mpuList.stream().collect(Collectors.toMap(MblPushUidModel::getCmuUid, MblPushUidModel::getMpiLogindate, (mdl1, mdl2) -> mdl2));
        UDate checkLimitDate = new UDate();
        checkLimitDate.addDay(-90);
        mdlList = mdlList.stream().filter(mdl -> {
            UDate lastLoginDate = (UDate)lastLoginMap.get(mdl.getCmuUid());
            return lastLoginDate.compare(checkLimitDate, lastLoginDate) >= 0;
        }).collect(Collectors.toList());
        List useableMblUserList = cmnBiz.getCanUsePluginUser(con, "mobile", mdlList.stream().map(mdl -> mdl.getUsrSid()).distinct().collect(Collectors.toList()));
        mdlList = mdlList.stream().filter(mdl -> useableMblUserList.contains(mdl.getUsrSid())).collect(Collectors.toList());
        UserSearchDao usrmDao = new UserSearchDao(con);
        List useMblUserList = usrmDao.getUsersDataList((Collection)mdlList.stream().map(m -> m.getUsrSid()).collect(Collectors.toList())).stream().filter(m -> m.getUsiMblUse() == 0).map(m -> m.getUsrSid()).collect(Collectors.toList());
        mdlList = mdlList.stream().filter(mdl -> useMblUserList.contains(mdl.getUsrSid())).collect(Collectors.toList());
        List useableApiUserList = cmnBiz.getCanUsePluginUser(con, "api", mdlList.stream().map(mdl -> mdl.getUsrSid()).distinct().collect(Collectors.toList()));
        mdlList = mdlList.stream().filter(mdl -> useableApiUserList.contains(mdl.getUsrSid())).collect(Collectors.toList());
        log__.info((Object)"\u30d7\u30c3\u30b7\u30e5\u901a\u77e5\u5224\u5b9a\u7528\u306bWEBAPI\u30c8\u30fc\u30af\u30f3\u3092\u53d6\u5f97");
        ApiTokenDao atDao = new ApiTokenDao(con);
        List usrSid = mdlList.stream().map(mdl -> mdl.getUsrSid()).collect(Collectors.toList());
        List apiTokenList = atDao.select(usrSid);
        UDate now = new UDate();
        apiTokenList = apiTokenList.stream().filter(mdl -> mdl.getAptJkbn() == 0).filter(mdl -> mdl.getAptClient() == 2).filter(mdl -> now.compare(now, mdl.getAptLimitDate()) >= 0).collect(Collectors.toList());
        List apiUsrSidList = apiTokenList.stream().map(mdl -> mdl.getUsrSid()).collect(Collectors.toList());
        mdlList = mdlList.stream().filter(mdl -> apiUsrSidList.contains(mdl.getUsrSid())).collect(Collectors.toList());
        Set useableTokenList = mdlList.stream().map(m -> m.getMptPushToken()).collect(Collectors.toSet());
        for (PushRequestModel prMdl : pushMdlList) {
            prMdl.setPushToken(prMdl.getPushToken().stream().filter(token -> useableTokenList.contains(token)).collect(Collectors.toList()));
            if (prMdl.getPushToken().size() == 0) continue;
            this.doOperation(op -> {
                SendMessageRequest sendReq = new SendMessageRequest();
                sendReq.setDeviceDatas(prMdl.getPushToken().stream().map(token -> String.format("%s,%s", token, prMdl.getAppId())).collect(Collectors.toList()));
                sendReq.setTitle(prMdl.getPushTitle());
                sendReq.setMessage(prMdl.getPushMessage());
                sendReq.setData(prMdl.getPushParam());
                op.api((IPushApiRequest)sendReq);
            });
        }
    }

    private List<PushRequestModel> getPushTarget(Connection con, List<PushRequestModel> pushMdlList, String pluginId) throws SQLException {
        MblPushTargetIgnoreDao mptDao = new MblPushTargetIgnoreDao(con);
        List<Integer> noPushUser = mptDao.getUserWithoutPushList(pluginId);
        Map<Integer, List<Integer>> noPushAccount = mptDao.getNotPushAccountUserMap(pluginId);
        ArrayList<PushRequestModel> ret = new ArrayList<PushRequestModel>();
        for (PushRequestModel pushMdl : pushMdlList) {
            if (!this.__isPushTarget(con, pushMdl, noPushUser, noPushAccount)) continue;
            ret.add(pushMdl);
        }
        return ret;
    }

    private boolean __isPushTarget(Connection con, PushRequestModel pushMdl, List<Integer> noPushUser, Map<Integer, List<Integer>> noPushAccount) throws SQLException {
        if (pushMdl instanceof SchPushRequestModel || pushMdl instanceof ChtPushRequestModel) {
            return this.__isPushTarget(con, pushMdl, noPushUser);
        }
        if (pushMdl instanceof SmlPushRequestModel) {
            return this.__isSmlPushTarget(con, pushMdl, noPushUser, noPushAccount);
        }
        if (pushMdl instanceof WmlPushRequestModel) {
            return this.__isWmlPushTarget(con, pushMdl, noPushUser, noPushAccount);
        }
        return false;
    }

    private boolean __isPushTarget(Connection con, PushRequestModel pushMdl, List<Integer> noPushUser) throws SQLException {
        int userSid = pushMdl.getPushUser();
        return !noPushUser.contains(userSid);
    }

    private boolean __isSmlPushTarget(Connection con, PushRequestModel pushMdl, List<Integer> noPushUser, Map<Integer, List<Integer>> noPushAccount) throws SQLException {
        SmlPushRequestModel smlPushMdl = (SmlPushRequestModel)pushMdl;
        int userSid = pushMdl.getPushUser();
        if (noPushUser.contains(userSid)) {
            return false;
        }
        List<Integer> noPushAccountUser = noPushAccount.get(smlPushMdl.getAccountSid());
        if (noPushAccountUser == null || noPushAccountUser.isEmpty()) {
            return true;
        }
        return !noPushAccountUser.contains(userSid);
    }

    private boolean __isWmlPushTarget(Connection con, PushRequestModel pushMdl, List<Integer> noPushUser, Map<Integer, List<Integer>> noPushAccount) throws SQLException {
        WmlPushRequestModel wmlPushMdl = (WmlPushRequestModel)pushMdl;
        int userSid = pushMdl.getPushUser();
        if (noPushUser.contains(userSid)) {
            return false;
        }
        int accountSid = wmlPushMdl.getAccountSid();
        List<Integer> noPushAccountUser = noPushAccount.get(accountSid);
        if (noPushAccountUser == null || noPushAccountUser.isEmpty()) {
            return true;
        }
        return !noPushAccountUser.contains(userSid);
    }
}

