/*
 * Decompiled with CFR 0.152.
 */
package jp.groupsession.v3.mbh.push.biz;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import jp.groupsession.v2.rap.mbh.push.IPushServiceOperator;
import jp.groupsession.v2.rap.mbh.push.PushServiceOperator;
import jp.groupsession.v2.rap.mbh.push.api.DelMblTokenRequest;
import jp.groupsession.v2.rap.mbh.push.api.IPushApiRequest;
import jp.groupsession.v2.rap.mbh.push.biz.IPushOperationBiz;
import jp.groupsession.v2.rap.mbh.push.model.PushTokenModel;
import jp.groupsession.v3.mbh.dao.base.MblPushTokenDao;
import jp.groupsession.v3.mbh.model.base.MblPushTokenModel;

public class PushOperationBiz
implements IPushOperationBiz {
    private String domain__;

    private PushOperationBiz() {
    }

    public static IPushOperationBiz getInstance(Connection con, String domain) {
        PushOperationBiz ret = new PushOperationBiz();
        ret.domain__ = domain;
        return ret;
    }

    public List<PushTokenModel> getUserTokenList(Connection con, int usrSid, String uid) throws SQLException {
        MblPushTokenDao cptDao = new MblPushTokenDao(con);
        ArrayList<MblPushTokenModel> cptMdlList = cptDao.getToken(usrSid, "jp.co.sjts.mobile.gsapp");
        return this.__createTokenList(cptMdlList);
    }

    public void deleteToken(Connection con, List<String> tokenList) throws SQLException {
        if (tokenList == null || tokenList.isEmpty()) {
            return;
        }
        MblPushTokenDao cptDao = new MblPushTokenDao(con);
        List<MblPushTokenModel> tknMdlList = cptDao.select(tokenList);
        cptDao.delete(tokenList);
        ArrayList tknList = new ArrayList(tknMdlList.stream().map(cpt -> String.format("%s,%s", cpt.getMptPushToken(), cpt.getMptAppId())).collect(Collectors.toList()));
        IPushServiceOperator psOpe = PushServiceOperator.getInstance((Connection)con, (String)this.domain__);
        psOpe.doOperation(op -> {
            DelMblTokenRequest apiReq = new DelMblTokenRequest();
            apiReq.setDeviceDatas((List)tknList);
            op.api((IPushApiRequest)apiReq);
        });
    }

    private List<PushTokenModel> __createTokenList(ArrayList<MblPushTokenModel> cptMdlList) {
        ArrayList<PushTokenModel> tokenList = new ArrayList<PushTokenModel>();
        if (cptMdlList == null || cptMdlList.isEmpty()) {
            return tokenList;
        }
        for (MblPushTokenModel cptMdl : cptMdlList) {
            PushTokenModel tokenData = new PushTokenModel();
            tokenData.setToken(cptMdl.getMptPushToken());
            tokenData.setAppId(cptMdl.getMptAppId());
            tokenList.add(tokenData);
        }
        return tokenList;
    }
}

