/*
 * Decompiled with CFR 0.152.
 */
package jp.groupsession.v3.mbh.restapi;

import java.sql.Connection;
import java.sql.SQLException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.co.sjts.util.struts.RequestLocal;
import jp.groupsession.v2.cmn.GSConstApi;
import jp.groupsession.v2.cmn.dao.AuthDao;
import jp.groupsession.v2.cmn.dao.BaseUserModel;
import jp.groupsession.v2.cmn.login.biz.GSLoginBiz;
import jp.groupsession.v2.cmn.restapi.users.authentications.ISessionWriter;
import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.restapi.exception.IReasonCode;
import jp.groupsession.v2.restapi.exception.ReasonCode;
import jp.groupsession.v2.restapi.exception.RestApiPermissionException;
import jp.groupsession.v2.restapi.filter.IActionFilter;
import jp.groupsession.v2.restapi.filter.RestApiActionFilterChain;
import jp.groupsession.v2.restapi.filter.annotation.ActionFilter;
import jp.groupsession.v2.struts.msg.GsMessage;
import jp.groupsession.v3.mbh.biz.MbhAccessCheckBiz;
import jp.groupsession.v3.mbh.model.UserAgent;
import jp.groupsession.v3.mbh.uuid.MbhUUIDBiz;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ActionFilter(path="/restapi/common/users/*/authentications")
public class UserAgentFilter
implements IActionFilter {
    private static Log log__ = LogFactory.getLog(UserAgentFilter.class);

    public void doFilter(HttpServletRequest req, HttpServletResponse res, RestApiContext ctx, RestApiActionFilterChain chain) {
        Connection con = ctx.getCon();
        GsMessage gsMsg = new GsMessage(req);
        UserAgent agent = UserAgent.getInstance(req);
        boolean isMobile = false;
        if (agent.getClient() == 2) {
            log__.info((Object)"\u30e2\u30d0\u30a4\u30eb\u5229\u7528\u30c1\u30a7\u30c3\u30af\u3092\u5b9f\u884c");
            AuthDao adao = new AuthDao(ctx.getCon());
            BaseUserModel smodel = null;
            try {
                smodel = adao.selectLoginNoPwd(ctx.getMap().getProperty("userId"), null);
                if (smodel == null) {
                    throw new RestApiPermissionException((IReasonCode)ReasonCode.EnumError.IMPERMISSIBLE, "search.data.notfound", new Object[]{new GsMessage(ctx.getRequestModel()).getMessage("cmn.user")});
                }
                MbhAccessCheckBiz mbhCheckBiz = new MbhAccessCheckBiz(con, agent, smodel, ctx.getPluginConfig(), gsMsg);
                mbhCheckBiz.check();
                MbhUUIDBiz uidBiz = MbhUUIDBiz.getInstance();
                if (!uidBiz.checkUid(smodel, agent, con, true)) {
                    throw uidBiz.createRestApiUUIDException(gsMsg);
                }
            }
            catch (SQLException e) {
                throw new RuntimeException("SQL\u5b9f\u884c\u30a8\u30e9\u30fc", e);
            }
            isMobile = true;
        }
        chain.doFilter(req, res, ctx);
        if (!isMobile) {
            return;
        }
        RequestLocal.put((Object)GSConstApi.LOCALKEY_LOGINSESSION_WRITER, (Object)new SessionWriter());
    }

    private static class SessionWriter
    implements ISessionWriter {
        private SessionWriter() {
        }

        public void doLogin(HttpServletRequest req, RestApiContext ctx) {
            GSLoginBiz cmnLoginBiz = new GSLoginBiz();
            try {
                cmnLoginBiz.doLoginMbl(req, ctx.getRequestUserModel(), ctx.getCon(), ctx.getPluginConfig());
                ctx.getCon().commit();
            }
            catch (Exception e) {
                throw new RuntimeException("\u30ed\u30b0\u30a4\u30f3\u30bb\u30c3\u30b7\u30e7\u30f3\u751f\u6210\u5931\u6557", e);
            }
        }
    }
}

