/*
 * Decompiled with CFR 0.152.
 */
package jp.groupsession.v3.mbh.restapi.configs.notification;

import java.sql.SQLException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.co.sjts.util.NullDefault;
import jp.co.sjts.util.StringUtil;
import jp.groupsession.v2.restapi.controller.AbstractRestApiAction;
import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.restapi.controller.annotation.Get;
import jp.groupsession.v2.restapi.controller.annotation.Put;
import jp.groupsession.v2.restapi.exception.EnumError;
import jp.groupsession.v2.restapi.exception.IReasonCode;
import jp.groupsession.v2.restapi.exception.RestApiPermissionException;
import jp.groupsession.v2.restapi.exception.RestApiValidateException;
import jp.groupsession.v2.restapi.filter.annotation.AddFilter;
import jp.groupsession.v2.restapi.response.RestApiResponseWriter;
import jp.groupsession.v2.struts.msg.GsMessage;
import jp.groupsession.v3.mbh.model.UserAgent;
import jp.groupsession.v3.mbh.restapi.MbhAcsessFilter;
import jp.groupsession.v3.mbh.restapi.MblEnumReasonCode;
import jp.groupsession.v3.mbh.restapi.configs.notification.MbhConfigsNotificationBiz;
import jp.groupsession.v3.mbh.restapi.configs.notification.MbhConfigsNotificationParamModel;
import jp.groupsession.v3.mbh.restapi.configs.notification.MbhPushFilter;

public class MbhConfigsNotificationAction
extends AbstractRestApiAction {
    @Get
    @AddFilter.Holder(value={@AddFilter(value=MbhAcsessFilter.class), @AddFilter(value=MbhPushFilter.class)})
    public void doGet(HttpServletRequest req, HttpServletResponse res, RestApiContext ctx) throws SQLException {
        MbhConfigsNotificationBiz biz = new MbhConfigsNotificationBiz(ctx);
        RestApiResponseWriter.builder((HttpServletResponse)res, (RestApiContext)ctx).addResultList(biz.get(UserAgent.getInstance(req))).build().execute();
    }

    @Put
    @AddFilter.Holder(value={@AddFilter(value=MbhAcsessFilter.class), @AddFilter(value=MbhPushFilter.class)})
    public void doPut(HttpServletRequest req, HttpServletResponse res, MbhConfigsNotificationParamModel paramMdl, RestApiContext ctx) throws SQLException {
        MbhConfigsNotificationBiz biz = new MbhConfigsNotificationBiz(ctx);
        String pluginId = NullDefault.getString((String)paramMdl.getPluginId(), (String)"");
        List<String> pluginIdList = biz.getPluginIdListForNotification();
        if (!pluginIdList.contains(pluginId)) {
            throw new RestApiPermissionException((IReasonCode)MblEnumReasonCode.RESOURCE_CANT_ACCESS_PLUGIN, "error.can.not.use", new Object[]{new GsMessage(ctx.getRequestModel()).getMessage("cmn.plugin")});
        }
        if (!biz._checkPlugin(pluginId)) {
            throw new RestApiPermissionException((IReasonCode)MblEnumReasonCode.RESOURCE_CANT_PUSH_PLUGIN, "error.cant.use.push.plugin", new Object[0]);
        }
        String accountId = paramMdl.getAccountId();
        if (!StringUtil.isNullZeroString((String)accountId) && !biz._checkAccount(pluginId, accountId)) {
            throw new RestApiPermissionException((IReasonCode)MblEnumReasonCode.RESOURCE_CANT_ACCESS_ACCOUNT, "error.input.notvalidate.data", new Object[]{this.__getErrorTarget(ctx, pluginId)});
        }
        int notificationFlg = paramMdl.getNotificationFlg();
        if (notificationFlg != 0 && notificationFlg != 1) {
            throw new RestApiValidateException((IReasonCode)EnumError.PARAM_OTHER_INVALID, "error.input.notvalidate.data", new Object[]{new GsMessage(ctx.getRequestModel()).getMessage("restapi.mobile.notificationflg")});
        }
        Object model = biz.put(paramMdl, UserAgent.getInstance(req));
        ctx.getCon().commit();
        RestApiResponseWriter.builder((HttpServletResponse)res, (RestApiContext)ctx).addResult(model).build().execute();
    }

    private String __getErrorTarget(RestApiContext ctx, String pluginId) {
        String ret = "";
        GsMessage gsMsg = new GsMessage(ctx.getRequestModel());
        switch (pluginId) {
            case "smail": {
                ret = gsMsg.getMessage("cmn.account.sid");
                break;
            }
            case "webmail": {
                ret = gsMsg.getMessage("wml.281");
                break;
            }
            default: {
                ret = gsMsg.getMessage("cmn.account.sid");
            }
        }
        return ret;
    }
}

