/*
 * Decompiled with CFR 0.152.
 */
package jp.groupsession.v3.mbh.restapi.configs.notification;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import jp.co.sjts.util.StringUtil;
import jp.groupsession.v2.cmn.config.PluginConfig;
import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.sml.dao.SmlAccountDao;
import jp.groupsession.v2.sml.model.SmlAccountModel;
import jp.groupsession.v2.wml.dao.base.WmlAccountDao;
import jp.groupsession.v2.wml.model.base.WmlAccountModel;
import jp.groupsession.v3.mbh.dao.base.MblPushTargetIgnoreDao;
import jp.groupsession.v3.mbh.model.UserAgent;
import jp.groupsession.v3.mbh.model.base.MblPushTargetIgnoreModel;
import jp.groupsession.v3.mbh.restapi.configs.notification.MbhConfigsNotificationModel;
import jp.groupsession.v3.mbh.restapi.configs.notification.MbhConfigsNotificationParamModel;
import jp.groupsession.v3.mbh.restapi.configs.notification.MbhConfigsNotificationSubModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MbhConfigsNotificationBiz {
    private static Log log__ = LogFactory.getLog(MbhConfigsNotificationBiz.class);
    private static String[] NOTIFICATION_PLUGINS__ = new String[]{"smail", "schedule", "webmail", "chat"};
    private final RestApiContext ctx__;

    public MbhConfigsNotificationBiz(RestApiContext ctx) {
        this.ctx__ = ctx;
    }

    public List<Object> get(UserAgent agent) throws SQLException {
        ArrayList<Object> ret = new ArrayList<Object>();
        log__.debug((Object)"\u901a\u77e5\u8a2d\u5b9a \u691c\u7d22\u958b\u59cb");
        MblPushTargetIgnoreDao ignoreDao = new MblPushTargetIgnoreDao(this.ctx__.getCon());
        Map<String, List<MblPushTargetIgnoreModel>> ignoreMap = ignoreDao.getIgnoreMap(this.ctx__.getRequestUserSid(), agent.getAppId());
        PluginConfig pconfig = this.ctx__.getPluginConfig();
        List<String> pluginIdList = this.getPluginIdListForNotification();
        for (String pluginId : pluginIdList) {
            if (!Arrays.asList(NOTIFICATION_PLUGINS__).contains(pluginId)) continue;
            MbhConfigsNotificationModel model = new MbhConfigsNotificationModel();
            model.setPluginId(pluginId);
            model.setPluginNameText(pconfig.getPlugin(pluginId).getName(this.ctx__.getRequestModel()));
            Set<String> ignoreSet = this.creqteIgnoreSet(ignoreMap.get(pluginId));
            if (ignoreSet.contains("all")) {
                model.setPluginNotificationFlg(0);
            } else {
                model.setPluginNotificationFlg(1);
            }
            this.__setAccountArray(model, pluginId, ignoreSet);
            if (model.getPluginNotificationArray() == null || model.getPluginNotificationArray().isEmpty()) {
                ret.add(model.createNotSubModel());
                continue;
            }
            ret.add(model);
        }
        log__.debug((Object)"\u901a\u77e5\u8a2d\u5b9a \u691c\u7d22\u7d42\u4e86");
        return ret;
    }

    public Object put(MbhConfigsNotificationParamModel paramMdl, UserAgent agent) throws SQLException {
        log__.debug((Object)"\u901a\u77e5\u8a2d\u5b9a \u767b\u9332\u958b\u59cb");
        MblPushTargetIgnoreModel targetMdl = new MblPushTargetIgnoreModel();
        targetMdl.setUsrSid(this.ctx__.getRequestUserSid());
        targetMdl.setAppId(agent.getAppId());
        String pluginId = paramMdl.getPluginId();
        targetMdl.setPluginId(pluginId);
        String accountId = paramMdl.getAccountId();
        Connection con = this.ctx__.getCon();
        if (!StringUtil.isNullZeroString((String)accountId)) {
            if (pluginId.equals("smail")) {
                targetMdl.setPucSubkbn("accountSid");
                targetMdl.setPucSubtargetSid(Integer.parseInt(accountId));
            } else if (pluginId.equals("webmail")) {
                targetMdl.setPucSubkbn("accountSid");
                WmlAccountDao accountDao = new WmlAccountDao(con);
                targetMdl.setPucSubtargetSid(accountDao.getAccountSid(accountId));
            } else {
                targetMdl.setPucSubkbn("all");
                targetMdl.setPucSubtargetSid(-1);
            }
        } else {
            targetMdl.setPucSubkbn("all");
            targetMdl.setPucSubtargetSid(-1);
        }
        MblPushTargetIgnoreDao ignoreDao = new MblPushTargetIgnoreDao(con);
        ignoreDao.delete(targetMdl.getUsrSid(), targetMdl.getAppId(), targetMdl.getPluginId(), targetMdl.getPucSubkbn(), targetMdl.getPucSubtargetSid());
        if (paramMdl.getNotificationFlg() == 0) {
            ignoreDao.insert(targetMdl);
        }
        MbhConfigsNotificationModel model = new MbhConfigsNotificationModel();
        model.setPluginId(pluginId);
        model.setPluginNameText(this.ctx__.getPluginConfig().getPlugin(pluginId).getName(this.ctx__.getRequestModel()));
        if (!StringUtil.isNullZeroString((String)accountId)) {
            MblPushTargetIgnoreModel pluginIgnoreMdl = ignoreDao.select(targetMdl.getUsrSid(), targetMdl.getAppId(), targetMdl.getPluginId(), "all", -1);
            if (pluginIgnoreMdl != null) {
                model.setPluginNotificationFlg(0);
            } else {
                model.setPluginNotificationFlg(1);
            }
        } else {
            model.setPluginNotificationFlg(paramMdl.getNotificationFlg());
        }
        Map<String, List<MblPushTargetIgnoreModel>> ignoreMap = ignoreDao.getIgnoreMap(this.ctx__.getRequestUserSid(), agent.getAppId());
        Set<String> ignoreSet = this.creqteIgnoreSet(ignoreMap.get(pluginId));
        if (ignoreSet.contains("all")) {
            model.setPluginNotificationFlg(0);
        } else {
            model.setPluginNotificationFlg(1);
        }
        this.__setAccountArray(model, pluginId, ignoreSet);
        if (model.getPluginNotificationArray() == null || model.getPluginNotificationArray().isEmpty()) {
            return model.createNotSubModel();
        }
        log__.debug((Object)"\u901a\u77e5\u8a2d\u5b9a \u767b\u9332\u7d42\u4e86");
        return model;
    }

    private List<SmlAccountModel> __getSmlAccountList() throws SQLException {
        SmlAccountDao accountDao = new SmlAccountDao(this.ctx__.getCon());
        return accountDao.getAccountList(this.ctx__.getRequestUserSid());
    }

    private List<WmlAccountModel> __getWmlAccountList() throws SQLException {
        WmlAccountDao accountDao = new WmlAccountDao(this.ctx__.getCon());
        return accountDao.getAccountList(this.ctx__.getRequestUserSid());
    }

    private void __setAccountArray(MbhConfigsNotificationModel model, String pluginId, Set<String> ignoreSet) throws SQLException {
        MbhConfigsNotificationSubModel subMdl;
        List<SmlAccountModel> accountList;
        ArrayList<MbhConfigsNotificationSubModel> pluginNotificationArray = new ArrayList<MbhConfigsNotificationSubModel>();
        if (pluginId.equals("smail")) {
            accountList = this.__getSmlAccountList();
            for (SmlAccountModel accountMdl : accountList) {
                subMdl = new MbhConfigsNotificationSubModel();
                subMdl.setAccountId(String.valueOf(accountMdl.getSacSid()));
                subMdl.setAccountName(accountMdl.getSacName());
                if (ignoreSet.contains("accountSid:" + accountMdl.getSacSid())) {
                    subMdl.setNotificationFlg(0);
                } else {
                    subMdl.setNotificationFlg(1);
                }
                pluginNotificationArray.add(subMdl);
            }
            model.setPluginNotificationArray(pluginNotificationArray);
        }
        if (pluginId.equals("webmail")) {
            accountList = this.__getWmlAccountList();
            for (SmlAccountModel accountMdl : accountList) {
                subMdl = new MbhConfigsNotificationSubModel();
                subMdl.setAccountId(String.valueOf(accountMdl.getWacAccountId()));
                subMdl.setAccountName(accountMdl.getWacName());
                if (ignoreSet.contains("accountSid:" + accountMdl.getWacSid())) {
                    subMdl.setNotificationFlg(0);
                } else {
                    subMdl.setNotificationFlg(1);
                }
                pluginNotificationArray.add(subMdl);
            }
            model.setPluginNotificationArray(pluginNotificationArray);
        }
    }

    public Set<String> creqteIgnoreSet(List<MblPushTargetIgnoreModel> ignoreList) {
        if (ignoreList == null || ignoreList.isEmpty()) {
            return new HashSet<String>();
        }
        Set<String> ignoreSet = ignoreList.stream().map(mdl -> mdl.getPucSubkbn().equals("all") ? mdl.getPucSubkbn() : mdl.getPucSubkbn() + ":" + mdl.getPucSubtargetSid()).collect(Collectors.toSet());
        return ignoreSet;
    }

    public List<String> getPluginIdListForNotification() {
        PluginConfig pconfig = this.ctx__.getPluginConfig();
        ArrayList userPluginIdList = pconfig.getUserPluginIdList();
        return pconfig.getPluginIdList().stream().filter(id -> !userPluginIdList.contains(id)).collect(Collectors.toList());
    }

    protected boolean _checkPlugin(String pluginId) {
        return Arrays.asList(NOTIFICATION_PLUGINS__).contains(pluginId);
    }

    protected boolean _checkAccount(String pluginId, String accountId) throws SQLException {
        if (!pluginId.equals("smail") && !pluginId.equals("webmail")) {
            return false;
        }
        if (pluginId.equals("smail")) {
            Set accountSidSet = this.__getSmlAccountList().stream().map(mdl -> String.valueOf(mdl.getSacSid())).collect(Collectors.toSet());
            return accountSidSet.contains(accountId);
        }
        if (pluginId.equals("webmail")) {
            Set accountIdSet = this.__getWmlAccountList().stream().map(mdl -> mdl.getWacAccountId()).collect(Collectors.toSet());
            return accountIdSet.contains(accountId);
        }
        return false;
    }
}

