/*
 * Decompiled with CFR 0.152.
 */
package jp.groupsession.v3.mbh.restapi.devicetoken;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import jp.co.sjts.util.StringUtil;
import jp.co.sjts.util.date.UDate;
import jp.groupsession.v2.rap.mbh.push.IPushServiceOperator;
import jp.groupsession.v2.rap.mbh.push.PushServiceOperator;
import jp.groupsession.v2.rap.mbh.push.api.IPushApiRequest;
import jp.groupsession.v2.rap.mbh.push.api.PostMblTokenRequest;
import jp.groupsession.v2.rap.mbh.push.biz.IPushOperationBiz;
import jp.groupsession.v2.rap.mbh.push.biz.PushOperationBiz;
import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v3.mbh.dao.base.MblPushTokenDao;
import jp.groupsession.v3.mbh.dao.base.MblPushUidDao;
import jp.groupsession.v3.mbh.model.UserAgent;
import jp.groupsession.v3.mbh.model.base.MblPushTokenModel;
import jp.groupsession.v3.mbh.model.base.MblPushUidModel;
import jp.groupsession.v3.mbh.restapi.devicetoken.MbhDevicetokenModel;
import jp.groupsession.v3.mbh.restapi.devicetoken.MbhDevicetokenParamModel;

public class MbhDevicetokenBiz {
    private final RestApiContext ctx__;

    public MbhDevicetokenBiz(RestApiContext ctx) {
        this.ctx__ = ctx;
    }

    public MbhDevicetokenModel post(MbhDevicetokenParamModel paramMdl, UserAgent agent) throws SQLException {
        MblPushTokenModel cptMdl;
        IPushServiceOperator psOpe = PushServiceOperator.getInstance((Connection)this.ctx__.getCon(), (String)this.ctx__.getRequestModel().getDomain());
        MbhDevicetokenModel ret = new MbhDevicetokenModel();
        ret.setAppId(agent.getAppId());
        ret.setTokenText(paramMdl.getTokenText());
        if (!StringUtil.isNullZeroString((String)paramMdl.getExeKey())) {
            psOpe.doOperation(op -> {
                PostMblTokenRequest pmtReq = new PostMblTokenRequest();
                pmtReq.setDeviceData(String.format("%s,%s", paramMdl.getTokenText(), agent.getAppId()));
                pmtReq.setExeKey(paramMdl.getExeKey());
                op.api((IPushApiRequest)pmtReq);
            });
        }
        MblPushUidDao uidDao = new MblPushUidDao(this.ctx__.getCon());
        MblPushUidModel uidMdl = new MblPushUidModel();
        uidMdl.setUsrSid(this.ctx__.getRequestUserSid());
        uidMdl.setCmuUid(agent.getCuid());
        uidMdl.setMpiLogindate(new UDate());
        if (uidDao.update(uidMdl) == 0) {
            uidDao.insert(uidMdl);
        }
        if ((cptMdl = this.updateIfExists(paramMdl.getTokenText())) != null) {
            return ret;
        }
        MblPushTokenDao cptDao = new MblPushTokenDao(this.ctx__.getCon());
        cptMdl = new MblPushTokenModel();
        cptMdl.setMptPushToken(paramMdl.getTokenText());
        cptMdl.setUsrSid(this.ctx__.getRequestUserSid());
        cptMdl.setCmuUid(agent.getCuid());
        cptMdl.setMptAppId(agent.getAppId());
        cptDao.insert(cptMdl);
        this.ctx__.getCon().commit();
        return ret;
    }

    public MblPushTokenModel updateIfExists(String token) throws SQLException {
        MblPushTokenDao cptDao = new MblPushTokenDao(this.ctx__.getCon());
        MblPushTokenModel cptMdl = cptDao.select(token);
        if (cptMdl != null && cptMdl.getUsrSid() != this.ctx__.getRequestUserSid()) {
            cptMdl.setUsrSid(this.ctx__.getRequestUserSid());
            cptDao.update(cptMdl);
        }
        return cptMdl;
    }

    public void delete(UserAgent agent) throws SQLException {
        MblPushTokenDao cptDao = new MblPushTokenDao(this.ctx__.getCon());
        List cptList = cptDao.getToken(this.ctx__.getRequestUserSid()).stream().filter(cpt -> Objects.equals(cpt.getCmuUid(), agent.getCuid())).collect(Collectors.toList());
        IPushOperationBiz pushOpeBiz = PushOperationBiz.getInstance((Connection)this.ctx__.getCon(), (String)this.ctx__.getRequestModel().getDomain());
        pushOpeBiz.deleteToken(this.ctx__.getCon(), cptList.stream().map(mdl -> mdl.getMptPushToken()).collect(Collectors.toList()));
    }
}

