/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore.db;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.index.BaseIndex;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.message.DbException;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.db.MVTable;
import org.h2.mvstore.db.ValueArrayDataType;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.util.New;
import org.h2.value.Value;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;

public class MVSecondaryIndex
extends BaseIndex {
    final MVTable mvTable;
    private final int keyColumns;
    private MVMap<Value[], Long> map2;

    public MVSecondaryIndex(Database database, MVTable mVTable, int n, String string, IndexColumn[] indexColumnArray, IndexType indexType) {
        this.mvTable = mVTable;
        this.initBaseIndex(mVTable, n, string, indexColumnArray, indexType);
        if (!this.database.isStarting()) {
            MVSecondaryIndex.checkIndexColumnTypes(indexColumnArray);
        }
        this.keyColumns = indexColumnArray.length + 1;
        int[] nArray = new int[this.keyColumns];
        for (int i = 0; i < indexColumnArray.length; ++i) {
            nArray[i] = indexColumnArray[i].sortType;
        }
        nArray[this.keyColumns - 1] = 0;
        String string2 = this.getName() + "_" + this.getId();
        ValueArrayDataType valueArrayDataType = new ValueArrayDataType(database.getCompareMode(), database, nArray);
        this.map2 = mVTable.getStore().openMap(string2, new MVMap.Builder().keyType(valueArrayDataType));
    }

    private static void checkIndexColumnTypes(IndexColumn[] indexColumnArray) {
        for (IndexColumn indexColumn : indexColumnArray) {
            int n = indexColumn.column.getType();
            if (n != 16 && n != 15) continue;
            throw DbException.get(50100, "Index on BLOB or CLOB column: " + indexColumn.column.getCreateSQL());
        }
    }

    @Override
    public void close(Session session) {
    }

    @Override
    public void rename(String string) {
        MVMap<Value[], Long> mVMap = this.getMap(null);
        mVMap.renameMap(string + "_" + this.getId());
        super.rename(string);
    }

    @Override
    public void add(Session session, Row row) {
        MVMap<Value[], Long> mVMap = this.getMap(session);
        Value[] valueArray = this.getKey(row);
        if (this.indexType.isUnique()) {
            SearchRow searchRow;
            valueArray[this.keyColumns - 1] = ValueLong.get(0L);
            Value[] valueArray2 = mVMap.ceilingKey(valueArray);
            if (valueArray2 != null && this.compareRows(row, searchRow = this.getRow(valueArray2)) == 0 && !this.containsNullAndAllowMultipleNull(searchRow)) {
                throw this.getDuplicateKeyException();
            }
        }
        valueArray[this.keyColumns - 1] = ValueLong.get(row.getKey());
        mVMap.put(valueArray, 0L);
    }

    @Override
    public void remove(Session session, Row row) {
        Value[] valueArray = this.getKey(row);
        MVMap<Value[], Long> mVMap = this.getMap(session);
        Long l = mVMap.remove(valueArray);
        if (l == null && l == null) {
            throw DbException.get(90112, this.getSQL() + ": " + row.getKey());
        }
    }

    @Override
    public Cursor find(Session session, SearchRow searchRow, SearchRow searchRow2) {
        Value[] valueArray = this.getKey(searchRow);
        MVMap<Value[], Long> mVMap = this.getMap(session);
        return new MVStoreCursor(session, mVMap.keyIterator(valueArray), searchRow2);
    }

    private Value[] getKey(SearchRow searchRow) {
        if (searchRow == null) {
            return null;
        }
        Value[] valueArray = new Value[this.keyColumns];
        for (int i = 0; i < this.columns.length; ++i) {
            Column column = this.columns[i];
            int n = column.getColumnId();
            if (searchRow == null) continue;
            valueArray[i] = searchRow.getValue(n);
        }
        valueArray[this.keyColumns - 1] = ValueLong.get(searchRow.getKey());
        return valueArray;
    }

    SearchRow getRow(Value[] valueArray) {
        Row row = this.mvTable.getTemplateRow();
        row.setKey(valueArray[valueArray.length - 1].getLong());
        Column[] columnArray = this.getColumns();
        for (int i = 0; i < valueArray.length - 1; ++i) {
            Column column = columnArray[i];
            int n = column.getColumnId();
            Value value = valueArray[i];
            row.setValue(n, value);
        }
        return row;
    }

    @Override
    public MVTable getTable() {
        return this.mvTable;
    }

    @Override
    public double getCost(Session session, int[] nArray) {
        MVMap<Value[], Long> mVMap = this.getMap(session);
        return 10L * this.getCostRangeIndex(nArray, mVMap.getSize());
    }

    @Override
    public void remove(Session session) {
        MVMap<Value[], Long> mVMap = this.getMap(session);
        if (!mVMap.isClosed()) {
            mVMap.removeMap();
        }
    }

    @Override
    public void truncate(Session session) {
        MVMap<Value[], Long> mVMap = this.getMap(session);
        mVMap.clear();
    }

    @Override
    public boolean canGetFirstOrLast() {
        return true;
    }

    @Override
    public Cursor findFirstOrLast(Session session, boolean bl) {
        Value[] valueArray;
        MVMap<Value[], Long> mVMap = this.getMap(session);
        Value[] valueArray2 = valueArray = bl ? mVMap.firstKey() : mVMap.lastKey();
        while (true) {
            if (valueArray == null) {
                return new MVStoreCursor(session, Collections.emptyList().iterator(), null);
            }
            if (valueArray[0] != ValueNull.INSTANCE) break;
            valueArray = bl ? mVMap.higherKey(valueArray) : mVMap.lowerKey(valueArray);
        }
        ArrayList arrayList = New.arrayList();
        arrayList.add(valueArray);
        MVStoreCursor mVStoreCursor = new MVStoreCursor(session, arrayList.iterator(), null);
        mVStoreCursor.next();
        return mVStoreCursor;
    }

    @Override
    public boolean needRebuild() {
        MVMap<Value[], Long> mVMap = this.getMap(null);
        return mVMap.getSize() == 0L;
    }

    @Override
    public long getRowCount(Session session) {
        MVMap<Value[], Long> mVMap = this.getMap(session);
        return mVMap.getSize();
    }

    @Override
    public long getRowCountApproximation() {
        MVMap<Value[], Long> mVMap = this.getMap(null);
        return mVMap.getSize();
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }

    @Override
    public void checkRename() {
    }

    MVMap<Value[], Long> getMap(Session session) {
        return this.map2;
    }

    class MVStoreCursor
    implements Cursor {
        private final Session session;
        private final Iterator<Value[]> it;
        private final SearchRow last;
        private Value[] current;
        private SearchRow searchRow;
        private Row row;

        public MVStoreCursor(Session session, Iterator<Value[]> iterator, SearchRow searchRow) {
            this.session = session;
            this.it = iterator;
            this.last = searchRow;
        }

        @Override
        public Row get() {
            SearchRow searchRow;
            if (this.row == null && (searchRow = this.getSearchRow()) != null) {
                this.row = MVSecondaryIndex.this.mvTable.getRow(this.session, searchRow.getKey());
            }
            return this.row;
        }

        @Override
        public SearchRow getSearchRow() {
            if (this.searchRow == null && this.current != null) {
                this.searchRow = MVSecondaryIndex.this.getRow(this.current);
            }
            return this.searchRow;
        }

        @Override
        public boolean next() {
            this.current = this.it.next();
            this.searchRow = null;
            if (this.current != null && this.last != null && MVSecondaryIndex.this.compareRows(this.getSearchRow(), this.last) > 0) {
                this.searchRow = null;
                this.current = null;
            }
            this.row = null;
            return this.current != null;
        }

        @Override
        public boolean previous() {
            return false;
        }
    }
}

