/*
 * Decompiled with CFR 0.152.
 */
package jp.groupsession.v2.lic;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import jp.co.sjts.util.NullDefault;
import jp.co.sjts.util.StringUtil;
import jp.co.sjts.util.ValidateUtil;
import jp.co.sjts.util.date.UDate;
import jp.co.sjts.util.encryption.Blowfish;
import jp.co.sjts.util.encryption.EncryptionException;
import jp.co.sjts.util.io.IOTools;
import jp.co.sjts.util.io.IOToolsException;
import jp.co.sjts.util.struts.StrutsUtil;
import jp.groupsession.v2.cmn.GroupSession;
import jp.groupsession.v2.cmn.biz.CommonBiz;
import jp.groupsession.v2.cmn.dao.base.CmnContmDao;
import jp.groupsession.v2.cmn.dao.base.CmnUsrmDao;
import jp.groupsession.v2.cmn.model.RequestModel;
import jp.groupsession.v2.lic.LicenseModel;
import jp.groupsession.v2.rap.mbh.push.PushServiceOperator;
import jp.groupsession.v2.struts.msg.GsMessage;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMessage;

public class LicenseOperation {
    private static Log log__ = LogFactory.getLog(LicenseOperation.class);

    public static String getDecryString(String target) throws EncryptionException {
        String decStr = null;
        if (target != null) {
            try {
                byte[] decBytes = Base64.decodeBase64((byte[])target.getBytes("UTF-8"));
                decStr = Blowfish.decrypt((String)"D41D8CD98F00B204", (byte[])decBytes);
            }
            catch (Exception e) {
                log__.error((Object)"\u5fa9\u53f7\u5316\u306b\u5931\u6557", (Throwable)e);
                throw new EncryptionException("\u5fa9\u53f7\u5316\u306b\u5931\u6557", (Throwable)e);
            }
        }
        return decStr;
    }

    public boolean isLicenseUserCount(int pluginKbn, Connection con, String domain) throws SQLException {
        if (this.isValiableTime(pluginKbn)) {
            return true;
        }
        LicenseModel lmdl = (LicenseModel)((Object)GroupSession.getResourceManager().getLicenseMdl(domain));
        if (lmdl == null) {
            log__.warn((Object)"\u30e9\u30a4\u30bb\u30f3\u30b9\u30d5\u30a1\u30a4\u30eb\u304c\u53d6\u308a\u8fbc\u307e\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
            return false;
        }
        int licCount = Integer.parseInt(NullDefault.getStringZeroLength((String)lmdl.getLicenseNumber(), (String)"0"));
        CmnUsrmDao dao = new CmnUsrmDao(con);
        int dbCount = dao.getActiveUserCount();
        log__.info((Object)("\u30e6\u30fc\u30b6\u767b\u9332\u4eba\u6570/\u5951\u7d04\u4eba\u6570=" + dbCount + "/" + licCount));
        if (licCount < dbCount) {
            log__.warn((Object)"\u30e9\u30a4\u30bb\u30f3\u30b9\u30d5\u30a1\u30a4\u30eb [\u4eba\u6570]\u304c\u4e0d\u6b63\u3067\u3059\u3002");
            return false;
        }
        return true;
    }

    public boolean isLicenseOk(int pluginKbn, Connection con, String domain) throws SQLException, EncryptionException {
        CmnContmDao dao;
        String dgsUid;
        boolean ret = false;
        if (this.isValiableTime(pluginKbn)) {
            return true;
        }
        LicenseModel lmdl = (LicenseModel)((Object)GroupSession.getResourceManager().getLicenseMdl(domain));
        if (lmdl == null) {
            log__.warn((Object)"\u30e9\u30a4\u30bb\u30f3\u30b9\u30d5\u30a1\u30a4\u30eb\u304c\u53d6\u308a\u8fbc\u307e\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
            return ret;
        }
        String lgsUid = lmdl.getGsUid();
        if (!lgsUid.equals(dgsUid = LicenseOperation.getDecryString((dao = new CmnContmDao(con)).getGsUid()))) {
            log__.error((Object)(lgsUid + "==========" + dgsUid));
            log__.fatal((Object)"\u30b7\u30ea\u30a2\u30eb\u756a\u53f7\u4e0d\u4e00\u81f4");
            return false;
        }
        String strLimit = "";
        switch (pluginKbn) {
            case 1: {
                strLimit = lmdl.getLicenseLimitMobile();
                break;
            }
            case 2: {
                strLimit = lmdl.getLicenseLimitCrossRide();
                break;
            }
        }
        if (StringUtil.isNullZeroStringSpace((String)strLimit)) {
            log__.warn((Object)"\u30e9\u30a4\u30bb\u30f3\u30b9\u30d5\u30a1\u30a4\u30eb [\u671f\u9650] \u306e\u5024\u304c\u4e0d\u6b63\u3067\u3059\u3002");
            return ret;
        }
        String[] splitLimitStr = strLimit.split("/");
        if (splitLimitStr == null || splitLimitStr.length != 3) {
            log__.warn((Object)"\u30e9\u30a4\u30bb\u30f3\u30b9\u30d5\u30a1\u30a4\u30eb [\u671f\u9650] \u306e\u5024\u304c\u4e0d\u6b63\u3067\u3059\u3002");
            return ret;
        }
        if (!(ValidateUtil.isNumber((String)splitLimitStr[0]) && ValidateUtil.isNumber((String)splitLimitStr[1]) && ValidateUtil.isNumber((String)splitLimitStr[2]))) {
            log__.warn((Object)"\u30e9\u30a4\u30bb\u30f3\u30b9\u30d5\u30a1\u30a4\u30eb [\u671f\u9650] \u306e\u5024\u304c\u4e0d\u6b63\u3067\u3059\u3002");
            return ret;
        }
        int intYear = Integer.parseInt(splitLimitStr[0]);
        int intMonth = Integer.parseInt(splitLimitStr[1]);
        int intDay = Integer.parseInt(splitLimitStr[2]);
        UDate checkDate = new UDate();
        checkDate.setDate(intYear, intMonth, intDay);
        if (checkDate.getYear() != intYear || checkDate.getMonth() != intMonth || checkDate.getIntDay() != intDay) {
            log__.warn((Object)"\u30e9\u30a4\u30bb\u30f3\u30b9\u30d5\u30a1\u30a4\u30eb [\u671f\u9650] \u306e\u5024\u304c\u4e0d\u6b63\u3067\u3059\u3002");
            return ret;
        }
        UDate now = new UDate();
        if (checkDate.compareDateYMD(now) <= 0) {
            log__.info((Object)"\u30e9\u30a4\u30bb\u30f3\u30b9\u30d5\u30a1\u30a4\u30eb\u30c1\u30a7\u30c3\u30af\uff2f\uff2b\u3002");
            ret = true;
            return ret;
        }
        log__.warn((Object)"\u30e9\u30a4\u30bb\u30f3\u30b9\u30d5\u30a1\u30a4\u30eb [\u671f\u9650] \u304c\u65e2\u306b\u5207\u308c\u3066\u3044\u307e\u3059\u3002");
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validateImportLicense(ActionErrors errors, RequestModel reqMdl, File impFile, String gsUid) throws IOException {
        boolean ret = false;
        ActionMessage msg = null;
        GsMessage gsMsg = new GsMessage(reqMdl);
        if (impFile != null) {
            BufferedReader in = null;
            FileInputStream fis = null;
            try {
                boolean i;
                in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(impFile), "UTF-8"));
                String line = in.readLine();
                Object fileString = "";
                while (line != null) {
                    fileString = (String)fileString + line;
                    line = in.readLine();
                }
                if (StringUtil.isNullZeroStringSpace((String)fileString)) {
                    msg = new ActionMessage("error.input.format.text", (Object)gsMsg.getMessage("main.src.26"));
                    StrutsUtil.addMessage((ActionErrors)errors, (ActionMessage)msg, (String)"error.input.format.text");
                    boolean bl = ret;
                    return bl;
                }
                String decFileString = LicenseOperation.getDecryString((String)fileString);
                String[] splitString = decFileString.split("\r\n");
                if (splitString == null || splitString.length == 0) {
                    msg = new ActionMessage("error.input.format.text", (Object)gsMsg.getMessage("main.src.26"));
                    StrutsUtil.addMessage((ActionErrors)errors, (ActionMessage)msg, (String)"error.input.format.text");
                    boolean bl = ret;
                    return bl;
                }
                String idStr = "";
                String uidStr = "";
                String ldate_support = "";
                String ldate_mobile = "";
                String ldate_crossRide = "";
                String freesid = "";
                String idKey = "id=";
                String uidKey = "uid=";
                String comKey = "com=";
                String cdateKey = "cdate=";
                String ldateSupportKey = "plugin_ldate_support=";
                String ldateMobileKey = "plugin_ldate_mobile=";
                String ldateCrossRideKey = "plugin_crossRide=";
                String freeSid = "freesid=";
                for (i = false; i < splitString.length; i += 1) {
                    if (splitString[i].startsWith(idKey)) {
                        idStr = splitString[i].substring(idKey.length());
                        continue;
                    }
                    if (splitString[i].startsWith(uidKey)) {
                        uidStr = splitString[i].substring(uidKey.length());
                        continue;
                    }
                    if (splitString[i].startsWith(comKey) || splitString[i].startsWith(cdateKey)) continue;
                    if (splitString[i].startsWith(ldateSupportKey)) {
                        ldate_support = splitString[i].substring(ldateSupportKey.length());
                        continue;
                    }
                    if (splitString[i].startsWith(ldateMobileKey)) {
                        ldate_mobile = splitString[i].substring(ldateMobileKey.length());
                        continue;
                    }
                    if (splitString[i].startsWith(ldateCrossRideKey)) {
                        ldate_crossRide = splitString[i].substring(ldateCrossRideKey.length());
                        continue;
                    }
                    if (!splitString[i].startsWith(freeSid)) continue;
                    freesid = splitString[i].substring(freeSid.length());
                }
                if (idStr == null) {
                    msg = new ActionMessage("error.input.format.text", (Object)gsMsg.getMessage("main.src.26"));
                    StrutsUtil.addMessage((ActionErrors)errors, (ActionMessage)msg, (String)"error.input.format.text");
                    i = ret;
                    return i;
                }
                String decUid = "";
                if (!StringUtil.isNullZeroString((String)gsUid)) {
                    decUid = LicenseOperation.getDecryString(gsUid);
                }
                if (!decUid.equals(uidStr)) {
                    msg = new ActionMessage("error.input.format.file", (Object)gsMsg.getMessage("main.src.26"), (Object)gsMsg.getMessage("cmn.serial.number"));
                    StrutsUtil.addMessage((ActionErrors)errors, (ActionMessage)msg, (String)"error.input.format.file");
                    boolean e = ret;
                    return e;
                }
                int licExistCnt = 0;
                if (!ldate_support.equals("")) {
                    if (!this.__validateLicenseDate(errors, reqMdl, msg, ldate_support)) {
                        boolean bl = false;
                        return bl;
                    }
                    ++licExistCnt;
                }
                if (!ldate_mobile.equals("")) {
                    if (!this.__validateLicenseDate(errors, reqMdl, msg, ldate_mobile)) {
                        boolean bl = false;
                        return bl;
                    }
                    ++licExistCnt;
                }
                if (!ldate_crossRide.equals("")) {
                    if (!this.__validateLicenseDate(errors, reqMdl, msg, ldate_crossRide)) {
                        boolean bl = false;
                        return bl;
                    }
                    ++licExistCnt;
                }
                if (!freesid.equals("")) {
                    if (!this.__validateLicenseFree(errors, reqMdl, msg, freesid)) {
                        boolean bl = false;
                        return bl;
                    }
                    ++licExistCnt;
                }
                if (licExistCnt < 1) {
                    msg = new ActionMessage("error.input.format.text", (Object)gsMsg.getMessage("main.src.26"));
                    StrutsUtil.addMessage((ActionErrors)errors, (ActionMessage)msg, (String)"error.input.format.text");
                    boolean bl = ret;
                    return bl;
                }
                ret = true;
            }
            catch (FileNotFoundException e) {
                log__.error((Object)"FileNotFoundException", (Throwable)e);
                throw e;
            }
            catch (IOException e) {
                log__.error((Object)"IOException", (Throwable)e);
                throw e;
            }
            catch (EncryptionException e) {
                log__.error((Object)"EncryptionException", (Throwable)e);
                msg = new ActionMessage("error.input.format.text", (Object)gsMsg.getMessage("main.src.26"));
                StrutsUtil.addMessage((ActionErrors)errors, (ActionMessage)msg, (String)"error.input.required.text");
                boolean bl = ret;
                return bl;
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException e) {
                    log__.error((Object)"IOException", (Throwable)e);
                    throw e;
                }
            }
        }
        return ret;
    }

    private boolean __validateLicenseDate(ActionErrors errors, RequestModel reqMdl, ActionMessage msg, String ldate) throws IOException {
        boolean ret = false;
        GsMessage gsMsg = new GsMessage(reqMdl);
        if (ldate == null) {
            msg = new ActionMessage("error.input.format.text", (Object)gsMsg.getMessage("main.src.26"));
            StrutsUtil.addMessage((ActionErrors)errors, (ActionMessage)msg, (String)"error.input.format.text");
            return ret;
        }
        String[] splitLimitStr = ldate.split("/");
        if (splitLimitStr == null || splitLimitStr.length != 3) {
            msg = new ActionMessage("error.input.format.text", (Object)gsMsg.getMessage("main.src.26"));
            StrutsUtil.addMessage((ActionErrors)errors, (ActionMessage)msg, (String)"error.input.format.text");
            return ret;
        }
        if (!(ValidateUtil.isNumber((String)splitLimitStr[0]) && ValidateUtil.isNumber((String)splitLimitStr[1]) && ValidateUtil.isNumber((String)splitLimitStr[2]))) {
            msg = new ActionMessage("error.input.format.text", (Object)gsMsg.getMessage("main.src.26"));
            StrutsUtil.addMessage((ActionErrors)errors, (ActionMessage)msg, (String)"error.input.format.text");
            return ret;
        }
        int intYear = Integer.parseInt(splitLimitStr[0]);
        int intMonth = Integer.parseInt(splitLimitStr[1]);
        int intDay = Integer.parseInt(splitLimitStr[2]);
        UDate checkDate = new UDate();
        checkDate.setDate(intYear, intMonth, intDay);
        if (checkDate.getYear() != intYear || checkDate.getMonth() != intMonth || checkDate.getIntDay() != intDay) {
            msg = new ActionMessage("error.input.format.text", (Object)gsMsg.getMessage("main.src.26"));
            StrutsUtil.addMessage((ActionErrors)errors, (ActionMessage)msg, (String)"error.input.format.text");
            return ret;
        }
        ret = true;
        return ret;
    }

    private boolean __validateLicenseFree(ActionErrors errors, RequestModel reqMdl, ActionMessage msg, String freeSid) throws IOException {
        boolean ret = false;
        GsMessage gsMsg = new GsMessage(reqMdl);
        if (!ValidateUtil.isNumber((String)freeSid)) {
            msg = new ActionMessage("error.input.format.free", (Object)gsMsg.getMessage("main.src.26"));
            StrutsUtil.addMessage((ActionErrors)errors, (ActionMessage)msg, (String)"error.input.format.free");
            return ret;
        }
        ret = true;
        return ret;
    }

    public LicenseModel getLicenseFileData(File impFile) throws IOException, EncryptionException {
        LicenseModel ret = null;
        if (impFile != null) {
            BufferedReader in = null;
            FileInputStream fis = null;
            try {
                String decFileString;
                String[] splitString;
                in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(impFile), "UTF-8"));
                String line = in.readLine();
                Object fileString = "";
                while (line != null) {
                    fileString = (String)fileString + line;
                    line = in.readLine();
                }
                if (!StringUtil.isNullZeroStringSpace((String)fileString) && (splitString = (decFileString = LicenseOperation.getDecryString((String)fileString)).split("\r\n")) != null && splitString.length > 0) {
                    String idStr = "";
                    String comStr = "";
                    String cdateStr = "";
                    String ldate_support = "";
                    String ldate_mobile = "";
                    String ldate_crossRide = "";
                    String freesid = "";
                    String idKey = "id=";
                    String comKey = "com=";
                    String cdateKey = "cdate=";
                    String ldateSupportKey = "plugin_ldate_support=";
                    String ldateMobileKey = "plugin_ldate_mobile=";
                    String ldateCrossRideKey = "plugin_crossRide=";
                    String freeSid = "freesid=";
                    for (int i = 0; i < splitString.length; ++i) {
                        if (splitString[i].startsWith(idKey)) {
                            idStr = splitString[i].substring(idKey.length());
                            continue;
                        }
                        if (splitString[i].startsWith(comKey)) {
                            comStr = splitString[i].substring(comKey.length());
                            continue;
                        }
                        if (splitString[i].startsWith(cdateKey)) {
                            cdateStr = splitString[i].substring(cdateKey.length());
                            continue;
                        }
                        if (splitString[i].startsWith(ldateSupportKey)) {
                            ldate_support = splitString[i].substring(ldateSupportKey.length());
                            continue;
                        }
                        if (splitString[i].startsWith(ldateMobileKey)) {
                            ldate_mobile = splitString[i].substring(ldateMobileKey.length());
                            continue;
                        }
                        if (splitString[i].startsWith(ldateCrossRideKey)) {
                            ldate_crossRide = splitString[i].substring(ldateCrossRideKey.length());
                            continue;
                        }
                        if (!splitString[i].startsWith(freeSid)) continue;
                        freesid = splitString[i].substring(freeSid.length());
                    }
                    ret = new LicenseModel();
                    ret.setLicenseId(idStr);
                    ret.setLicenseCom(comStr);
                    ret.setLicenseCdate(cdateStr);
                    if (ldate_support != null) {
                        ret.setLicenseLimitSupport(ldate_support);
                    }
                    if (ldate_mobile != null) {
                        ret.setLicenseLimitMobile(ldate_mobile);
                    }
                    if (ldate_crossRide != null) {
                        ret.setLicenseLimitCrossRide(ldate_crossRide);
                    }
                    if (freesid != null) {
                        ret.setLicenseFreeSid(freesid);
                    }
                }
            }
            catch (FileNotFoundException e) {
                log__.error((Object)"FileNotFoundException", (Throwable)e);
                throw e;
            }
            catch (IOException e) {
                log__.error((Object)"IOException", (Throwable)e);
                throw e;
            }
            catch (EncryptionException e) {
                log__.error((Object)"EncryptionException", (Throwable)e);
                throw e;
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException e) {
                    log__.error((Object)"IOException", (Throwable)e);
                }
            }
        }
        return ret;
    }

    public void updateGSContext(File impFile, String domain, Connection con) throws IOException, EncryptionException, SQLException {
        if (impFile != null) {
            BufferedReader in = null;
            FileInputStream fis = null;
            try {
                String decFileString;
                String[] splitString;
                in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(impFile), "UTF-8"));
                String line = in.readLine();
                Object fileString = "";
                while (line != null) {
                    fileString = (String)fileString + line;
                    line = in.readLine();
                }
                if (!StringUtil.isNullZeroStringSpace((String)fileString) && (splitString = (decFileString = LicenseOperation.getDecryString((String)fileString)).split("\r\n")) != null && splitString.length > 0) {
                    String idStr = "";
                    String uidStr = "";
                    String numberStr = "";
                    String diskStr = "";
                    String comStr = "";
                    String cdateStr = "";
                    String ldate_support = "";
                    String ldate_mobile = "";
                    String ldate_crossRide = "";
                    String freesid = "";
                    String type = "";
                    String push_license_token = "";
                    String idKey = "id=";
                    String uidKey = "uid=";
                    String numberKey = "number=";
                    String diskkey = "disk=";
                    String comKey = "com=";
                    String cdateKey = "cdate=";
                    String ldateSupportKey = "plugin_ldate_support=";
                    String ldateMobileKey = "plugin_ldate_mobile=";
                    String ldateCrossRideKey = "plugin_crossRide=";
                    String freeSid = "freesid=";
                    String typeKey = "type=";
                    String pushLicenseTokenKey = "push_license_token=";
                    for (int i = 0; i < splitString.length; ++i) {
                        if (splitString[i].startsWith(idKey)) {
                            idStr = splitString[i].substring(idKey.length());
                            continue;
                        }
                        if (splitString[i].startsWith(uidKey)) {
                            uidStr = splitString[i].substring(uidKey.length());
                            continue;
                        }
                        if (splitString[i].startsWith(numberKey)) {
                            numberStr = splitString[i].substring(numberKey.length());
                            continue;
                        }
                        if (splitString[i].startsWith(comKey)) {
                            comStr = splitString[i].substring(comKey.length());
                            continue;
                        }
                        if (splitString[i].startsWith(cdateKey)) {
                            cdateStr = splitString[i].substring(cdateKey.length());
                            continue;
                        }
                        if (splitString[i].startsWith(ldateSupportKey)) {
                            ldate_support = splitString[i].substring(ldateSupportKey.length());
                            continue;
                        }
                        if (splitString[i].startsWith(ldateMobileKey)) {
                            ldate_mobile = splitString[i].substring(ldateMobileKey.length());
                            continue;
                        }
                        if (splitString[i].startsWith(ldateCrossRideKey)) {
                            ldate_crossRide = splitString[i].substring(ldateCrossRideKey.length());
                            continue;
                        }
                        if (splitString[i].startsWith(diskkey)) {
                            diskStr = splitString[i].substring(diskkey.length());
                            continue;
                        }
                        if (splitString[i].startsWith(freeSid)) {
                            freesid = splitString[i].substring(freeSid.length());
                            continue;
                        }
                        if (splitString[i].startsWith(typeKey)) {
                            type = splitString[i].substring(typeKey.length());
                            continue;
                        }
                        if (!splitString[i].startsWith(pushLicenseTokenKey)) continue;
                        push_license_token = splitString[i].substring(pushLicenseTokenKey.length());
                    }
                    LicenseModel lmdl = new LicenseModel();
                    lmdl.setLicenseId(idStr);
                    lmdl.setLicenseNumber(numberStr);
                    lmdl.setLicenseCom(comStr);
                    lmdl.setLicenseCdate(cdateStr);
                    lmdl.setGsUid(uidStr);
                    lmdl.setLicenseLimitSupport(LicenseOperation.getPluginLimit(ldate_support));
                    lmdl.setLicenseLimitMobile(LicenseOperation.getPluginLimit(ldate_mobile));
                    lmdl.setLicenseLimitCrossRide(LicenseOperation.getPluginLimit(ldate_crossRide));
                    lmdl.setLicenseDisk(diskStr);
                    lmdl.setLicenseFreeSid(freesid);
                    lmdl.setType(type);
                    lmdl.setPushLicenseToken(push_license_token);
                    GroupSession.getResourceManager().updateLicense(domain, (Object)lmdl);
                    PushServiceOperator.getInstance((Connection)con, (String)domain).removeJwt(con);
                }
            }
            catch (FileNotFoundException e) {
                log__.error((Object)"FileNotFoundException", (Throwable)e);
                throw e;
            }
            catch (IOException e) {
                log__.error((Object)"IOException", (Throwable)e);
                throw e;
            }
            catch (EncryptionException e) {
                log__.error((Object)"EncryptionException", (Throwable)e);
                throw e;
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException e) {
                    log__.error((Object)"IOException", (Throwable)e);
                }
            }
        }
    }

    public void updateLicenseFile(String appRoot, File impFile, String domain) throws IOException, IOToolsException {
        CommonBiz cmnBiz = new CommonBiz();
        String copyFilePath = cmnBiz.getSaveLicensePath(appRoot, domain);
        String copyFileFullPath = copyFilePath + "license";
        File copyFile = new File(copyFileFullPath);
        if (copyFile.exists()) {
            copyFile.delete();
        }
        IOTools.isFileCheck((String)copyFilePath, (String)"license", (boolean)true);
        IOTools.copyBinFile((File)impFile, (File)copyFile);
    }

    public static String getPluginLimit(String ldate) {
        String[] splitLimitStr;
        String limit = "";
        if (ldate != null && (splitLimitStr = ldate.split("/")) != null && splitLimitStr.length == 3 && ValidateUtil.isNumber((String)splitLimitStr[0]) && ValidateUtil.isNumber((String)splitLimitStr[1]) && ValidateUtil.isNumber((String)splitLimitStr[2])) {
            int intYear = Integer.parseInt(splitLimitStr[0]);
            int intMonth = Integer.parseInt(splitLimitStr[1]);
            int intDay = Integer.parseInt(splitLimitStr[2]);
            UDate checkDate = new UDate();
            checkDate.setDate(intYear, intMonth, intDay);
            if (checkDate.getYear() == intYear && checkDate.getMonth() == intMonth && checkDate.getIntDay() == intDay) {
                limit = ldate;
            }
        }
        return limit;
    }

    public boolean isValiableTime(int pluginKbn) {
        Integer[] inValiablePlugins = new Integer[]{0, 2};
        if (!Arrays.asList(inValiablePlugins).contains(pluginKbn)) {
            UDate now = new UDate();
            UDate fromDate = new UDate();
            fromDate.setZeroHhMmSs();
            fromDate.setHour(7);
            UDate toDate = new UDate();
            toDate.setZeroHhMmSs();
            toDate.setHour(8);
            toDate.setMinute(59);
            if (now.betweenYMDHM(fromDate, toDate)) {
                return true;
            }
        }
        return false;
    }

    public boolean isPushLicense(Connection con, String domain) {
        String dgsUid;
        boolean ret = false;
        LicenseModel lmdl = (LicenseModel)((Object)GroupSession.getResourceManager().getLicenseMdl(domain));
        if (lmdl == null) {
            log__.debug((Object)"\u30e9\u30a4\u30bb\u30f3\u30b9\u30d5\u30a1\u30a4\u30eb\u304c\u53d6\u308a\u8fbc\u307e\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
            return ret;
        }
        String lgsUid = lmdl.getGsUid();
        CmnContmDao dao = new CmnContmDao(con);
        try {
            dgsUid = LicenseOperation.getDecryString(dao.getGsUid());
        }
        catch (EncryptionException e) {
            log__.debug((Object)e.getMessage());
            return ret;
        }
        catch (SQLException e) {
            log__.debug((Object)e.getMessage());
            return ret;
        }
        if (!lgsUid.equals(dgsUid)) {
            log__.debug((Object)(lgsUid + "==========" + dgsUid));
            log__.debug((Object)"\u30b7\u30ea\u30a2\u30eb\u756a\u53f7\u4e0d\u4e00\u81f4");
            return false;
        }
        String strLimit = lmdl.getLicenseLimitMobile();
        if (StringUtil.isNullZeroStringSpace((String)strLimit)) {
            log__.debug((Object)"\u30e9\u30a4\u30bb\u30f3\u30b9\u30d5\u30a1\u30a4\u30eb [\u671f\u9650] \u306e\u5024\u304c\u4e0d\u6b63\u3067\u3059\u3002");
            return ret;
        }
        String[] splitLimitStr = strLimit.split("/");
        if (splitLimitStr == null || splitLimitStr.length != 3) {
            log__.debug((Object)"\u30e9\u30a4\u30bb\u30f3\u30b9\u30d5\u30a1\u30a4\u30eb [\u671f\u9650] \u306e\u5024\u304c\u4e0d\u6b63\u3067\u3059\u3002");
            return ret;
        }
        if (!(ValidateUtil.isNumber((String)splitLimitStr[0]) && ValidateUtil.isNumber((String)splitLimitStr[1]) && ValidateUtil.isNumber((String)splitLimitStr[2]))) {
            log__.debug((Object)"\u30e9\u30a4\u30bb\u30f3\u30b9\u30d5\u30a1\u30a4\u30eb [\u671f\u9650] \u306e\u5024\u304c\u4e0d\u6b63\u3067\u3059\u3002");
            return ret;
        }
        int intYear = Integer.parseInt(splitLimitStr[0]);
        int intMonth = Integer.parseInt(splitLimitStr[1]);
        int intDay = Integer.parseInt(splitLimitStr[2]);
        UDate checkDate = new UDate();
        checkDate.setDate(intYear, intMonth, intDay);
        if (checkDate.getYear() != intYear || checkDate.getMonth() != intMonth || checkDate.getIntDay() != intDay) {
            log__.debug((Object)"\u30e9\u30a4\u30bb\u30f3\u30b9\u30d5\u30a1\u30a4\u30eb [\u671f\u9650] \u306e\u5024\u304c\u4e0d\u6b63\u3067\u3059\u3002");
            return ret;
        }
        UDate now = new UDate();
        if (checkDate.compareDateYMD(now) > 0) {
            log__.debug((Object)"\u30e9\u30a4\u30bb\u30f3\u30b9\u671f\u9650\u5916");
            return ret;
        }
        if (StringUtil.isNullZeroStringSpace((String)lmdl.getType()) || StringUtil.isNullZeroStringSpace((String)lmdl.getPushLicenseToken())) {
            log__.debug((Object)"\u65e7\u30e9\u30a4\u30bb\u30f3\u30b9\u30d5\u30a1\u30a4\u30eb");
            return ret;
        }
        String typeIni = "";
        if (!StringUtil.isNullZeroString((String)lmdl.getType())) {
            typeIni = lmdl.getType().substring(0, 1);
        }
        switch (typeIni) {
            case "Z": 
            case "B": {
                break;
            }
            default: {
                log__.debug((Object)"\u7121\u6599\u7248\u5411\u3051\u30e9\u30a4\u30bb\u30f3\u30b9\u306f\u5bfe\u8c61\u5916");
                return ret;
            }
        }
        return true;
    }
}

