/*
 * Decompiled with CFR 0.152.
 */
package jp.groupsession.v2.lic.restapi;

import java.sql.Connection;
import java.sql.SQLException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.co.sjts.util.encryption.EncryptionException;
import jp.groupsession.v2.lic.LicenseOperation;
import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.restapi.exception.IReasonCode;
import jp.groupsession.v2.restapi.exception.RestApiPermissionException;
import jp.groupsession.v2.restapi.filter.IActionFilter;
import jp.groupsession.v2.restapi.filter.RestApiActionFilterChain;
import jp.groupsession.v2.restapi.filter.annotation.ActionFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ActionFilter(path="/restapi/common/users/*/authentications")
public class LiscenceCheckFilter
implements IActionFilter {
    private static Log log__ = LogFactory.getLog(LiscenceCheckFilter.class);

    public void doFilter(HttpServletRequest req, HttpServletResponse res, RestApiContext ctx, RestApiActionFilterChain chain) {
        Connection con = ctx.getCon();
        String domain = ctx.getRequestModel().getDomain();
        try {
            LicenseOperation licenseOp;
            if (req.getHeader("USER-AGENT").indexOf("GsMobileApps") >= 0) {
                log__.info((Object)"\u30e2\u30d0\u30a4\u30eb\u30e9\u30a4\u30bb\u30f3\u30b9\u30c1\u30a7\u30c3\u30af\u3092\u5b9f\u884c");
                licenseOp = new LicenseOperation();
                if (!licenseOp.isLicenseOk(1, con, domain)) {
                    throw new RestApiPermissionException((IReasonCode)ReasonCodeLicence.RESOURCE_LICENSE_MOBILE, "error.license.file.api", new Object[0]);
                }
                if (!licenseOp.isLicenseUserCount(1, con, domain)) {
                    throw new RestApiPermissionException((IReasonCode)ReasonCodeLicence.RESOURCE_LICENSE_MOBILE, "error.license.file.api", new Object[0]);
                }
            }
            if (req.getHeader("USER-AGENT").indexOf("GSCrossRide") >= 0) {
                log__.info((Object)"CrossRide\u30e9\u30a4\u30bb\u30f3\u30b9\u30c1\u30a7\u30c3\u30af\u3092\u5b9f\u884c");
                licenseOp = new LicenseOperation();
                if (!licenseOp.isLicenseOk(2, con, domain)) {
                    throw new RestApiPermissionException((IReasonCode)ReasonCodeLicence.RESOURCE_LICENSE_CROSSRIDE, "error.license.file.api", new Object[0]);
                }
                if (!licenseOp.isLicenseUserCount(2, con, domain)) {
                    throw new RestApiPermissionException((IReasonCode)ReasonCodeLicence.RESOURCE_LICENSE_CROSSRIDE, "error.license.file.api", new Object[0]);
                }
            }
        }
        catch (SQLException | EncryptionException e) {
            throw new RuntimeException(e);
        }
        chain.doFilter(req, res, ctx);
    }

    public static enum ReasonCodeLicence implements IReasonCode
    {
        RESOURCE_LICENSE_CROSSRIDE,
        RESOURCE_LICENSE_MOBILE;

    }
}

