/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.blip;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.InflaterInputStream;
import org.apache.poi.hslf.blip.Metafile;
import org.apache.poi.hslf.exceptions.HSLFException;
import org.apache.poi.sl.usermodel.PictureData;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;
import org.apache.poi.util.Units;

public final class WMF
extends Metafile {
    public byte[] getData() {
        try {
            int count;
            byte[] rawdata = this.getRawData();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ByteArrayInputStream is = new ByteArrayInputStream(rawdata);
            Metafile.Header header = new Metafile.Header();
            header.read(rawdata, 16 * this.uidInstanceCount);
            long len = ((InputStream)is).skip(header.getSize() + 16 * this.uidInstanceCount);
            assert (len == (long)(header.getSize() + 16 * this.uidInstanceCount));
            NativeHeader aldus = new NativeHeader(header.bounds);
            aldus.write(out);
            InflaterInputStream inflater = new InflaterInputStream(is);
            byte[] chunk = new byte[4096];
            while ((count = inflater.read(chunk)) >= 0) {
                out.write(chunk, 0, count);
            }
            inflater.close();
            return out.toByteArray();
        }
        catch (IOException e) {
            throw new HSLFException(e);
        }
    }

    public void setData(byte[] data) throws IOException {
        int pos = 0;
        NativeHeader nHeader = new NativeHeader(data, pos);
        byte[] compressed = WMF.compress(data, pos += nHeader.getLength(), data.length - pos);
        Metafile.Header header = new Metafile.Header();
        header.wmfsize = data.length - nHeader.getLength();
        header.bounds = new Rectangle((short)nHeader.left, (short)nHeader.top, (short)nHeader.right - (short)nHeader.left, (short)nHeader.bottom - (short)nHeader.top);
        Dimension nDim = nHeader.getSize();
        header.size = new Dimension(Units.toEMU((double)nDim.getWidth()), Units.toEMU((double)nDim.getHeight()));
        header.zipsize = compressed.length;
        byte[] checksum = WMF.getChecksum(data);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        for (int i = 0; i < this.uidInstanceCount; ++i) {
            out.write(checksum);
        }
        header.write(out);
        out.write(compressed);
        this.setRawData(out.toByteArray());
    }

    public PictureData.PictureType getType() {
        return PictureData.PictureType.WMF;
    }

    @Override
    public int getSignature() {
        return this.uidInstanceCount == 1 ? 8544 : 8560;
    }

    @Override
    public void setSignature(int signature) {
        switch (signature) {
            case 8544: {
                this.uidInstanceCount = 1;
                break;
            }
            case 8560: {
                this.uidInstanceCount = 2;
                break;
            }
            default: {
                throw new IllegalArgumentException(signature + " is not a valid instance/signature value for WMF");
            }
        }
    }

    public static class NativeHeader {
        public static final int APMHEADER_KEY = -1698247209;
        private static POILogger logger = POILogFactory.getLogger(NativeHeader.class);
        private final int handle;
        private final int left;
        private final int top;
        private final int right;
        private final int bottom;
        private final int inch;
        private final int reserved;
        private int checksum;

        public NativeHeader(Rectangle dim) {
            this.handle = 0;
            this.left = dim.x;
            this.top = dim.y;
            this.right = dim.x + dim.width;
            this.bottom = dim.y + dim.height;
            this.inch = 72;
            this.reserved = 0;
        }

        public NativeHeader(byte[] data, int pos) {
            int key = LittleEndian.getInt((byte[])data, (int)pos);
            pos += 4;
            if (key != -1698247209) {
                logger.log(5, new Object[]{"WMF file doesn't contain a placeable header - ignore parsing"});
                this.handle = 0;
                this.left = 0;
                this.top = 0;
                this.right = 200;
                this.bottom = 200;
                this.inch = 72;
                this.reserved = 0;
                return;
            }
            this.handle = LittleEndian.getUShort((byte[])data, (int)pos);
            this.left = LittleEndian.getShort((byte[])data, (int)(pos += 2));
            this.top = LittleEndian.getShort((byte[])data, (int)(pos += 2));
            this.right = LittleEndian.getShort((byte[])data, (int)(pos += 2));
            this.bottom = LittleEndian.getShort((byte[])data, (int)(pos += 2));
            this.inch = LittleEndian.getUShort((byte[])data, (int)(pos += 2));
            this.reserved = LittleEndian.getInt((byte[])data, (int)(pos += 2));
            this.checksum = LittleEndian.getShort((byte[])data, (int)(pos += 4));
            pos += 2;
            if (this.checksum != this.getChecksum()) {
                logger.log(5, new Object[]{"WMF checksum does not match the header data"});
            }
        }

        public int getChecksum() {
            int cs = 0;
            cs ^= 0xCDD7;
            cs ^= 0xFFFF9AC6;
            cs ^= this.left;
            cs ^= this.top;
            cs ^= this.right;
            cs ^= this.bottom;
            return cs ^= this.inch;
        }

        public void write(OutputStream out) throws IOException {
            byte[] header = new byte[22];
            int pos = 0;
            LittleEndian.putInt((byte[])header, (int)pos, (int)-1698247209);
            LittleEndian.putUShort((byte[])header, (int)(pos += 4), (int)0);
            LittleEndian.putUShort((byte[])header, (int)(pos += 2), (int)this.left);
            LittleEndian.putUShort((byte[])header, (int)(pos += 2), (int)this.top);
            LittleEndian.putUShort((byte[])header, (int)(pos += 2), (int)this.right);
            LittleEndian.putUShort((byte[])header, (int)(pos += 2), (int)this.bottom);
            LittleEndian.putUShort((byte[])header, (int)(pos += 2), (int)this.inch);
            LittleEndian.putInt((byte[])header, (int)(pos += 2), (int)0);
            this.checksum = this.getChecksum();
            LittleEndian.putUShort((byte[])header, (int)(pos += 4), (int)this.checksum);
            out.write(header);
        }

        public Dimension getSize() {
            double coeff = 72.0 / (double)this.inch;
            return new Dimension((int)Math.round((double)(this.right - this.left) * coeff), (int)Math.round((double)(this.bottom - this.top) * coeff));
        }

        public int getLength() {
            return 22;
        }
    }
}

