package jp.groupsession.v2.adr;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

import jp.groupsession.v2.adr.dao.AdrContactBinDao;
import jp.groupsession.v2.adr.dao.AdrContactDao;
import jp.groupsession.v2.adr.dao.AdrDatausedSumDao;
import jp.groupsession.v2.adr.model.AdrDatausedSumModel;
import jp.groupsession.v2.cmn.GSConst;

/**
 * <br>[機  能] アドレス帳プラグインの使用データサイズを操作するビジネスロジッククラス
 * <br>[解  説]
 * <br>[備  考]
 *
 * @author JTS
 */
public class AdrUsedDataBiz {

    /** DBコネクション */
    private Connection con__ = null;

    /**
     * <p>Default Constructor
     * @param con コネクション
     */
    public AdrUsedDataBiz(Connection con) {
        con__ = con;
    }

    /**
     * <p>con を取得します。
     * @return con
     */
    public Connection getCon() {
        return con__;
    }

    /**
     * <p>con をセットします。
     * @param con con
     */
    public void setCon(Connection con) {
        con__ = con;
    }

    /**
     * <br>[機  能] コンタクト履歴情報の使用データサイズを加算する
     * <br>[解  説]
     * <br>[備  考]
     * @param adcSidList コンタクト履歴SIDリスト
     * @param dataSize DBのデータ使用量
     * @throws SQLException SQL実行例外
     */
    public void insertContactSizeAdd(List<Integer> adcSidList, long dataSize) throws SQLException {
        if (adcSidList == null || adcSidList.isEmpty()) {
            return;
        }
        long contactSize = dataSize;

        //コンタクト履歴の添付ファイルサイズを取得
        AdrContactBinDao contactBinDao = new AdrContactBinDao(con__);
        long fileSize = contactBinDao.getSumFileSize(adcSidList);
        contactSize += fileSize;

        __insertContactSize(contactSize);
    }

    /**
     * <br>[機  能] コンタクト履歴情報の使用データサイズを減算する
     * <br>[解  説]
     * <br>[備  考]
     * @param adcSidList コンタクト履歴SIDリスト
     * @throws SQLException SQL実行例外
     */
    public void insertContactSizeRemove(List<Integer> adcSidList) throws SQLException {
        if (adcSidList == null || adcSidList.isEmpty()) {
            return;
        }
        //指定されたコンタクト履歴のデータサイズを取得
        AdrContactDao contactDao = new AdrContactDao(con__);
        long contactSize = contactDao.getDataSize(adcSidList);

        //コンタクト履歴の添付ファイルサイズを取得
        AdrContactBinDao contactBinDao = new AdrContactBinDao(con__);
        long fileSize = contactBinDao.getSumFileSize(adcSidList);
        contactSize += fileSize;

        contactSize *= -1;
        __insertContactSize(contactSize);
    }

    /**
     * <br>[機  能] コンタクト履歴情報の使用データサイズを登録する
     * <br>[解  説]
     * <br>[備  考]
     * @param contactSize データ使用量
     * @throws SQLException SQL実行例外
     */
    private void __insertContactSize(Long contactSize) throws SQLException {
        //使用データサイズを登録
        AdrDatausedSumModel dataUsedMdl = new AdrDatausedSumModel();
        dataUsedMdl.setSumType(GSConst.USEDDATA_SUMTYPE_DIFF);
        dataUsedMdl.setAdrContactSize(contactSize);
        AdrDatausedSumDao dataUsedDao = new AdrDatausedSumDao(con__);
        dataUsedDao.insert(dataUsedMdl);
    }
}
