package jp.groupsession.v2.api.biz;

import java.sql.Connection;
import java.sql.SQLException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMessage;

import jp.co.sjts.util.date.UDate;
import jp.co.sjts.util.struts.StrutsUtil;
import jp.groupsession.v2.api.dao.ApiTokenDao;
import jp.groupsession.v2.api.model.ApiTokenModel;
import jp.groupsession.v2.cmn.GSConst;
import jp.groupsession.v2.cmn.biz.GroupBiz;
import jp.groupsession.v2.cmn.dao.AuthDao;
import jp.groupsession.v2.cmn.dao.BaseUserModel;
import jp.groupsession.v2.cmn.dao.base.CmnBelongmDao;
import jp.groupsession.v2.cmn.login.LoginResultModel;
import jp.groupsession.v2.cmn.login.biz.ITokenAuthBiz;
import jp.groupsession.v2.usr.GSConstUser;

/**
 * <br>[機  能] トークン関連 ビジネスロジック
 * <br>[解  説]
 * <br>[備  考] トークン認証時、ログイン停止ユーザの連携API実行区分を確認しない。
 *
 * @author JTS
 */
public class TokenBiz extends ApiTokenBiz implements ITokenAuthBiz {

    /** Logging インスタンス */
    private static Log log__ = LogFactory.getLog(TokenBiz.class);

    @Override
    public LoginResultModel authToken(String token, Connection con) throws SQLException {
        LoginResultModel resultModel = new LoginResultModel();
        ApiTokenDao dao = new ApiTokenDao(con);
        ApiTokenModel mdl = dao.select(token);
        if (mdl == null || mdl.getAptJkbn() != 0) {
            resultModel.setErrCode(LoginResultModel.ECODE_TOKENNONE);
            resultModel.setErrors();
            return resultModel;
        }
        UDate now = new UDate();
        if (now.compare(now, mdl.getAptLimitDate()) == UDate.SMALL) {
            resultModel.setErrCode(LoginResultModel.ECODE_TOKENTIMEOVER);
            resultModel.setErrors();
            return resultModel;
        }
        AuthDao adao = new AuthDao(con);
        BaseUserModel smodel = null;
        try {
            smodel = adao.selectLogin(mdl.getUsrSid());
        } catch (SQLException e) {
            log__.error("SQL実行エラー:ログイン処理の実行に失敗", e);
            throw e;
        }
        //該当ユーザなし
        if (smodel == null) {
            resultModel.setErrCode(LoginResultModel.ECODE_USERNONE);
            resultModel.setErrors();
            return resultModel;
        } else if (smodel.getUsrsid() == 1) {
            //システムメールユーザはログイン不可
            resultModel.setErrCode(LoginResultModel.ECODE_SYSMAIL_LOGIN);
            resultModel.setErrors();
            return resultModel;
        }
        if (smodel.getUsrsid() > GSConstUser.USER_RESERV_SID
                && smodel.getUsrUkoFlg() == GSConst.YUKOMUKO_MUKO) {
            //ログイン停止ユーザはログイン不可
            resultModel.setErrCode(LoginResultModel.ECODE_LOGINTEISI_USER);
            resultModel.setErrors();
            return resultModel;
        }
        //所属グループ未設定の場合、ログイン不可
        CmnBelongmDao belongDao = new CmnBelongmDao(con);
        if (belongDao.selectUserBelongGroupSid(smodel.getUsrsid()).isEmpty()) {
            resultModel.setErrCode(LoginResultModel.ECODE_BELONGGRP_NONE);

            ActionErrors errors = new ActionErrors();
            ActionMessage msg = new ActionMessage("error.auth.notset.belonggroup.api");
            StrutsUtil.addMessage(errors, msg, "error.auth.notset.belonggroup.api");
            resultModel.setErrors(errors);

            return resultModel;
        }
        //デフォルトグループ未設定の場合、ログイン不可
        GroupBiz grpBiz = new GroupBiz();
        if (grpBiz.getDefaultGroupId(smodel.getUsrsid(), con) == null) {
            resultModel.setErrCode(LoginResultModel.ECODE_DEFGRP_NONE);

            ActionErrors errors = new ActionErrors();
            ActionMessage msg = new ActionMessage("error.auth.notset.defgroup.api");
            StrutsUtil.addMessage(errors, msg, "error.auth.notset.defgroup.api");
            resultModel.setErrors(errors);

            return resultModel;
        }
        resultModel.setLoginUser(smodel);
        return resultModel;
    }
}
