package jp.groupsession.v2.api.chat.send;

import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.upload.FormFile;

import jp.co.sjts.util.date.UDate;
import jp.co.sjts.util.http.TempFileUtil;
import jp.co.sjts.util.io.IOToolsException;
import jp.co.sjts.util.io.ObjectFile;
import jp.groupsession.v2.cht.GSConstChat;
import jp.groupsession.v2.cht.dao.ChatDao;
import jp.groupsession.v2.cht.model.ChatInformationModel;
import jp.groupsession.v2.cht.model.ChatSendEditModel;
import jp.groupsession.v2.cmn.GSConstCommon;
import jp.groupsession.v2.cmn.biz.CommonBiz;
import jp.groupsession.v2.cmn.cmn110.Cmn110Biz;
import jp.groupsession.v2.cmn.cmn110.Cmn110FileModel;
import jp.groupsession.v2.cmn.model.base.CmnUsrmInfModel;

/**
 * <br>[機  能] チャット投稿APIアクション
 * <br>[解  説]
 * <br>[備  考]
 *
 * @author JTS
 */
public class ApiChatSendBiz {

    /** Logging インスタンス */
    private static Log log__ = LogFactory.getLog(ApiChatSendBiz.class);

    /**
     * <br>[機  能] メッセージ送信用のモデルを作成する
     * <br>[解  説]
     * <br>[備  考]
     * @param selectKbn 1:ユーザ, 2:グループ
     * @param selectPartner 送信先ユーザSID/グループSID
     * @param messageText メッセージ本文
     * @return メッセージ送信用モデル
     */
    protected ChatSendEditModel _createMessageModel(
        int selectKbn, int selectPartner, String messageText) {
   
        return new ChatSendEditModel(
            selectKbn, selectPartner, -1, messageText, 0, List.of(), 0);
    }

    /**
     * <br>[機  能] 全ての添付ファイルをテンポラリディレクトリへ設定する
     * <br>[解  説]
     * <br>[備  考]
     * @param tempDir テンポラリディレクトリ
     * @param form フォーム
     * @throws IOToolsException IOエラー
     * @throws Exception エラー
     */
    public void setTempFileAll(String tempDir, ApiChatSendForm form)
    throws IOToolsException, Exception {

        setTempFile(tempDir, form.getTmpFile(), 1);

    }

    /**
     * <br>[機  能] 添付ファイルをテンポラリディレクトリへ設定する
     * <br>[解  説]
     * <br>[備  考]
     * @param tempDir テンポラリディレクトリ
     * @param formFile ファイルデータ
     * @param fileNum ファイル番号
     * @throws IOToolsException IOエラー
     * @throws Exception エラー
     */
    public void setTempFile(String tempDir, FormFile formFile, int fileNum)
    throws IOToolsException, Exception {

        if (formFile == null
                || formFile.getFileName() == null
                || formFile.getFileName().equals("")) {
            return;
        }
        String dateStr = (new UDate()).getDateString(); //現在日付の文字列(YYYYMMDD)

        //添付ファイル名
        String fileName = (new File(formFile.getFileName())).getName();
        long fileSize = formFile.getFileSize();
        //添付ファイル(本体)のパスを取得
        File saveFilePath = CommonBiz.getSaveFilePath(tempDir, dateStr, fileNum);

        //添付ファイルアップロード
        TempFileUtil.upload(formFile, tempDir, saveFilePath.getName());

        //オブジェクトファイルを設定
        File objFilePath = Cmn110Biz.getObjFilePath(tempDir, dateStr, fileNum);
        Cmn110FileModel fileMdl = new Cmn110FileModel();
        fileMdl.setFileName(fileName);
        fileMdl.setSaveFileName(saveFilePath.getName());
        fileMdl.setAtattiSize(fileSize);

        String[] fileVal = fileMdl.getSaveFileName().split(GSConstCommon.ENDSTR_SAVEFILE);
        log__.debug("*** セーブファイル = " + fileVal[0]);
        fileMdl.setSplitObjName(fileVal[0]);

        ObjectFile objFile = new ObjectFile(objFilePath.getParent(), objFilePath.getName());
        objFile.save(fileMdl);

    }

    /**
     * <br>[機  能] チャット相手の名称取得
     * <br>[解  説]
     * <br>[備  考]
     * @param partnerSid チャット相手のユーザ/グループSID
     * @param partnerKbn 1:ユーザ, 2:グループ
     * @param con コネクション
     * @return 名称
     * @throws SQLException SQLException
     */
    protected String _getPartnerName(
        int partnerSid, int partnerKbn, Connection con) throws SQLException {

        ChatDao chtDao = new ChatDao(con);

        String name = "";
        if (partnerKbn == GSConstChat.CHAT_KBN_USER) {
            CmnUsrmInfModel usrMdl = chtDao.getUser(partnerSid);
            name = usrMdl.getUsiName();
        } else {
            ChatInformationModel cimMdl = chtDao.getGroupInfoData(partnerSid);
            name = cimMdl.getChatName();
        }
        return name;
    }

}