package jp.groupsession.v2.api.chat.send;

import java.sql.Connection;
import java.sql.SQLException;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.upload.FormFile;

import jp.co.sjts.util.NullDefault;
import jp.co.sjts.util.io.IOToolsException;
import jp.co.sjts.util.struts.StrutsUtil;
import jp.groupsession.v2.api.AbstractApiForm;
import jp.groupsession.v2.cht.ChatValidate;
import jp.groupsession.v2.cht.GSConstChat;
import jp.groupsession.v2.cmn.annotation.ApiClass;
import jp.groupsession.v2.cmn.annotation.ApiParam;
import jp.groupsession.v2.cmn.dao.BaseUserModel;
import jp.groupsession.v2.cmn.model.RequestModel;
import jp.groupsession.v2.struts.msg.GsMessage;

/**
 * <br>[機  能] チャット投稿APIのフォーム
 * <br>[解  説]
 * <br>[備  考]
 *
 * @author JTS
 */
@ApiClass(id = "chat-send",
plugin = "chat", name = "メッセージ送信",
url = "/api/chat/send.do", reqtype = "POST")
public class ApiChatSendForm extends AbstractApiForm {

    /** チャット区分 */
    @ApiParam(name = "sendKbn", viewName = "チャット区分")
    private String sendKbn__ = null;
    /** 区分ID */
    @ApiParam(name = "selectId", viewName = "区分ID")
    private String selectId__ = null;
    /** 投稿内容 */
    @ApiParam(name = "body", viewName = "投稿内容", required = false, confRequired = true)
    private String body__ = null;
    /** 添付ファイル */
    private FormFile tmpFile__ = null;

    /**
     * <br>[機  能] 入力チェックを行う
     * <br>[解  説]
     * <br>[備  考]
     * @param con コネクション
     * @param gsMsg GsMessage
     * @return エラー
     */
    public ActionErrors validateKbn(Connection con, GsMessage gsMsg) {
        ActionErrors errors = new ActionErrors();
        int sendKbn = NullDefault.getInt(sendKbn__, -1);

        // チャット区分
        if (sendKbn != GSConstChat.CHAT_KBN_USER
                && sendKbn != GSConstChat.CHAT_KBN_GROUP) {
                   ActionMessage msg =  new ActionMessage("error.input.format.file",
                           gsMsg.getMessage("cht.01") + gsMsg.getMessage("tcd.tcd070.03"),
                           gsMsg.getMessage("main.man340.10"));
                   String eprefix = "sendKbn__";
                   StrutsUtil.addMessage(errors, msg, eprefix);
        }

        return errors;
    }

    /**
     * <br>[機  能] 入力チェックを行う
     * <br>[解  説]
     * <br>[備  考]
     * @param con コネクション
     * @param umodel ユーザ情報モデル
     * @param gsMsg GsMessage
     * @param reqMdl RequestModel
     * @param fileFlg ファイル存在フラグ
     * @return エラー
     * @throws SQLException SQL実行時例外
     * @throws IOToolsException ファイル操作時例外
     */
    public ActionErrors validateChatApi(
            Connection con, BaseUserModel umodel, GsMessage gsMsg,
            RequestModel reqMdl, boolean fileFlg)
    throws SQLException, IOToolsException {
        ActionErrors errors = new ActionErrors();
        int sendKbn = NullDefault.getInt(sendKbn__, -1);

        // チャット区分
        if (sendKbn != GSConstChat.CHAT_KBN_USER
                && sendKbn != GSConstChat.CHAT_KBN_GROUP) {
                   ActionMessage msg =  new ActionMessage("error.input.format.file",
                           gsMsg.getMessage("cht.01") + gsMsg.getMessage("tcd.tcd070.03"),
                           gsMsg.getMessage("main.man340.10"));
                   String eprefix = "sendKbn__";
                   StrutsUtil.addMessage(errors, msg, eprefix);
        }

        // 投稿内容
        errors = ChatValidate.validateChtAllFieldText(
                errors,
                gsMsg.getMessage("cmn.message"),
                body__,
                "message",
                !fileFlg,
                true);
        if (!errors.isEmpty()) {
            return errors;
        }

        // 添付ファイル
        if (fileFlg) {
            errors = ChatValidate.validateTempFile(con, reqMdl, tmpFile__);
        }

        return errors;
    }



    /**
     * <p>body を取得します。
     * @return body
     * @see jp.groupsession.v2.api.chat.send.ApiChatSendForm#body__
     */
    public String getBody() {
        return body__;
    }

    /**
     * <p>body をセットします。
     * @param body body
     * @see jp.groupsession.v2.api.chat.send.ApiChatSendForm#body__
     */
    public void setBody(String body) {
        body__ = body;
    }

    /**
     * <p>tmpFile を取得します。
     * @return tmpFile
     * @see jp.groupsession.v2.api.chat.send.ApiChatSendForm#tmpFile__
     */
    public FormFile getTmpFile() {
        return tmpFile__;
    }

    /**
     * <p>tmpFile をセットします。
     * @param tmpFile tmpFile
     * @see jp.groupsession.v2.api.chat.send.ApiChatSendForm#tmpFile__
     */
    public void setTmpFile(FormFile tmpFile) {
        tmpFile__ = tmpFile;
    }



    /**
     * <p>sendKbn を取得します。
     * @return sendKbn
     * @see jp.groupsession.v2.api.chat.send.ApiChatSendForm#sendKbn__
     */
    public String getSendKbn() {
        return sendKbn__;
    }



    /**
     * <p>sendKbn をセットします。
     * @param sendKbn sendKbn
     * @see jp.groupsession.v2.api.chat.send.ApiChatSendForm#sendKbn__
     */
    public void setSendKbn(String sendKbn) {
        sendKbn__ = sendKbn;
    }



    /**
     * <p>selectId を取得します。
     * @return selectId
     * @see jp.groupsession.v2.api.chat.send.ApiChatSendForm#selectId__
     */
    public String getSelectId() {
        return selectId__;
    }



    /**
     * <p>selectId をセットします。
     * @param selectId selectId
     * @see jp.groupsession.v2.api.chat.send.ApiChatSendForm#selectId__
     */
    public void setSelectId(String selectId) {
        selectId__ = selectId;
    }
}
