package jp.groupsession.v2.bmk.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import jp.co.sjts.util.dao.AbstractDao;
import jp.co.sjts.util.jdbc.JDBCUtil;
import jp.co.sjts.util.jdbc.SqlBuffer;
import jp.groupsession.v2.bmk.model.BmkDatausedSumModel;
import jp.groupsession.v2.cmn.GSConst;

/**
 * <p>BMK_DATAUSED_SUM Data Access Object
 *
 * @author JTS DaoGenerator version 0.5
 */
public class BmkDatausedSumDao extends AbstractDao {

    /** Logging インスタンス */
    private static Log log__ = LogFactory.getLog(BmkDatausedSumDao.class);

    /**
     * <p>Default Constructor
     */
    public BmkDatausedSumDao() {
    }

    /**
     * <p>Set Connection
     * @param con Connection
     */
    public BmkDatausedSumDao(Connection con) {
        super(con);
    }

    /**
     * <p>Drop Table
     * @throws SQLException SQL実行例外
     */
    public void dropTable() throws SQLException {

        PreparedStatement pstmt = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql("drop table BMK_DATAUSED_SUM");

            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info(sql.toLogString());
            pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
    }

    /**
     * <p>Create Table
     * @throws SQLException SQL実行例外
     */
    public void createTable() throws SQLException {

        PreparedStatement pstmt = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" create table BMK_DATAUSED_SUM (");
            sql.addSql("   SUM_TYPE integer,");
            sql.addSql("   BMK_BOOKMARK_SIZE bigint not null");
            sql.addSql(" )");

            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info(sql.toLogString());
            pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
    }

    /**
     * <p>Insert BMK_DATAUSED_SUM Data Bindding JavaBean
     * @param bean BMK_DATAUSED_SUM Data Bindding JavaBean
     * @throws SQLException SQL実行例外
     */
    public void insert(BmkDatausedSumModel bean) throws SQLException {

        PreparedStatement pstmt = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" insert ");
            sql.addSql(" into ");
            sql.addSql(" BMK_DATAUSED_SUM(");
            sql.addSql("   SUM_TYPE,");
            sql.addSql("   BMK_BOOKMARK_SIZE");
            sql.addSql(" )");
            sql.addSql(" values");
            sql.addSql(" (");
            sql.addSql("   ?,");
            sql.addSql("   ?");
            sql.addSql(" )");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addIntValue(bean.getSumType());
            sql.addLongValue(bean.getBmkBookmarkSize());
            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
    }

    /**
     * <p>Update BMK_DATAUSED_SUM Data Bindding JavaBean
     * @param bean BMK_DATAUSED_SUM Data Bindding JavaBean
     * @return 更新件数
     * @throws SQLException SQL実行例外
     */
    public int update(BmkDatausedSumModel bean) throws SQLException {

        PreparedStatement pstmt = null;
        int count = 0;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" update");
            sql.addSql("   BMK_DATAUSED_SUM");
            sql.addSql(" set ");
            sql.addSql("   SUM_TYPE=?,");
            sql.addSql("   BMK_BOOKMARK_SIZE=?");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addIntValue(bean.getSumType());
            sql.addLongValue(bean.getBmkBookmarkSize());

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            count = pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
        return count;
    }

    /**
     * <p>Select BMK_DATAUSED_SUM All Data
     * @return List in BMK_DATAUSED_SUMModel
     * @throws SQLException SQL実行例外
     */
    public List<BmkDatausedSumModel> select() throws SQLException {

        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        ArrayList<BmkDatausedSumModel> ret = new ArrayList<BmkDatausedSumModel>();
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select ");
            sql.addSql("   SUM_TYPE,");
            sql.addSql("   BMK_BOOKMARK_SIZE");
            sql.addSql(" from ");
            sql.addSql("   BMK_DATAUSED_SUM");

            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info(sql.toLogString());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                ret.add(__getBmkDatausedSumFromRs(rs));
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeResultSet(rs);
            JDBCUtil.closeStatement(pstmt);
        }
        return ret;
    }

    /**
     * <br>[機  能] 使用データサイズの「集計」を取得する
     * <br>[解  説]
     * <br>[備  考]
     * @return 使用データサイズの「集計」
     * @throws SQLException
     */
    public BmkDatausedSumModel getTotalData() throws SQLException {

        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        BmkDatausedSumModel ret = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select ");
            sql.addSql("   SUM_TYPE,");
            sql.addSql("   BMK_BOOKMARK_SIZE");
            sql.addSql(" from ");
            sql.addSql("   BMK_DATAUSED_SUM");
            sql.addSql(" where ");
            sql.addSql("   SUM_TYPE = ?");
            sql.addIntValue(GSConst.USEDDATA_SUMTYPE_TOTAL);

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.setParameter(pstmt);
            log__.info(sql.toLogString());
            rs = pstmt.executeQuery();
            if (rs.next()) {
                ret = __getBmkDatausedSumFromRs(rs);
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeResultSet(rs);
            JDBCUtil.closeStatement(pstmt);
        }
        return ret;
    }

    /**
     * <br>[機  能] 使用データサイズの集計を取得する
     * <br>[解  説]
     * <br>[備  考]
     * @return 使用データサイズの集計
     * @throws SQLException
     */
    public BmkDatausedSumModel getSumData() throws SQLException {

        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        BmkDatausedSumModel ret = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select ");
            sql.addSql("   sum(BMK_BOOKMARK_SIZE) as SUM_BMK_BOOKMARK_SIZE");
            sql.addSql(" from ");
            sql.addSql("   BMK_DATAUSED_SUM");

            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info(sql.toLogString());
            rs = pstmt.executeQuery();
            if (rs.next()) {
                ret = new BmkDatausedSumModel();
                ret.setBmkBookmarkSize(rs.getLong("SUM_BMK_BOOKMARK_SIZE"));
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeResultSet(rs);
            JDBCUtil.closeStatement(pstmt);
        }
        return ret;
    }

    /**
     * <p>Delete BMK_DATAUSED_SUM
     * @return delete count
     * @throws SQLException SQL実行例外
     */
    public int delete() throws SQLException {

        PreparedStatement pstmt = null;
        int count = 0;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" delete");
            sql.addSql(" from");
            sql.addSql("   BMK_DATAUSED_SUM");

            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info(sql.toLogString());
            count = pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
        return count;
    }

    /**
    *
    * <br>[機  能] データ削除時の差分値の作成
    * <br>[解  説]
    * <br>[備  考]
    * @param sidList 削除対象SID
    * @throws SQLException SQL実行時例外
    */
    public void insertDelDiff(List<Integer> sidList) throws SQLException {
        __insertDiff(sidList, -1);
    }
    /**
    *
    * <br>[機  能] データ追加時の差分値の作成
    * <br>[解  説]
    * <br>[備  考]
    * @param dataSize データ使用量
    * @throws SQLException SQL実行時例外
    */
    public void insertAddDiff(long dataSize) throws SQLException {
        BmkDatausedSumModel mdl = new BmkDatausedSumModel();
        mdl.setSumType(GSConst.USEDDATA_SUMTYPE_DIFF);
        mdl.setBmkBookmarkSize(dataSize);
        insert(mdl);
    }

    /**
    *
    * <br>[機  能] 差分値の作成
    * <br>[解  説]
    * <br>[備  考]
    * @param sidList 対象SID
    * @param keisu 追加時：１ 削除時 -1
    * @throws SQLException SQL実行時例外
    */
    private void __insertDiff(List<Integer> sidList, int keisu) throws SQLException {

        if (sidList == null || sidList.size() == 0) {
            return;
        }

        Connection con = null;
        con = getCon();

        BmkBookmarkDao bmkDao = new BmkBookmarkDao(con);

        BmkDatausedSumModel mdl = new BmkDatausedSumModel();
        mdl.setSumType(GSConst.USEDDATA_SUMTYPE_DIFF);
        mdl.setBmkBookmarkSize(keisu * bmkDao.getDiskSize(sidList));
        insert(mdl);
    }

    /**
     * <p>Create BMK_DATAUSED_SUM Data Bindding JavaBean From ResultSet
     * @param rs ResultSet
     * @return created BmkDatausedSumModel
     * @throws SQLException SQL実行例外
     */
    private BmkDatausedSumModel __getBmkDatausedSumFromRs(ResultSet rs) throws SQLException {
        BmkDatausedSumModel bean = new BmkDatausedSumModel();
        bean.setSumType(rs.getInt("SUM_TYPE"));
        bean.setBmkBookmarkSize(rs.getLong("BMK_BOOKMARK_SIZE"));
        return bean;
    }
}
